/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.rest;

import ch.swisscom.mid.client.MIDFlowException;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.ComProtocol;
import ch.swisscom.mid.client.config.ConfigurationException;
import ch.swisscom.mid.client.config.ProxyConfiguration;
import ch.swisscom.mid.client.config.RequestTrace;
import ch.swisscom.mid.client.config.ResponseTrace;
import ch.swisscom.mid.client.config.TlsConfiguration;
import ch.swisscom.mid.client.config.TrafficObserver;
import ch.swisscom.mid.client.impl.ComProtocolHandler;
import ch.swisscom.mid.client.model.FailureReason;
import ch.swisscom.mid.client.model.ProfileRequest;
import ch.swisscom.mid.client.model.ProfileResponse;
import ch.swisscom.mid.client.model.ReceiptMessagingMode;
import ch.swisscom.mid.client.model.ReceiptRequest;
import ch.swisscom.mid.client.model.ReceiptResponse;
import ch.swisscom.mid.client.model.SignatureRequest;
import ch.swisscom.mid.client.model.SignatureResponse;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.rest.FaultProcessor;
import ch.swisscom.mid.client.rest.ProfileRequestModelUtils;
import ch.swisscom.mid.client.rest.ReceiptRequestModelUtils;
import ch.swisscom.mid.client.rest.SignatureRequestModelUtils;
import ch.swisscom.mid.client.rest.StatusQueryModelUtils;
import ch.swisscom.mid.client.rest.model.fault.MSSFault;
import ch.swisscom.mid.client.rest.model.profqreq.MSSProfileQueryRequest;
import ch.swisscom.mid.client.rest.model.profqresp.MSSProfileQueryResponse;
import ch.swisscom.mid.client.rest.model.receiptreq.MSSReceiptRequest;
import ch.swisscom.mid.client.rest.model.receiptresp.MSSReceiptResponse;
import ch.swisscom.mid.client.rest.model.signreq.MSSSignatureRequest;
import ch.swisscom.mid.client.rest.model.signresp.MSSSignatureResponse;
import ch.swisscom.mid.client.rest.model.statusreq.MSSStatusRequest;
import ch.swisscom.mid.client.rest.model.statusresp.MSSStatusResponse;
import ch.swisscom.mid.client.utils.Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComProtocolHandlerRestImpl
implements ComProtocolHandler {
    private static final Logger logConfig = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.config");
    private static final Logger logProtocol = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.protocol");
    private static final Logger logReqResp = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.requestResponse");
    private static final Logger logFullReqResp = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.fullRequestResponse");
    private ClientConfiguration config;
    private ObjectMapper jacksonMapper;
    private CloseableHttpClient httpClient;
    private RequestConfig httpRequestConfig;

    public ComProtocol getImplementedComProtocol() {
        return ComProtocol.REST;
    }

    public void initialize(ClientConfiguration config) {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        this.config = config;
        this.jacksonMapper = new ObjectMapper();
        this.jacksonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TlsConfiguration tlsConfig = config.getTls();
        this.logTlsConfiguration(tlsConfig);
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom().loadKeyMaterial(this.produceAKeyStore(tlsConfig), tlsConfig.getKeyStoreKeyPassword() == null ? null : tlsConfig.getKeyStoreKeyPassword().toCharArray(), this.produceAPrivateKeyStrategy(tlsConfig));
            if (this.trustStoreIsConfigured(tlsConfig)) {
                sslContextBuilder.loadTrustMaterial(this.produceATrustStore(tlsConfig), null);
            }
            sslConnectionSocketFactory = tlsConfig.isHostnameVerification() ? new SSLConnectionSocketFactory(sslContextBuilder.build()) : new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to configure the TLS/SSL connection factory for the MID client", (Throwable)e);
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (config.getProxy().isEnabled()) {
            ProxyConfiguration proxyConfig = config.getProxy();
            this.logProxyConfiguration(proxyConfig);
            String proxyHost = proxyConfig.getHost();
            int proxyPort = proxyConfig.getPort();
            if (proxyConfig.getUsername() != null) {
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyConfig.getUsername().trim(), proxyConfig.getPassword().trim().toCharArray()));
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            this.httpRequestConfig = RequestConfig.custom().setProxy(proxy).build();
        }
        this.logHttpConnectionConfiguration(config);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(config.getHttp().getMaxTotalConnections()).setMaxConnPerRoute(config.getHttp().getMaxConnectionsPerRoute()).setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        RequestConfig httpClientRequestConfig = RequestConfig.custom().setConnectTimeout((long)config.getHttp().getConnectionTimeoutInMs(), TimeUnit.MILLISECONDS).setResponseTimeout((long)config.getHttp().getResponseTimeoutInMs(), TimeUnit.MILLISECONDS).build();
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(httpClientRequestConfig).build();
    }

    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public SignatureResponse requestSyncSignature(SignatureRequest request) {
        MSSSignatureRequest requestWrapper = SignatureRequestModelUtils.createSignatureRequest(this.config, request, true);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), requestWrapper.getMSSSignatureReq().getAPInfo().getAPTransID());
        MSSSignatureResponse responseWrapper = this.sendAndReceive("MSS Signature (sync)", this.config.getUrls().getSignatureServiceUrl(), requestWrapper, MSSSignatureResponse.class, request.getTrafficObserver());
        SignatureResponse signatureResponse = SignatureRequestModelUtils.processSignatureResponse(responseWrapper);
        signatureResponse.setTracking(SignatureRequestModelUtils.createSignatureTracking(responseWrapper, request.getTrafficObserver(), request.getOverrideApId(), request.getOverrideApPassword()));
        return signatureResponse;
    }

    public SignatureResponse requestAsyncSignature(SignatureRequest request) {
        MSSSignatureRequest requestWrapper = SignatureRequestModelUtils.createSignatureRequest(this.config, request, false);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), requestWrapper.getMSSSignatureReq().getAPInfo().getAPTransID());
        MSSSignatureResponse responseWrapper = this.sendAndReceive("MSS Signature (async)", this.config.getUrls().getSignatureServiceUrl(), requestWrapper, MSSSignatureResponse.class, request.getTrafficObserver());
        SignatureResponse signatureResponse = SignatureRequestModelUtils.processSignatureResponse(responseWrapper);
        signatureResponse.setTracking(SignatureRequestModelUtils.createSignatureTracking(responseWrapper, request.getTrafficObserver(), request.getOverrideApId(), request.getOverrideApPassword()));
        return signatureResponse;
    }

    public SignatureResponse pollForSignatureStatus(SignatureTracking signatureTracking) {
        MSSStatusRequest requestWrapper = StatusQueryModelUtils.createStatusQueryRequest(this.config, signatureTracking);
        MSSStatusResponse responseWrapper = this.sendAndReceive("MSS Status Query", this.config.getUrls().getStatusQueryServiceUrl(), requestWrapper, MSSStatusResponse.class, signatureTracking.getTrafficObserver());
        return StatusQueryModelUtils.processStatusQueryResponse(responseWrapper, signatureTracking);
    }

    public ReceiptResponse requestSyncReceipt(SignatureTracking signatureTracking, ReceiptRequest request) {
        MSSReceiptRequest requestWrapper = ReceiptRequestModelUtils.createReceiptRequest(this.config, signatureTracking, request);
        if (request.getRequestExtension() != null && request.getRequestExtension().getMessagingMode() != ReceiptMessagingMode.SYNC) {
            throw new UnsupportedOperationException("There is no support for non-sync MSS Receipt Request");
        }
        String operationName = "MSS Receipt (sync)";
        MSSReceiptResponse responseWrapper = this.sendAndReceive(operationName, this.config.getUrls().getReceiptServiceUrl(), requestWrapper, MSSReceiptResponse.class, signatureTracking.getTrafficObserver());
        return ReceiptRequestModelUtils.processReceiptResponse(responseWrapper);
    }

    public ProfileResponse requestProfile(ProfileRequest request) {
        MSSProfileQueryRequest requestWrapper = ProfileRequestModelUtils.createProfileQueryRequest(request, this.config);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), requestWrapper.getMSSProfileReq().getAPInfo().getAPTransID());
        MSSProfileQueryResponse responseWrapper = this.sendAndReceive("MSS Profile Query", this.config.getUrls().getProfileQueryServiceUrl(), requestWrapper, MSSProfileQueryResponse.class, request.getTrafficObserver());
        return ProfileRequestModelUtils.processProfileQueryResponse(responseWrapper);
    }

    private void logHttpConnectionConfiguration(ClientConfiguration config) {
        logConfig.info("Configuring HTTP client: connection timeout [{}], response timeout [{}], max HTTP connections (total) [{}], HTTP connections per route [{}]", new Object[]{config.getHttp().getConnectionTimeoutInMs(), config.getHttp().getResponseTimeoutInMs(), config.getHttp().getMaxTotalConnections(), config.getHttp().getMaxConnectionsPerRoute()});
    }

    private void logProxyConfiguration(ProxyConfiguration config) {
        logConfig.info("Configuring PROXY parameters: enabled [{}], host [{}], port [{}], username [{}], password [{}]", new Object[]{config.isEnabled(), config.getHost(), config.getPort(), config.getUsername(), config.getPassword() != null ? "(not-null)" : "null"});
    }

    private PrivateKeyStrategy produceAPrivateKeyStrategy(TlsConfiguration tlsConfig) {
        return (aliases, sslParameters) -> tlsConfig.getKeyStoreCertificateAlias();
    }

    private void logTlsConfiguration(TlsConfiguration tlsConfig) {
        String keyStoreSource = tlsConfig.getKeyStoreFile() != null ? "file: [" + tlsConfig.getKeyStoreFile() + "]" : (tlsConfig.getKeyStoreClasspathFile() != null ? "classpath: [" + tlsConfig.getKeyStoreClasspathFile() + "]" : "input stream (byte content)");
        String trustStoreSource = tlsConfig.getTrustStoreFile() != null ? "file: [" + tlsConfig.getTrustStoreFile() + "]" : (tlsConfig.getTrustStoreClasspathFile() != null ? "classpath: [" + tlsConfig.getTrustStoreClasspathFile() + "]" : "input stream (byte content)");
        logConfig.info("Configuring TLS connection factory for MID client: key store source: [{}], key store type: [{}], key store alias: [{}], trust store source: [{}], trust store type: [{}]", new Object[]{keyStoreSource, tlsConfig.getKeyStoreType(), tlsConfig.getKeyStoreCertificateAlias(), trustStoreSource, tlsConfig.getTrustStoreType()});
    }

    private KeyStore produceAKeyStore(TlsConfiguration tlsConfig) {
        try {
            KeyStore keyStore = KeyStore.getInstance(tlsConfig.getKeyStoreType());
            if (tlsConfig.getKeyStoreFile() != null) {
                try (FileInputStream is = new FileInputStream(tlsConfig.getKeyStoreFile());){
                    keyStore.load(is, tlsConfig.getKeyStorePassword() == null ? null : tlsConfig.getKeyStorePassword().toCharArray());
                }
            }
            if (tlsConfig.getKeyStoreClasspathFile() != null) {
                try (InputStream is = this.getClass().getResourceAsStream(tlsConfig.getKeyStoreClasspathFile());){
                    keyStore.load(is, tlsConfig.getKeyStorePassword() == null ? null : tlsConfig.getKeyStorePassword().toCharArray());
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(tlsConfig.getKeyStoreBytes());){
                keyStore.load(is, tlsConfig.getKeyStorePassword() == null ? null : tlsConfig.getKeyStorePassword().toCharArray());
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to initialize the TLS keystore", (Throwable)e);
        }
    }

    private boolean trustStoreIsConfigured(TlsConfiguration tlsConfig) {
        return tlsConfig.getTrustStoreFile() != null || tlsConfig.getTrustStoreClasspathFile() != null || tlsConfig.getTrustStoreBytes() != null;
    }

    private KeyStore produceATrustStore(TlsConfiguration tlsConfig) {
        try {
            KeyStore keyStore = KeyStore.getInstance(tlsConfig.getTrustStoreType());
            if (tlsConfig.getTrustStoreFile() != null) {
                try (FileInputStream is = new FileInputStream(tlsConfig.getTrustStoreFile());){
                    keyStore.load(is, tlsConfig.getTrustStorePassword() == null ? null : tlsConfig.getTrustStorePassword().toCharArray());
                }
            }
            if (tlsConfig.getTrustStoreClasspathFile() != null) {
                try (InputStream is = this.getClass().getResourceAsStream(tlsConfig.getTrustStoreClasspathFile());){
                    keyStore.load(is, tlsConfig.getTrustStorePassword() == null ? null : tlsConfig.getTrustStorePassword().toCharArray());
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(tlsConfig.getTrustStoreBytes());){
                keyStore.load(is, tlsConfig.getTrustStorePassword() == null ? null : tlsConfig.getTrustStorePassword().toCharArray());
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to initialize the TLS truststore", (Throwable)e);
        }
    }

    private <TReq, TResp> TResp sendAndReceive(String operationName, String serviceUrl, TReq requestObject, Class<TResp> responseClass, TrafficObserver trafficObserver) {
        MSSFault faultWrapper;
        Object responseWrapper;
        block21: {
            String requestJson;
            logProtocol.debug("{}: Serializing object of type {} to JSON", (Object)operationName, (Object)requestObject.getClass().getSimpleName());
            FaultProcessor faultProcessor = new FaultProcessor();
            try {
                requestJson = this.jacksonMapper.writeValueAsString(requestObject);
            }
            catch (JsonProcessingException e) {
                throw new MIDFlowException("Failed to serialize request object to JSON, for operation " + operationName, (Throwable)e, faultProcessor.processException((Exception)((Object)e), FailureReason.REQUEST_PREPARATION_FAILURE));
            }
            this.notifyTrafficObserverForRequest(trafficObserver, requestJson);
            HttpPost httpPost = new HttpPost(serviceUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(requestJson, ContentType.APPLICATION_JSON, "UTF-8", false));
            httpPost.setConfig(this.httpRequestConfig);
            logProtocol.info("{}: Sending request to: [{}]", (Object)operationName, (Object)serviceUrl);
            logReqResp.info("{}: Sending JSON to: [{}], content: [{}]", new Object[]{operationName, serviceUrl, requestJson});
            logFullReqResp.info("{}: Sending JSON to: [{}], content: [{}]", new Object[]{operationName, serviceUrl, requestJson});
            responseWrapper = null;
            faultWrapper = null;
            try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)httpPost);){
                String stringResponse;
                logProtocol.info("{}: Received HTTP status code: {}", (Object)operationName, (Object)response.getCode());
                try {
                    stringResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (ParseException e) {
                    throw new MIDFlowException("Failed to interpret the HTTP response content as a string, for operation " + operationName, (Throwable)e, faultProcessor.processException((Exception)((Object)e), FailureReason.HTTP_DATA_TRANSFER_FAILURE));
                }
                this.notifyTrafficObserverForResponse(trafficObserver, (HttpResponse)response, stringResponse);
                if (response.getCode() == 200) {
                    if (logReqResp.isInfoEnabled()) {
                        String strippedResponse = Utils.stripInnerLargeBase64Content((String)stringResponse, (char)'\"', (char)'\"');
                        logReqResp.info("{}: Received JSON content: {}", (Object)operationName, (Object)strippedResponse);
                    }
                    if (logFullReqResp.isInfoEnabled()) {
                        logFullReqResp.info("{}: Received JSON content: {}", (Object)operationName, (Object)stringResponse);
                    }
                    logProtocol.debug("{}: Deserializing JSON to object of type {}", (Object)operationName, (Object)responseClass.getSimpleName());
                    try {
                        responseWrapper = this.jacksonMapper.readValue(stringResponse, responseClass);
                        break block21;
                    }
                    catch (JsonProcessingException e) {
                        throw new MIDFlowException("Failed to deserialize JSON content to object of type " + responseClass.getSimpleName() + " for operation " + operationName, (Throwable)e, faultProcessor.processException((Exception)((Object)e), FailureReason.RESPONSE_PARSING_FAILURE));
                    }
                }
                logProtocol.debug("{}: Deserializing JSON to object of type {}", (Object)operationName, (Object)MSSFault.class.getSimpleName());
                try {
                    faultWrapper = (MSSFault)this.jacksonMapper.readValue(stringResponse, MSSFault.class);
                }
                catch (JsonProcessingException e) {
                    throw new MIDFlowException("Failed to deserialize JSON content to object of type " + MSSFault.class.getSimpleName() + " for operation " + operationName, (Throwable)e, faultProcessor.processException((Exception)((Object)e), FailureReason.RESPONSE_PARSING_FAILURE));
                }
            }
            catch (SSLException e) {
                throw new MIDFlowException("TLS/SSL connection failure for " + operationName, (Throwable)e, faultProcessor.processException(e, null));
            }
            catch (Exception e) {
                throw new MIDFlowException("Communication failure for " + operationName, (Throwable)e, faultProcessor.processException(e, null));
            }
        }
        if (responseWrapper != null) {
            return (TResp)responseWrapper;
        }
        throw new MIDFlowException("Fault response received from Mobile ID server. See embedded MIDFault", new FaultProcessor().processFaultResponse(faultWrapper));
    }

    private void notifyTrafficObserverForRequest(TrafficObserver trafficObserver, String body) {
        if (trafficObserver == null) {
            return;
        }
        RequestTrace trace = new RequestTrace(body);
        trafficObserver.notifyOfOutgoingRequest(trace, ComProtocol.REST);
    }

    private void notifyTrafficObserverForResponse(TrafficObserver trafficObserver, HttpResponse response, String body) {
        if (trafficObserver == null) {
            return;
        }
        ResponseTrace trace = new ResponseTrace(response.getCode(), response.getReasonPhrase(), body);
        trafficObserver.notifyOfIncomingResponse(trace, ComProtocol.REST);
    }

    private void notifyTrafficObserverForApTransId(TrafficObserver trafficObserver, String apTransId) {
        if (trafficObserver == null) {
            return;
        }
        trafficObserver.notifyOfGeneratedApTransId(apTransId, ComProtocol.REST);
    }
}

