/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.rest;

import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.model.MessageToBeDisplayed;
import ch.swisscom.mid.client.model.ReceiptMessagingMode;
import ch.swisscom.mid.client.model.ReceiptRequest;
import ch.swisscom.mid.client.model.ReceiptResponse;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.rest.model.receiptreq.APInfo;
import ch.swisscom.mid.client.rest.model.receiptreq.MSSPInfo;
import ch.swisscom.mid.client.rest.model.receiptreq.MSSReceiptReq;
import ch.swisscom.mid.client.rest.model.receiptreq.MSSReceiptRequest;
import ch.swisscom.mid.client.rest.model.receiptreq.Message;
import ch.swisscom.mid.client.rest.model.receiptreq.MobileUser;
import ch.swisscom.mid.client.rest.model.receiptreq.MsspId;
import ch.swisscom.mid.client.rest.model.receiptreq.ReceiptProfile;
import ch.swisscom.mid.client.rest.model.receiptreq.ReceiptRequestExtension;
import ch.swisscom.mid.client.rest.model.receiptreq.Status;
import ch.swisscom.mid.client.rest.model.receiptreq.StatusDetail;
import ch.swisscom.mid.client.rest.model.receiptresp.MSSReceiptResp;
import ch.swisscom.mid.client.rest.model.receiptresp.MSSReceiptResponse;
import ch.swisscom.mid.client.rest.model.receiptresp.ReceiptResponseExtension;
import ch.swisscom.mid.client.rest.model.receiptresp.StatusCode;
import ch.swisscom.mid.client.utils.Utils;

public class ReceiptRequestModelUtils {
    public static MSSReceiptRequest createReceiptRequest(ClientConfiguration config, SignatureTracking signatureTracking, ReceiptRequest clientRequest) {
        ch.swisscom.mid.client.rest.model.receiptreq.StatusCode mssStatusCode = new ch.swisscom.mid.client.rest.model.receiptreq.StatusCode();
        mssStatusCode.setValue(String.valueOf(clientRequest.getStatusCode().getCode()));
        Status mssStatus = new Status();
        mssStatus.setStatusCode(mssStatusCode);
        if (clientRequest.getRequestExtension() != null) {
            mssStatus.setStatusDetail(ReceiptRequestModelUtils.createStatusDetail(clientRequest.getRequestExtension()));
        }
        MSSReceiptReq mssRequest = new MSSReceiptReq();
        mssRequest.setMajorVersion(clientRequest.getMajorVersion());
        mssRequest.setMinorVersion(clientRequest.getMinorVersion());
        mssRequest.setAPInfo(ReceiptRequestModelUtils.createApInfo(config, signatureTracking.getOverrideApId(), signatureTracking.getOverrideApPassword()));
        mssRequest.setMSSPInfo(ReceiptRequestModelUtils.createMsspInfo(config));
        mssRequest.setMobileUser(ReceiptRequestModelUtils.createMobileUser(signatureTracking));
        mssRequest.setMSSPTransID(signatureTracking.getTransactionId());
        mssRequest.setMessage(ReceiptRequestModelUtils.createMessage(clientRequest.getMessageToBeDisplayed()));
        mssRequest.setStatus(mssStatus);
        MSSReceiptRequest requestWrapper = new MSSReceiptRequest();
        requestWrapper.setMSSReceiptReq(mssRequest);
        return requestWrapper;
    }

    public static ReceiptResponse processReceiptResponse(MSSReceiptResponse responseWrapper) {
        MSSReceiptResp mssResponse = responseWrapper.getMSSReceiptResp();
        ch.swisscom.mid.client.rest.model.receiptresp.Status mssStatus = mssResponse.getStatus();
        ReceiptResponse response = new ReceiptResponse();
        response.setStatus(ReceiptRequestModelUtils.processReceiptRespStatus(mssStatus));
        if (mssStatus != null && mssStatus.getStatusDetail() != null) {
            response.setResponseExtension(ReceiptRequestModelUtils.processReceiptRespExtension(mssStatus.getStatusDetail().getReceiptResponseExtension()));
        }
        return response;
    }

    private static APInfo createApInfo(ClientConfiguration config, String overrideApId, String overrideApPassword) {
        APInfo apInfo = new APInfo();
        apInfo.setApId(overrideApId != null ? overrideApId : config.getApId());
        apInfo.setApPwd(overrideApPassword != null ? overrideApPassword : config.getApPassword());
        apInfo.setAPTransID(Utils.generateTransId());
        apInfo.setInstant(Utils.generateInstantAsString());
        return apInfo;
    }

    private static MSSPInfo createMsspInfo(ClientConfiguration config) {
        MsspId msspId = new MsspId();
        msspId.setUri(config.getMsspId());
        MSSPInfo msspInfo = new MSSPInfo();
        msspInfo.setMsspId(msspId);
        return msspInfo;
    }

    private static MobileUser createMobileUser(SignatureTracking signatureTracking) {
        MobileUser mobileUser = new MobileUser();
        mobileUser.setMsisdn(signatureTracking.getMobileUserMsisdn());
        return mobileUser;
    }

    private static Message createMessage(MessageToBeDisplayed messageToBeDisplayed) {
        Message message = new Message();
        message.setData(messageToBeDisplayed.getData());
        message.setEncoding(messageToBeDisplayed.getEncoding());
        message.setMimeType(messageToBeDisplayed.getMimeType());
        return message;
    }

    private static StatusDetail createStatusDetail(ch.swisscom.mid.client.model.ReceiptRequestExtension extension) {
        ReceiptProfile mssReceiptProfile = new ReceiptProfile();
        mssReceiptProfile.setLanguage(extension.getReceiptProfile().getLanguage());
        mssReceiptProfile.setReceiptProfileURI(extension.getReceiptProfile().getProfileUri());
        ReceiptRequestExtension mssExtension = new ReceiptRequestExtension();
        mssExtension.setReceiptMessagingMode(extension.getMessagingMode().getValue());
        mssExtension.setUserAck(Boolean.toString(extension.isRequestUserAck()));
        mssExtension.setReceiptProfile(mssReceiptProfile);
        StatusDetail statusDetail = new StatusDetail();
        statusDetail.setReceiptRequestExtension(mssExtension);
        return statusDetail;
    }

    private static ch.swisscom.mid.client.model.Status processReceiptRespStatus(ch.swisscom.mid.client.rest.model.receiptresp.Status mssStatus) {
        StatusCode mssStatusCode;
        ch.swisscom.mid.client.model.Status result = new ch.swisscom.mid.client.model.Status();
        if (mssStatus != null && (mssStatusCode = mssStatus.getStatusCode()) != null) {
            String statusCodeString = mssStatusCode.getValue();
            result.setStatusCodeString(statusCodeString);
            result.setStatusCode(ch.swisscom.mid.client.model.StatusCode.getByStatusCodeString((String)statusCodeString));
            result.setStatusMessage(result.getStatusCode().name());
        }
        return result;
    }

    private static ch.swisscom.mid.client.model.ReceiptResponseExtension processReceiptRespExtension(ReceiptResponseExtension mssExtension) {
        if (mssExtension == null) {
            return null;
        }
        ch.swisscom.mid.client.model.ReceiptResponseExtension extension = new ch.swisscom.mid.client.model.ReceiptResponseExtension();
        extension.setMessagingMode(ReceiptMessagingMode.getByValue((String)mssExtension.getReceiptMessagingMode()));
        extension.setClientAck(Boolean.valueOf(Boolean.parseBoolean(mssExtension.getClientAck())));
        extension.setNetworkAck(Boolean.valueOf(Boolean.parseBoolean(mssExtension.getNetworkAck())));
        extension.setUserAck(Boolean.valueOf(Boolean.parseBoolean(mssExtension.getUserAck())));
        extension.setUserResponse(mssExtension.getUserResponse());
        return extension;
    }
}

