/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.rest;

import ch.swisscom.mid.client.model.FailureReason;
import ch.swisscom.mid.client.model.StatusCode;
import ch.swisscom.mid.client.rest.model.fault.Code;
import ch.swisscom.mid.client.rest.model.fault.Fault;
import ch.swisscom.mid.client.rest.model.fault.MSSFault;
import ch.swisscom.mid.client.rest.model.fault.SubCode;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpHostConnectException;

public class FaultProcessor {
    public ch.swisscom.mid.client.model.Fault processFailure(FailureReason failureReason) {
        ch.swisscom.mid.client.model.Fault result = new ch.swisscom.mid.client.model.Fault();
        result.setFailureReason(failureReason);
        return result;
    }

    public ch.swisscom.mid.client.model.Fault processException(Exception e, FailureReason failureReason) {
        ch.swisscom.mid.client.model.Fault result = new ch.swisscom.mid.client.model.Fault();
        result.setStatusCode(StatusCode.INTERNAL_ERROR);
        result.setStatusCodeString(StatusCode.INTERNAL_ERROR.name());
        if (e != null) {
            result.setFailureDetail(e.getMessage());
            if (HttpHostConnectException.class.isAssignableFrom(e.getClass())) {
                result.setFailureReason(FailureReason.HOST_CONNECTION_FAILURE);
            } else if (ConnectException.class.isAssignableFrom(e.getClass())) {
                result.setFailureReason(FailureReason.HOST_CONNECTION_FAILURE);
            } else if (SSLException.class.isAssignableFrom(e.getClass())) {
                SSLException sslException = (SSLException)e;
                if (sslException.getCause() != null && SocketTimeoutException.class.isAssignableFrom(sslException.getCause().getClass())) {
                    result.setFailureReason(FailureReason.HOST_CONNECT_TIMEOUT_FAILURE);
                } else {
                    result.setFailureReason(FailureReason.TLS_CONNECTION_FAILURE);
                }
            } else if (SocketTimeoutException.class.isAssignableFrom(e.getClass())) {
                result.setFailureReason(FailureReason.RESPONSE_TIMEOUT_FAILURE);
            } else if (IOException.class.isAssignableFrom(e.getClass())) {
                result.setFailureReason(FailureReason.HTTP_COMMUNICATION_FAILURE);
            } else {
                result.setFailureReason(FailureReason.UNKNOWN_FAILURE);
            }
        }
        if (failureReason != null) {
            result.setFailureReason(failureReason);
        }
        return result;
    }

    public ch.swisscom.mid.client.model.Fault processFaultResponse(MSSFault faultWrapper) {
        SubCode faultSubCode;
        ch.swisscom.mid.client.model.Fault result = new ch.swisscom.mid.client.model.Fault();
        result.setFailureReason(FailureReason.MID_SERVICE_FAILURE);
        if (faultWrapper == null || faultWrapper.getFault() == null) {
            return result;
        }
        Fault fault = faultWrapper.getFault();
        result.setStatusDetail(fault.getDetail());
        result.setStatusFaultReason(fault.getReason());
        Code faultCode = fault.getCode();
        if (faultCode != null && (faultSubCode = faultCode.getSubCode()) != null) {
            String statusCodeString = faultSubCode.getValue();
            result.setStatusCodeString(statusCodeString);
            result.setStatusCode(StatusCode.getByStatusCodeString((String)statusCodeString));
        }
        return result;
    }
}

