/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.rest;

import ch.swisscom.mid.client.MIDFlowException;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.TrafficObserver;
import ch.swisscom.mid.client.model.AdditionalServiceResponse;
import ch.swisscom.mid.client.model.FailureReason;
import ch.swisscom.mid.client.model.GeofencingAdditionalServiceResponse;
import ch.swisscom.mid.client.model.GeofencingErrorCode;
import ch.swisscom.mid.client.model.SignatureRequest;
import ch.swisscom.mid.client.model.SignatureResponse;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.model.UserLangAdditionalService;
import ch.swisscom.mid.client.rest.FaultProcessor;
import ch.swisscom.mid.client.rest.model.signreq.APInfo;
import ch.swisscom.mid.client.rest.model.signreq.AdditionalService;
import ch.swisscom.mid.client.rest.model.signreq.DataToBeSigned;
import ch.swisscom.mid.client.rest.model.signreq.MSSPInfo;
import ch.swisscom.mid.client.rest.model.signreq.MSSSignatureReq;
import ch.swisscom.mid.client.rest.model.signreq.MSSSignatureRequest;
import ch.swisscom.mid.client.rest.model.signreq.MobileUser;
import ch.swisscom.mid.client.rest.model.signreq.MsspId;
import ch.swisscom.mid.client.rest.model.signreq.UserLang;
import ch.swisscom.mid.client.rest.model.signresp.Geofencing;
import ch.swisscom.mid.client.rest.model.signresp.MSSSignature;
import ch.swisscom.mid.client.rest.model.signresp.MSSSignatureResp;
import ch.swisscom.mid.client.rest.model.signresp.MSSSignatureResponse;
import ch.swisscom.mid.client.rest.model.signresp.ServiceResponse;
import ch.swisscom.mid.client.rest.model.signresp.Status;
import ch.swisscom.mid.client.rest.model.signresp.StatusCode;
import ch.swisscom.mid.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class SignatureRequestModelUtils {
    public static MSSSignatureRequest createSignatureRequest(ClientConfiguration config, SignatureRequest clientRequest, boolean sync) {
        MSSSignatureReq signatureReq = new MSSSignatureReq();
        signatureReq.setAPInfo(SignatureRequestModelUtils.createApInfo(config, clientRequest.getOverrideApId(), clientRequest.getOverrideApPassword()));
        signatureReq.setAdditionalServices(SignatureRequestModelUtils.createAdditionalServices(clientRequest));
        signatureReq.setDataToBeSigned(SignatureRequestModelUtils.createDataToBeSigned(clientRequest));
        signatureReq.setMSSPInfo(SignatureRequestModelUtils.createMsspInfo(config));
        signatureReq.setMajorVersion(clientRequest.getMajorVersion());
        signatureReq.setMinorVersion(clientRequest.getMinorVersion());
        signatureReq.setMessagingMode(sync ? "synch" : "asynch");
        signatureReq.setMobileUser(SignatureRequestModelUtils.createMobileUser(clientRequest));
        signatureReq.setSignatureProfile(clientRequest.getSignatureProfile());
        signatureReq.setTimeOut(String.valueOf(clientRequest.getUserResponseTimeOutInSeconds()));
        MSSSignatureRequest requestWrapper = new MSSSignatureRequest();
        requestWrapper.setMSSSignatureReq(signatureReq);
        return requestWrapper;
    }

    public static SignatureResponse processSignatureResponse(MSSSignatureResponse responseWrapper) {
        MSSSignatureResp response = responseWrapper.getMSSSignatureResp();
        SignatureResponse result = new SignatureResponse();
        if (response != null) {
            result.setMajorVersion(response.getMajorVersion());
            result.setMinorVersion(response.getMinorVersion());
            result.setSignatureProfile(response.getSignatureProfile());
            MSSSignature signature = response.getMSSSignature();
            if (signature != null) {
                result.setBase64Signature(signature.getBase64Signature());
            }
        } else {
            throw new MIDFlowException("Invalid MSS response received. Cannot parse it and convert it to a valid " + SignatureResponse.class.getSimpleName(), new FaultProcessor().processFailure(FailureReason.MID_INVALID_RESPONSE_FAILURE));
        }
        result.setStatus(SignatureRequestModelUtils.processSignatureRespStatus(response));
        result.setAdditionalServiceResponses(SignatureRequestModelUtils.processAdditionalServiceResponses(response));
        return result;
    }

    public static SignatureTracking createSignatureTracking(MSSSignatureResponse responseWrapper, TrafficObserver trafficObserver, String overrideApId, String overrideApPassword) {
        MSSSignatureResp response = responseWrapper.getMSSSignatureResp();
        if (response != null) {
            SignatureTracking result = new SignatureTracking();
            result.setMajorVersion(response.getMajorVersion());
            result.setMinorVersion(response.getMinorVersion());
            result.setOverrideApId(overrideApId);
            result.setOverrideApPassword(overrideApPassword);
            result.setTrafficObserver(trafficObserver);
            result.setTransactionId(response.getMSSPTransID());
            result.setMobileUserMsisdn(response.getMobileUser().getMsisdn());
            return result;
        }
        throw new MIDFlowException("Invalid MSS response received. Cannot parse it and convert it to a valid " + SignatureTracking.class.getSimpleName(), new FaultProcessor().processFailure(FailureReason.MID_INVALID_RESPONSE_FAILURE));
    }

    private static ch.swisscom.mid.client.model.Status processSignatureRespStatus(MSSSignatureResp response) {
        ch.swisscom.mid.client.model.Status result = new ch.swisscom.mid.client.model.Status();
        Status status = response.getStatus();
        if (status != null) {
            result.setStatusMessage(status.getStatusMessage());
            StatusCode statusCode = status.getStatusCode();
            if (statusCode != null) {
                String statusCodeString = statusCode.getValue();
                result.setStatusCodeString(statusCodeString);
                result.setStatusCode(ch.swisscom.mid.client.model.StatusCode.getByStatusCodeString((String)statusCodeString));
            }
        }
        return result;
    }

    private static APInfo createApInfo(ClientConfiguration config, String overrideApId, String overrideApPassword) {
        APInfo apInfo = new APInfo();
        apInfo.setApId(overrideApId != null ? overrideApId : config.getApId());
        apInfo.setApPwd(overrideApPassword != null ? overrideApPassword : config.getApPassword());
        apInfo.setAPTransID(Utils.generateTransId());
        apInfo.setInstant(Utils.generateInstantAsString());
        return apInfo;
    }

    private static List<AdditionalService> createAdditionalServices(SignatureRequest clientRequest) {
        ArrayList<AdditionalService> processedAdditionalServices = new ArrayList<AdditionalService>();
        List requestedAdditionalService = clientRequest.getAdditionalServices();
        for (ch.swisscom.mid.client.model.AdditionalService currentAS : requestedAdditionalService) {
            AdditionalService additionalService = new AdditionalService();
            if (currentAS instanceof UserLangAdditionalService) {
                UserLang userLang = new UserLang();
                userLang.setValue(((UserLangAdditionalService)currentAS).getUserLanguage().getValue());
                additionalService.setDescription(currentAS.getUri());
                additionalService.setUserLang(userLang);
            } else {
                additionalService.setDescription(currentAS.getUri());
            }
            processedAdditionalServices.add(additionalService);
        }
        return processedAdditionalServices;
    }

    private static List<AdditionalServiceResponse> processAdditionalServiceResponses(MSSSignatureResp response) {
        ArrayList<AdditionalServiceResponse> resultList = new ArrayList<AdditionalServiceResponse>();
        List<ServiceResponse> serviceResponseList = response.getServiceResponses();
        if (serviceResponseList != null) {
            for (ServiceResponse serviceResponse : serviceResponseList) {
                if (!"http://mid.swisscom.ch/as#geofencing".equals(serviceResponse.getDescription()) || serviceResponse.getGeofencing() == null) continue;
                Geofencing geofencing = serviceResponse.getGeofencing();
                GeofencingAdditionalServiceResponse geoResponse = new GeofencingAdditionalServiceResponse();
                if (geofencing.getErrorCode() == null) {
                    geoResponse.setCountry(geofencing.getCountry());
                    geoResponse.setAccuracy(geofencing.getAccuracy() == null ? 0 : Integer.parseInt(geofencing.getAccuracy()));
                    geoResponse.setTimestamp(geofencing.getTimestamp());
                    geoResponse.setDeviceConfidence(geofencing.getDeviceConfidence());
                    geoResponse.setLocationConfidence(geofencing.getLocationConfidence());
                } else {
                    geoResponse.setErrorCode(GeofencingErrorCode.getByCodeAsString((String)geofencing.getErrorCode()));
                    geoResponse.setErrorMessage(geofencing.getErrorMessage());
                }
                resultList.add((AdditionalServiceResponse)geoResponse);
            }
        }
        return resultList;
    }

    private static MobileUser createMobileUser(SignatureRequest clientRequest) {
        MobileUser mobileUser = new MobileUser();
        mobileUser.setMsisdn(clientRequest.getMobileUser().getMsisdn());
        return mobileUser;
    }

    private static MSSPInfo createMsspInfo(ClientConfiguration config) {
        MsspId msspId = new MsspId();
        msspId.setUri(config.getMsspId());
        MSSPInfo msspInfo = new MSSPInfo();
        msspInfo.setMsspId(msspId);
        return msspInfo;
    }

    private static DataToBeSigned createDataToBeSigned(SignatureRequest clientRequest) {
        DataToBeSigned dtbs = new DataToBeSigned();
        dtbs.setData(clientRequest.getDataToBeSigned().getData());
        dtbs.setEncoding(clientRequest.getDataToBeSigned().getEncoding());
        dtbs.setMimeType(clientRequest.getDataToBeSigned().getMimeType());
        return dtbs;
    }
}

