/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.rest;

import ch.swisscom.mid.client.MIDFlowException;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.model.AdditionalServiceResponse;
import ch.swisscom.mid.client.model.FailureReason;
import ch.swisscom.mid.client.model.GeofencingAdditionalServiceResponse;
import ch.swisscom.mid.client.model.GeofencingErrorCode;
import ch.swisscom.mid.client.model.SignatureResponse;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.rest.FaultProcessor;
import ch.swisscom.mid.client.rest.model.statusreq.APInfo;
import ch.swisscom.mid.client.rest.model.statusreq.MSSPInfo;
import ch.swisscom.mid.client.rest.model.statusreq.MSSStatusReq;
import ch.swisscom.mid.client.rest.model.statusreq.MSSStatusRequest;
import ch.swisscom.mid.client.rest.model.statusreq.MsspId;
import ch.swisscom.mid.client.rest.model.statusresp.Geofencing;
import ch.swisscom.mid.client.rest.model.statusresp.MSSSignature;
import ch.swisscom.mid.client.rest.model.statusresp.MSSStatusResp;
import ch.swisscom.mid.client.rest.model.statusresp.MSSStatusResponse;
import ch.swisscom.mid.client.rest.model.statusresp.ServiceResponse;
import ch.swisscom.mid.client.rest.model.statusresp.Status;
import ch.swisscom.mid.client.rest.model.statusresp.StatusCode;
import ch.swisscom.mid.client.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class StatusQueryModelUtils {
    public static MSSStatusRequest createStatusQueryRequest(ClientConfiguration config, SignatureTracking signatureTracking) {
        String overrideApId = signatureTracking.getOverrideApId();
        String overrideApPassword = signatureTracking.getOverrideApPassword();
        APInfo apInfo = new APInfo();
        apInfo.setApId(overrideApId != null ? overrideApId : config.getApId());
        apInfo.setApPwd(overrideApPassword != null ? overrideApPassword : config.getApPassword());
        apInfo.setAPTransID(Utils.generateTransId());
        apInfo.setInstant(Utils.generateInstantAsString());
        MsspId msspId = new MsspId();
        msspId.setUri(config.getMsspId());
        MSSPInfo msspInfo = new MSSPInfo();
        msspInfo.setMsspId(msspId);
        MSSStatusReq statusReq = new MSSStatusReq();
        statusReq.setAPInfo(apInfo);
        statusReq.setMSSPInfo(msspInfo);
        statusReq.setMajorVersion(signatureTracking.getMajorVersion());
        statusReq.setMinorVersion(signatureTracking.getMinorVersion());
        statusReq.setMSSPTransID(signatureTracking.getTransactionId());
        MSSStatusRequest requestWrapper = new MSSStatusRequest();
        requestWrapper.setMSSStatusReq(statusReq);
        return requestWrapper;
    }

    public static SignatureResponse processStatusQueryResponse(MSSStatusResponse responseWrapper, SignatureTracking originalTracking) {
        MSSStatusResp response = responseWrapper.getMSSStatusResp();
        if (response != null) {
            SignatureResponse result = new SignatureResponse();
            result.setMajorVersion(response.getMajorVersion());
            result.setMinorVersion(response.getMinorVersion());
            result.setTracking(originalTracking);
            MSSSignature signature = response.getMSSSignature();
            if (signature != null) {
                result.setBase64Signature(signature.getBase64Signature());
            }
            result.setStatus(StatusQueryModelUtils.processStatusRespStatus(response));
            result.setAdditionalServiceResponses(StatusQueryModelUtils.processAdditionalServiceResponses(response));
            return result;
        }
        throw new MIDFlowException("Invalid MSS status response received. Cannot parse it and convert it to a valid " + SignatureResponse.class.getSimpleName(), new FaultProcessor().processFailure(FailureReason.MID_INVALID_RESPONSE_FAILURE));
    }

    private static ch.swisscom.mid.client.model.Status processStatusRespStatus(MSSStatusResp response) {
        ch.swisscom.mid.client.model.Status result = new ch.swisscom.mid.client.model.Status();
        Status status = response.getStatus();
        if (status != null) {
            result.setStatusMessage(status.getStatusMessage());
            StatusCode statusCode = status.getStatusCode();
            if (statusCode != null) {
                String statusCodeString = statusCode.getValue();
                result.setStatusCodeString(statusCodeString);
                result.setStatusCode(ch.swisscom.mid.client.model.StatusCode.getByStatusCodeString((String)statusCodeString));
            }
        }
        return result;
    }

    private static List<AdditionalServiceResponse> processAdditionalServiceResponses(MSSStatusResp response) {
        ArrayList<AdditionalServiceResponse> resultList = new ArrayList<AdditionalServiceResponse>();
        List<ServiceResponse> serviceResponseList = response.getServiceResponses();
        if (serviceResponseList != null) {
            for (ServiceResponse serviceResponse : serviceResponseList) {
                if (!"http://mid.swisscom.ch/as#geofencing".equals(serviceResponse.getDescription()) || serviceResponse.getGeofencing() == null) continue;
                Geofencing geofencing = serviceResponse.getGeofencing();
                GeofencingAdditionalServiceResponse geoResponse = new GeofencingAdditionalServiceResponse();
                if (geofencing.getErrorCode() == null) {
                    geoResponse.setCountry(geofencing.getCountry());
                    geoResponse.setAccuracy(geofencing.getAccuracy() == null ? 0 : Integer.parseInt(geofencing.getAccuracy()));
                    geoResponse.setTimestamp(geofencing.getTimestamp());
                    geoResponse.setDeviceConfidence(geofencing.getDeviceConfidence());
                    geoResponse.setLocationConfidence(geofencing.getLocationConfidence());
                } else {
                    geoResponse.setErrorCode(GeofencingErrorCode.getByCodeAsString((String)geofencing.getErrorCode()));
                    geoResponse.setErrorMessage(geofencing.getErrorMessage());
                }
                resultList.add((AdditionalServiceResponse)geoResponse);
            }
        }
        return resultList;
    }
}

