/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.soap;

import ch.swisscom.mid.client.MIDFlowException;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.ComProtocol;
import ch.swisscom.mid.client.config.TrafficObserver;
import ch.swisscom.mid.client.config.UrlsConfiguration;
import ch.swisscom.mid.client.impl.ComProtocolHandler;
import ch.swisscom.mid.client.model.FailureReason;
import ch.swisscom.mid.client.model.ProfileRequest;
import ch.swisscom.mid.client.model.ProfileResponse;
import ch.swisscom.mid.client.model.ReceiptRequest;
import ch.swisscom.mid.client.model.ReceiptResponse;
import ch.swisscom.mid.client.model.SignatureRequest;
import ch.swisscom.mid.client.model.SignatureResponse;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.soap.MssService;
import ch.swisscom.mid.client.soap.MssServiceFactory;
import ch.swisscom.mid.client.soap.adapter.MssFaultProcessor;
import ch.swisscom.mid.client.soap.adapter.MssRequestBuilder;
import ch.swisscom.mid.client.soap.adapter.MssResponseProcessor;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.etsi.uri.ts102204.etsi204_kiuru.MSSProfileQueryType;
import org.etsi.uri.ts102204.etsi204_kiuru.MSSReceiptType;
import org.etsi.uri.ts102204.etsi204_kiuru.MSSSignaturePortType;
import org.etsi.uri.ts102204.etsi204_kiuru.MSSStatusQueryType;
import org.etsi.uri.ts102204.v1_1.MSSProfileReqType;
import org.etsi.uri.ts102204.v1_1.MSSProfileRespType;
import org.etsi.uri.ts102204.v1_1.MSSReceiptReqType;
import org.etsi.uri.ts102204.v1_1.MSSReceiptRespType;
import org.etsi.uri.ts102204.v1_1.MSSSignatureReqType;
import org.etsi.uri.ts102204.v1_1.MSSSignatureRespType;
import org.etsi.uri.ts102204.v1_1.MSSStatusReqType;
import org.etsi.uri.ts102204.v1_1.MSSStatusRespType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComProtocolHandlerSoapImpl
implements ComProtocolHandler {
    private static final Logger logClient = LoggerFactory.getLogger((String)"ch.swisscom.mid.client");
    private static final Logger logConfig = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.config");
    private static final Logger logProtocol = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.protocol");
    private ClientConfiguration config;
    private ObjectPool<MssService<MSSSignaturePortType>> mssSignatureServicePool;
    private ObjectPool<MssService<MSSStatusQueryType>> mssStatusQueryServicePool;
    private ObjectPool<MssService<MSSReceiptType>> mssReceiptServicePool;
    private ObjectPool<MssService<MSSProfileQueryType>> mssProfileQueryServicePool;

    public ComProtocol getImplementedComProtocol() {
        return ComProtocol.SOAP;
    }

    public void initialize(ClientConfiguration config) {
        this.config = config;
        this.mssSignatureServicePool = new GenericObjectPool(new MssServiceFactory<MSSSignaturePortType>(config, MSSSignaturePortType.class, () -> ((UrlsConfiguration)config.getUrls()).getSignatureServiceUrl()));
        this.mssStatusQueryServicePool = new GenericObjectPool(new MssServiceFactory<MSSStatusQueryType>(config, MSSStatusQueryType.class, () -> ((UrlsConfiguration)config.getUrls()).getStatusQueryServiceUrl()));
        this.mssReceiptServicePool = new GenericObjectPool(new MssServiceFactory<MSSReceiptType>(config, MSSReceiptType.class, () -> ((UrlsConfiguration)config.getUrls()).getReceiptServiceUrl()));
        this.mssProfileQueryServicePool = new GenericObjectPool(new MssServiceFactory<MSSProfileQueryType>(config, MSSProfileQueryType.class, () -> ((UrlsConfiguration)config.getUrls()).getProfileQueryServiceUrl()));
        logConfig.info("Initializing MID SOAP client with config: [{}]", (Object)config);
    }

    public void close() {
    }

    public SignatureResponse requestSyncSignature(SignatureRequest request) {
        MSSSignatureRespType mssSignatureResp;
        logProtocol.info("MSS Signature (sync): Sending request: [{}]", (Object)request);
        MSSSignatureReqType mssSignatureReq = MssRequestBuilder.createSignatureReq(this.config, request, true);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), mssSignatureReq.getAPInfo().getAPTransID());
        MssService mssSignatureService = null;
        try {
            mssSignatureService = (MssService)this.mssSignatureServicePool.borrowObject();
            mssSignatureService.registerTrafficObserverForThisRequest(request.getTrafficObserver());
            mssSignatureResp = ((MSSSignaturePortType)mssSignatureService.getPort()).mssSignature(mssSignatureReq);
            logClient.info("Received MSS (sync) signature response: [{}]", (Object)(mssSignatureResp == null ? "null" : "not-null, looks OK"));
        }
        catch (SOAPFaultException e) {
            throw new MIDFlowException("SOAP Fault received", (Throwable)e, MssFaultProcessor.processSoapFaultException(e));
        }
        catch (Exception e) {
            throw new MIDFlowException("Error in (sync) Signature operation.", (Throwable)e, MssFaultProcessor.processException(e, FailureReason.MID_SERVICE_FAILURE));
        }
        finally {
            if (mssSignatureService != null) {
                try {
                    mssSignatureService.clearTrafficObserver();
                    this.mssSignatureServicePool.returnObject((Object)mssSignatureService);
                }
                catch (Exception e) {
                    logClient.error("Failed to return MSS Signature Port object back to the pool", (Throwable)e);
                }
            }
        }
        SignatureResponse signatureResponse = MssResponseProcessor.processMssSignatureResponse(mssSignatureResp);
        signatureResponse.setTracking(MssResponseProcessor.createSignatureTracking(mssSignatureResp, request.getTrafficObserver()));
        return signatureResponse;
    }

    public SignatureResponse requestAsyncSignature(SignatureRequest request) {
        MSSSignatureRespType mssSignatureResp;
        logProtocol.info("MSS Signature (async): Sending request: [{}]", (Object)request);
        MSSSignatureReqType mssSignatureReq = MssRequestBuilder.createSignatureReq(this.config, request, false);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), mssSignatureReq.getAPInfo().getAPTransID());
        MssService mssSignatureService = null;
        try {
            mssSignatureService = (MssService)this.mssSignatureServicePool.borrowObject();
            mssSignatureService.registerTrafficObserverForThisRequest(request.getTrafficObserver());
            mssSignatureResp = ((MSSSignaturePortType)mssSignatureService.getPort()).mssSignature(mssSignatureReq);
            logClient.info("Received MSS (async) signature response: [{}]", (Object)(mssSignatureResp == null ? "null" : "not-null, looks OK"));
        }
        catch (SOAPFaultException e) {
            throw new MIDFlowException("SOAP Fault received", (Throwable)e, MssFaultProcessor.processSoapFaultException(e));
        }
        catch (Exception e) {
            throw new MIDFlowException("Error in (async) Signature operation.", (Throwable)e, MssFaultProcessor.processException(e, FailureReason.MID_SERVICE_FAILURE));
        }
        finally {
            if (mssSignatureService != null) {
                try {
                    mssSignatureService.clearTrafficObserver();
                    this.mssSignatureServicePool.returnObject((Object)mssSignatureService);
                }
                catch (Exception e) {
                    logClient.error("Failed to return MSS Signature Port object back to the pool", (Throwable)e);
                }
            }
        }
        SignatureResponse signatureResponse = MssResponseProcessor.processMssSignatureResponse(mssSignatureResp);
        signatureResponse.setTracking(MssResponseProcessor.createSignatureTracking(mssSignatureResp, request.getTrafficObserver()));
        return signatureResponse;
    }

    public SignatureResponse pollForSignatureStatus(SignatureTracking signatureTracking) {
        MSSStatusRespType mssStatusRespType;
        logProtocol.info("MSS Status Query: Sending request for signature tracking object: [{}]", (Object)signatureTracking);
        MSSStatusReqType mssStatusReqType = MssRequestBuilder.createStatusQueryReq(this.config, signatureTracking);
        this.notifyTrafficObserverForApTransId(signatureTracking.getTrafficObserver(), mssStatusReqType.getAPInfo().getAPTransID());
        MssService mssStatusQueryService = null;
        try {
            mssStatusQueryService = (MssService)this.mssStatusQueryServicePool.borrowObject();
            mssStatusQueryService.registerTrafficObserverForThisRequest(signatureTracking.getTrafficObserver());
            mssStatusRespType = ((MSSStatusQueryType)mssStatusQueryService.getPort()).mssStatusQuery(mssStatusReqType);
            logClient.info("Received MSS Status Query response: [{}]", (Object)(mssStatusRespType == null ? "null" : "not-null, looks OK"));
        }
        catch (SOAPFaultException e) {
            throw new MIDFlowException("SOAP Fault received", (Throwable)e, MssFaultProcessor.processSoapFaultException(e));
        }
        catch (Exception e) {
            throw new MIDFlowException("Error in Status Query operation.", (Throwable)e, MssFaultProcessor.processException(e, FailureReason.MID_SERVICE_FAILURE));
        }
        finally {
            if (mssStatusQueryService != null) {
                try {
                    mssStatusQueryService.clearTrafficObserver();
                    this.mssStatusQueryServicePool.returnObject((Object)mssStatusQueryService);
                }
                catch (Exception e) {
                    logClient.error("Failed to return MSS Status Query object back to the pool", (Throwable)e);
                }
            }
        }
        return MssResponseProcessor.processStatusQueryResponse(mssStatusRespType, signatureTracking);
    }

    public ReceiptResponse requestSyncReceipt(SignatureTracking signatureTracking, ReceiptRequest request) {
        MSSReceiptRespType mssReceiptResp;
        logProtocol.info("MSS Receipt (sync): Sending request: [{}]", (Object)request);
        MSSReceiptReqType mssReceiptReq = MssRequestBuilder.createReceiptReq(this.config, signatureTracking, request);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), mssReceiptReq.getAPInfo().getAPTransID());
        MssService mssReceiptService = null;
        try {
            mssReceiptService = (MssService)this.mssReceiptServicePool.borrowObject();
            mssReceiptService.registerTrafficObserverForThisRequest(request.getTrafficObserver());
            mssReceiptResp = ((MSSReceiptType)mssReceiptService.getPort()).mssReceipt(mssReceiptReq);
            logClient.info("Received MSS Receipt response: [{}]", (Object)(mssReceiptResp == null ? "null" : "not-null, looks OK"));
        }
        catch (SOAPFaultException e) {
            throw new MIDFlowException("SOAP Fault received", (Throwable)e, MssFaultProcessor.processSoapFaultException(e));
        }
        catch (Exception e) {
            throw new MIDFlowException("Error in MSS Receipt operation.", (Throwable)e, MssFaultProcessor.processException(e, FailureReason.MID_SERVICE_FAILURE));
        }
        finally {
            if (mssReceiptService != null) {
                try {
                    mssReceiptService.clearTrafficObserver();
                    this.mssReceiptServicePool.returnObject((Object)mssReceiptService);
                }
                catch (Exception e) {
                    logClient.error("Failed to return MSS Receipt Port object back to the pool", (Throwable)e);
                }
            }
        }
        return MssResponseProcessor.processReceiptResponse(mssReceiptResp);
    }

    public ProfileResponse requestProfile(ProfileRequest request) {
        MSSProfileRespType mssProfileResp;
        logProtocol.info("MSS Profile Query: Sending request: [{}]", (Object)request);
        MSSProfileReqType mssProfileReq = MssRequestBuilder.createProfileReq(this.config, request);
        this.notifyTrafficObserverForApTransId(request.getTrafficObserver(), mssProfileReq.getAPInfo().getAPTransID());
        MssService mssProfileQueryService = null;
        try {
            mssProfileQueryService = (MssService)this.mssProfileQueryServicePool.borrowObject();
            mssProfileQueryService.registerTrafficObserverForThisRequest(request.getTrafficObserver());
            mssProfileResp = ((MSSProfileQueryType)mssProfileQueryService.getPort()).mssProfileQuery(mssProfileReq);
            logClient.info("Received MSS Profile Query response: [{}]", (Object)(mssProfileResp == null ? "null" : "not-null, looks OK"));
        }
        catch (SOAPFaultException e) {
            throw new MIDFlowException("SOAP Fault received", (Throwable)e, MssFaultProcessor.processSoapFaultException(e));
        }
        catch (Exception e) {
            throw new MIDFlowException("Error in Profile Query operation.", (Throwable)e, MssFaultProcessor.processException(e, FailureReason.MID_SERVICE_FAILURE));
        }
        finally {
            if (mssProfileQueryService != null) {
                try {
                    mssProfileQueryService.clearTrafficObserver();
                    this.mssProfileQueryServicePool.returnObject((Object)mssProfileQueryService);
                }
                catch (Exception e) {
                    logClient.error("Failed to return MSS Profile Query Port object back to the pool", (Throwable)e);
                }
            }
        }
        return MssResponseProcessor.processMssProfileQueryResponse(mssProfileResp);
    }

    private void notifyTrafficObserverForApTransId(TrafficObserver trafficObserver, String apTransId) {
        if (trafficObserver == null) {
            return;
        }
        trafficObserver.notifyOfGeneratedApTransId(apTransId, ComProtocol.REST);
    }
}

