/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.soap.adapter;

import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.model.AdditionalService;
import ch.swisscom.mid.client.model.DataToBeSigned;
import ch.swisscom.mid.client.model.MessageToBeDisplayed;
import ch.swisscom.mid.client.model.ProfileRequest;
import ch.swisscom.mid.client.model.ReceiptMessagingMode;
import ch.swisscom.mid.client.model.ReceiptRequest;
import ch.swisscom.mid.client.model.ReceiptRequestExtension;
import ch.swisscom.mid.client.model.SignatureRequest;
import ch.swisscom.mid.client.model.SignatureTracking;
import ch.swisscom.mid.client.model.UserLangAdditionalService;
import ch.swisscom.mid.client.utils.Utils;
import ch.swisscom.ts102204.ext.v1_0.ReceiptExtensionType;
import ch.swisscom.ts102204.ext.v1_0.ReceiptMessagingModeType;
import ch.swisscom.ts102204.ext.v1_0.ReceiptProfileType;
import fi.ficom.mss.ts102204.v1_0.ObjectFactory;
import java.math.BigInteger;
import java.util.List;
import org.etsi.uri.ts102204.v1_1.AdditionalServiceType;
import org.etsi.uri.ts102204.v1_1.DataType;
import org.etsi.uri.ts102204.v1_1.MSSProfileReqType;
import org.etsi.uri.ts102204.v1_1.MSSReceiptReqType;
import org.etsi.uri.ts102204.v1_1.MSSSignatureReqType;
import org.etsi.uri.ts102204.v1_1.MSSStatusReqType;
import org.etsi.uri.ts102204.v1_1.MeshMemberType;
import org.etsi.uri.ts102204.v1_1.MessageAbstractType;
import org.etsi.uri.ts102204.v1_1.MessagingModeType;
import org.etsi.uri.ts102204.v1_1.MobileUserType;
import org.etsi.uri.ts102204.v1_1.MssURIType;
import org.etsi.uri.ts102204.v1_1.StatusCodeType;
import org.etsi.uri.ts102204.v1_1.StatusDetailType;
import org.etsi.uri.ts102204.v1_1.StatusType;

public class MssRequestBuilder {
    public static MSSSignatureReqType createSignatureReq(ClientConfiguration config, SignatureRequest signatureRequest, boolean sync) {
        MSSSignatureReqType request = new MSSSignatureReqType();
        request.setMajorVersion(MssRequestBuilder.longToBigInteger(signatureRequest.getMajorVersion()));
        request.setMinorVersion(MssRequestBuilder.longToBigInteger(signatureRequest.getMinorVersion()));
        request.setTimeOut(BigInteger.valueOf(signatureRequest.getUserResponseTimeOutInSeconds()));
        request.setMessagingMode(sync ? MessagingModeType.SYNCH : MessagingModeType.ASYNCH_CLIENT_SERVER);
        request.setAPInfo(MssRequestBuilder.createApInfo(config));
        request.setMSSPInfo(MssRequestBuilder.createMsspInfo(config));
        request.setMobileUser(MssRequestBuilder.createMobileUser(signatureRequest.getMobileUser().getMsisdn()));
        request.setDataToBeSigned(MssRequestBuilder.createDtbs(signatureRequest.getDataToBeSigned()));
        request.setMSSFormat(null);
        request.setSignatureProfile(MssRequestBuilder.createSignatureProfile(signatureRequest.getSignatureProfile()));
        request.setAdditionalServices(MssRequestBuilder.createAdditionalServiceList(signatureRequest));
        return request;
    }

    public static MSSStatusReqType createStatusQueryReq(ClientConfiguration config, SignatureTracking signatureTracking) {
        MSSStatusReqType mssReq = new MSSStatusReqType();
        mssReq.setAPInfo(MssRequestBuilder.createApInfo(config));
        mssReq.setMSSPInfo(MssRequestBuilder.createMsspInfo(config));
        mssReq.setMajorVersion(MssRequestBuilder.longToBigInteger(signatureTracking.getMajorVersion()));
        mssReq.setMinorVersion(MssRequestBuilder.longToBigInteger(signatureTracking.getMinorVersion()));
        mssReq.setMSSPTransID(signatureTracking.getTransactionId());
        mssReq.setMobileUser(MssRequestBuilder.createMobileUser(signatureTracking.getMobileUserMsisdn()));
        return mssReq;
    }

    public static MSSReceiptReqType createReceiptReq(ClientConfiguration config, SignatureTracking signatureTracking, ReceiptRequest clientRequest) {
        StatusCodeType mssStatusCode = new StatusCodeType();
        mssStatusCode.setValue(BigInteger.valueOf(clientRequest.getStatusCode().getCode()));
        StatusType mssStatus = new StatusType();
        mssStatus.setStatusCode(mssStatusCode);
        if (clientRequest.getRequestExtension() != null) {
            mssStatus.setStatusDetail(MssRequestBuilder.createStatusDetail(clientRequest.getRequestExtension()));
        }
        MSSReceiptReqType mssReq = new MSSReceiptReqType();
        mssReq.setMajorVersion(MssRequestBuilder.longToBigInteger(clientRequest.getMajorVersion()));
        mssReq.setMinorVersion(MssRequestBuilder.longToBigInteger(clientRequest.getMinorVersion()));
        mssReq.setAPInfo(MssRequestBuilder.createApInfo(config));
        mssReq.setMSSPInfo(MssRequestBuilder.createMsspInfo(config));
        mssReq.setMobileUser(MssRequestBuilder.createMobileUser(signatureTracking.getMobileUserMsisdn()));
        mssReq.setMSSPTransID(signatureTracking.getTransactionId());
        mssReq.setMessage(MssRequestBuilder.createMessage(clientRequest.getMessageToBeDisplayed()));
        mssReq.setStatus(mssStatus);
        return mssReq;
    }

    public static MSSProfileReqType createProfileReq(ClientConfiguration config, ProfileRequest profileRequest) {
        MSSProfileReqType mssProfileReq = new MSSProfileReqType();
        mssProfileReq.setAPInfo(MssRequestBuilder.createApInfo(config));
        mssProfileReq.setMajorVersion(MssRequestBuilder.longToBigInteger(profileRequest.getMajorVersion()));
        mssProfileReq.setMinorVersion(MssRequestBuilder.longToBigInteger(profileRequest.getMinorVersion()));
        mssProfileReq.setMSSPInfo(MssRequestBuilder.createMsspInfo(config));
        mssProfileReq.setMobileUser(MssRequestBuilder.createMobileUser(profileRequest.getMobileUser().getMsisdn()));
        mssProfileReq.setParams(Utils.joinListOfStrings((List)profileRequest.getExtensionParams(), (String)" "));
        return mssProfileReq;
    }

    private static MessageAbstractType.APInfo createApInfo(ClientConfiguration config) {
        MessageAbstractType.APInfo apInfoType = new MessageAbstractType.APInfo();
        apInfoType.setAPID(config.getApId());
        apInfoType.setAPPWD(config.getApPassword());
        apInfoType.setAPTransID(Utils.generateTransId());
        apInfoType.setInstant(Utils.generateInstantAsXmlGregorianCalendar());
        return apInfoType;
    }

    private static MessageAbstractType.MSSPInfo createMsspInfo(ClientConfiguration config) {
        MessageAbstractType.MSSPInfo msspInfo = new MessageAbstractType.MSSPInfo();
        MeshMemberType meshMemberType = new MeshMemberType();
        meshMemberType.setURI(config.getMsspId());
        msspInfo.setMSSPID(meshMemberType);
        return msspInfo;
    }

    private static MobileUserType createMobileUser(String msisdn) {
        MobileUserType mobileUserType = new MobileUserType();
        mobileUserType.setMSISDN(msisdn);
        return mobileUserType;
    }

    private static DataType createDtbs(DataToBeSigned dataToBeSigned) {
        DataType dataType = new DataType();
        dataType.setMimeType(dataToBeSigned.getMimeType());
        dataType.setEncoding(dataToBeSigned.getEncoding());
        dataType.setValue(dataToBeSigned.getData());
        return dataType;
    }

    private static MssURIType createSignatureProfile(String signatureProfile) {
        MssURIType uriType = new MssURIType();
        uriType.setMssURI(signatureProfile);
        return uriType;
    }

    private static MSSSignatureReqType.AdditionalServices createAdditionalServiceList(SignatureRequest signatureRequest) {
        if (signatureRequest.getAdditionalServices().size() <= 0) {
            return null;
        }
        MSSSignatureReqType.AdditionalServices serviceList = new MSSSignatureReqType.AdditionalServices();
        List requestedAdditionalService = signatureRequest.getAdditionalServices();
        for (AdditionalService currentAS : requestedAdditionalService) {
            MssURIType serviceDescription;
            AdditionalServiceType additionalService = new AdditionalServiceType();
            if (currentAS instanceof UserLangAdditionalService) {
                serviceDescription = new MssURIType();
                serviceDescription.setMssURI(currentAS.getUri());
                additionalService.setDescription(serviceDescription);
                ObjectFactory factory = new ObjectFactory();
                additionalService.getSessionIDOrEventIDOrNoSpamCode().add(factory.createUserLang(((UserLangAdditionalService)currentAS).getUserLanguage().getValue()));
            } else {
                serviceDescription = new MssURIType();
                serviceDescription.setMssURI(currentAS.getUri());
                additionalService.setDescription(serviceDescription);
            }
            serviceList.getService().add(additionalService);
        }
        return serviceList;
    }

    private static BigInteger longToBigInteger(String valueAsString) {
        return BigInteger.valueOf(Long.parseLong(valueAsString));
    }

    private static DataType createMessage(MessageToBeDisplayed messageToBeDisplayed) {
        DataType message = new DataType();
        message.setValue(messageToBeDisplayed.getData());
        message.setEncoding(messageToBeDisplayed.getEncoding());
        message.setMimeType(messageToBeDisplayed.getMimeType());
        return message;
    }

    private static StatusDetailType createStatusDetail(ReceiptRequestExtension extension) {
        ReceiptProfileType mssReceiptProfile = new ReceiptProfileType();
        mssReceiptProfile.setLanguage(extension.getReceiptProfile().getLanguage());
        mssReceiptProfile.setReceiptProfileURI(extension.getReceiptProfile().getProfileUri());
        ReceiptExtensionType mssExtension = new ReceiptExtensionType();
        mssExtension.setReceiptMessagingMode(MssRequestBuilder.toMssModel(extension.getMessagingMode()));
        mssExtension.setUserAck(extension.isRequestUserAck());
        mssExtension.setReceiptProfile(mssReceiptProfile);
        ch.swisscom.ts102204.ext.v1_0.ObjectFactory objectFactory = new ch.swisscom.ts102204.ext.v1_0.ObjectFactory();
        StatusDetailType mssStatusDetail = new StatusDetailType();
        mssStatusDetail.getRegistrationOutputOrEncryptedRegistrationOutputOrEncryptionCertificates().add(objectFactory.createReceiptRequestExtension(mssExtension));
        return mssStatusDetail;
    }

    private static ReceiptMessagingModeType toMssModel(ReceiptMessagingMode mode) {
        if (mode == null) {
            return null;
        }
        if (mode == ReceiptMessagingMode.SYNC) {
            return ReceiptMessagingModeType.SYNCH;
        }
        throw new IllegalArgumentException("Unknown receipt message mode: " + mode);
    }
}

