/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.soap;

import ch.swisscom.mid.client.MIDClientException;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.ConfigurationException;
import ch.swisscom.mid.client.config.ProxyConfiguration;
import ch.swisscom.mid.client.config.TlsConfiguration;
import ch.swisscom.mid.client.soap.MssService;
import ch.swisscom.mid.client.soap.ProxyAwareSSLSocketFactory;
import ch.swisscom.mid.client.soap.SoapTrafficHandler;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.etsi.uri.ts102204.etsi204_kiuru.MSSSignatureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MssServiceFactory<PortType>
extends BasePooledObjectFactory<MssService<PortType>> {
    private static final Logger log = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.protocol");
    private static final Logger logConfig = LoggerFactory.getLogger((String)"ch.swisscom.mid.client.config");
    private static final String JDK_JAXWS_CONNECT_TIMEOUT = "com.sun.xml.internal.ws.connect.timeout";
    private static final String JBOSS_CXF_CONNECT_TIMEOUT = "javax.xml.ws.client.connectionTimeout";
    private static final String JDK_JAXWS_REQUEST_TIMEOUT = "com.sun.xml.internal.ws.request.timeout";
    private static final String JBOSS_CXF_REQUEST_TIMEOUT = "javax.xml.ws.client.receiveTimeout";
    private static final String JAXWS_HOSTNAME_VERIFIER = "com.sun.xml.internal.ws.transport.https.client.hostname.verifier";
    private static final String JAXWS_SSL_SOCKET_FACTORY = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
    private static final String MSSP_NAMESPACE = "http://uri.etsi.org/TS102204/etsi204-kiuru.wsdl";
    private static final String MSSP_SIGNATURE_SERVICE = "MSS_SignatureService";
    private static final String WSDL_CLASSPATH_LOCATION = "/wsdl/etsi204-kiuru.wsdl";
    private final ClientConfiguration clientConfiguration;
    private final Class<PortType> portTypeClass;
    private final Supplier<String> serviceUrlSupplier;

    public MssServiceFactory(ClientConfiguration clientConfiguration, Class<PortType> portTypeClass, Supplier<String> serviceUrlSupplier) {
        this.clientConfiguration = clientConfiguration;
        this.portTypeClass = portTypeClass;
        this.serviceUrlSupplier = serviceUrlSupplier;
    }

    public MssService<PortType> create() {
        return this.createMssService();
    }

    public PooledObject<MssService<PortType>> wrap(MssService<PortType> mssService) {
        return new DefaultPooledObject(mssService);
    }

    private MssService<PortType> createMssService() {
        URL wsdlLocation = ((Object)((Object)this)).getClass().getResource(WSDL_CLASSPATH_LOCATION);
        if (wsdlLocation == null) {
            throw new ConfigurationException("Cannot find the classpath resource for the MID Client SOAP WSDL: [/wsdl/etsi204-kiuru.wsdl]. This seems to be a library packaging issue, as this WSDL file should be packaged in the MID client SOAP library by default");
        }
        try {
            log.info("Creating a new SOAP WS port for class: {}", (Object)this.portTypeClass.getSimpleName());
            Service ws = MSSSignatureService.create((URL)wsdlLocation, (QName)new QName(MSSP_NAMESPACE, MSSP_SIGNATURE_SERVICE));
            Object wsPort = ws.getPort(this.portTypeClass);
            SoapTrafficHandler soapTrafficHandler = new SoapTrafficHandler();
            BindingProvider bindingProvider = (BindingProvider)wsPort;
            Binding binding = bindingProvider.getBinding();
            List handlerList = binding.getHandlerChain();
            handlerList.add(soapTrafficHandler);
            binding.setHandlerChain(handlerList);
            this.logHttpConnectionConfiguration(this.clientConfiguration);
            bindingProvider.getRequestContext().put("com.sun.xml.ws.connect.timeout", this.clientConfiguration.getHttp().getConnectionTimeoutInMs());
            bindingProvider.getRequestContext().put(JDK_JAXWS_CONNECT_TIMEOUT, this.clientConfiguration.getHttp().getConnectionTimeoutInMs());
            bindingProvider.getRequestContext().put(JBOSS_CXF_CONNECT_TIMEOUT, this.clientConfiguration.getHttp().getConnectionTimeoutInMs());
            bindingProvider.getRequestContext().put("com.sun.xml.ws.request.timeout", this.clientConfiguration.getHttp().getResponseTimeoutInMs());
            bindingProvider.getRequestContext().put(JDK_JAXWS_REQUEST_TIMEOUT, this.clientConfiguration.getHttp().getResponseTimeoutInMs());
            bindingProvider.getRequestContext().put(JBOSS_CXF_REQUEST_TIMEOUT, this.clientConfiguration.getHttp().getResponseTimeoutInMs());
            SSLSocketFactory sslSocketFactory = this.produceAnSslSocketFactory(this.clientConfiguration);
            ProxyConfiguration proxyConfig = this.clientConfiguration.getProxy();
            if (proxyConfig.isEnabled()) {
                this.logProxyConfiguration(proxyConfig);
                sslSocketFactory = new ProxyAwareSSLSocketFactory(proxyConfig, sslSocketFactory);
            }
            bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sslSocketFactory);
            bindingProvider.getRequestContext().put(JAXWS_SSL_SOCKET_FACTORY, sslSocketFactory);
            if (!this.clientConfiguration.getTls().isHostnameVerification()) {
                NoopHostnameVerifier noopHostnameVerifier = new NoopHostnameVerifier();
                bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.hostname.verifier", noopHostnameVerifier);
                bindingProvider.getRequestContext().put(JAXWS_HOSTNAME_VERIFIER, noopHostnameVerifier);
            }
            String serviceBaseUrl = this.serviceUrlSupplier.get();
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", serviceBaseUrl);
            log.info("{} service initialised for {}", (Object)this.portTypeClass.getSimpleName(), (Object)serviceBaseUrl);
            return new MssService<Object>(wsPort, soapTrafficHandler);
        }
        catch (Exception e) {
            log.error("Failed to configure a new MID Client SOAP port", (Throwable)e);
            throw new MIDClientException("Failed to configure a new MID Client SOAP port", (Throwable)e);
        }
    }

    private void logHttpConnectionConfiguration(ClientConfiguration config) {
        logConfig.info("MSS Soap client: Configuring HTTP client: connection timeout [{}], response timeout [{}], max HTTP connections (total) [{}], HTTP connections per route [{}]", new Object[]{config.getHttp().getConnectionTimeoutInMs(), config.getHttp().getResponseTimeoutInMs(), config.getHttp().getMaxTotalConnections(), config.getHttp().getMaxConnectionsPerRoute()});
    }

    private void logProxyConfiguration(ProxyConfiguration config) {
        logConfig.info("Configuring PROXY parameters: enabled [{}], host [{}], port [{}], username [{}], password [{}]", new Object[]{config.isEnabled(), config.getHost(), config.getPort(), config.getUsername(), config.getPassword() != null ? "(not-null)" : "null"});
    }

    private SSLSocketFactory produceAnSslSocketFactory(ClientConfiguration config) {
        TlsConfiguration tlsConfig = config.getTls();
        this.logTlsConfiguration(tlsConfig);
        try {
            SSLContext sslContext = tlsConfig.getSslContext() == null ? SSLContext.getInstance("Default") : SSLContext.getInstance(tlsConfig.getSslContext());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(this.produceAKeyStore(tlsConfig), tlsConfig.getKeyStoreKeyPassword().toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            if (this.trustStoreIsConfigured(tlsConfig)) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(this.produceATrustStore(tlsConfig));
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to configure the SSL Socket factory for the MID SOAP client", (Throwable)e);
        }
    }

    private void logTlsConfiguration(TlsConfiguration tlsConfig) {
        String keyStoreSource = tlsConfig.getKeyStoreFile() != null ? "file: [" + tlsConfig.getKeyStoreFile() + "]" : (tlsConfig.getKeyStoreClasspathFile() != null ? "classpath: [" + tlsConfig.getKeyStoreClasspathFile() + "]" : "input stream (byte content)");
        String trustStoreSource = tlsConfig.getTrustStoreFile() != null ? "file: [" + tlsConfig.getTrustStoreFile() + "]" : (tlsConfig.getTrustStoreClasspathFile() != null ? "classpath: [" + tlsConfig.getTrustStoreClasspathFile() + "]" : "input stream (byte content)");
        logConfig.info("MSS Soap client: Configuring TLS connection factory for MID client: key store source: [{}], key store type: [{}], key store alias: [{}], trust store source: [{}], trust store type: [{}]", new Object[]{keyStoreSource, tlsConfig.getKeyStoreType(), tlsConfig.getKeyStoreCertificateAlias(), trustStoreSource, tlsConfig.getTrustStoreType()});
    }

    private KeyStore produceAKeyStore(TlsConfiguration tlsConfig) {
        try {
            KeyStore keyStore = KeyStore.getInstance(tlsConfig.getKeyStoreType());
            if (tlsConfig.getKeyStoreFile() != null) {
                try (FileInputStream is = new FileInputStream(tlsConfig.getKeyStoreFile());){
                    keyStore.load(is, tlsConfig.getKeyStorePassword() == null ? null : tlsConfig.getKeyStorePassword().toCharArray());
                }
            }
            if (tlsConfig.getKeyStoreClasspathFile() != null) {
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(tlsConfig.getKeyStoreClasspathFile());){
                    keyStore.load(is, tlsConfig.getKeyStorePassword() == null ? null : tlsConfig.getKeyStorePassword().toCharArray());
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(tlsConfig.getKeyStoreBytes());){
                keyStore.load(is, tlsConfig.getKeyStorePassword() == null ? null : tlsConfig.getKeyStorePassword().toCharArray());
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to initialize the TLS keystore", (Throwable)e);
        }
    }

    private boolean trustStoreIsConfigured(TlsConfiguration tlsConfig) {
        return tlsConfig.getTrustStoreFile() != null || tlsConfig.getTrustStoreClasspathFile() != null || tlsConfig.getTrustStoreBytes() != null;
    }

    private KeyStore produceATrustStore(TlsConfiguration tlsConfig) {
        try {
            KeyStore keyStore = KeyStore.getInstance(tlsConfig.getTrustStoreType());
            if (tlsConfig.getTrustStoreFile() != null) {
                try (FileInputStream is = new FileInputStream(tlsConfig.getTrustStoreFile());){
                    keyStore.load(is, tlsConfig.getTrustStorePassword() == null ? null : tlsConfig.getTrustStorePassword().toCharArray());
                }
            }
            if (tlsConfig.getTrustStoreClasspathFile() != null) {
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(tlsConfig.getTrustStoreClasspathFile());){
                    keyStore.load(is, tlsConfig.getTrustStorePassword() == null ? null : tlsConfig.getTrustStorePassword().toCharArray());
                }
            }
            try (ByteArrayInputStream is = new ByteArrayInputStream(tlsConfig.getTrustStoreBytes());){
                keyStore.load(is, tlsConfig.getTrustStorePassword() == null ? null : tlsConfig.getTrustStorePassword().toCharArray());
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to initialize the TLS truststore", (Throwable)e);
        }
    }

    private static class NoopHostnameVerifier
    implements HostnameVerifier {
        private NoopHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostName, SSLSession session) {
            return true;
        }
    }
}

