/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.soap;

import ch.swisscom.mid.client.config.ProxyConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Base64;
import javax.net.ssl.SSLSocketFactory;

public class ProxyAwareSSLSocketFactory
extends SSLSocketFactory {
    private final ProxyConfiguration proxyConfig;
    private final SSLSocketFactory delegateSocketFactory;
    private Socket proxySocket;

    public ProxyAwareSSLSocketFactory(ProxyConfiguration proxyConfig, SSLSocketFactory delegateSocketFactory) {
        this.proxyConfig = proxyConfig;
        this.delegateSocketFactory = delegateSocketFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return new String[0];
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        if (this.proxySocket == null) {
            this.proxySocket = this.connectAndReturnProxySocket(host, port);
        }
        return this.delegateSocketFactory.createSocket(this.proxySocket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (this.proxySocket == null) {
            this.proxySocket = this.connectAndReturnProxySocket(host, port);
        }
        return this.delegateSocketFactory.createSocket(this.proxySocket, host, port, true);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException("This SSL socket factory method is not supported");
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        throw new UnsupportedOperationException("This SSL socket factory method is not supported");
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        throw new UnsupportedOperationException("This SSL socket factory method is not supported");
    }

    private Socket connectAndReturnProxySocket(String targetHost, int targetPort) throws IOException {
        try {
            String replyStr;
            byte[] httpContentBytes;
            String proxyHost = this.proxyConfig.getHost();
            int proxyPort = this.proxyConfig.getPort();
            Socket proxySocket = new Socket(proxyHost, proxyPort);
            OutputStream proxySocketOutput = proxySocket.getOutputStream();
            String httpContent = "CONNECT " + targetHost + ":" + targetPort + " HTTP/1.1\r\n" + this.buildUserAgentHeader() + this.buildProxyAuthorizationHeader() + "\r\n";
            try {
                httpContentBytes = httpContent.getBytes("ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                httpContentBytes = httpContent.getBytes();
            }
            proxySocketOutput.write(httpContentBytes);
            proxySocketOutput.flush();
            byte[] reply = new byte[200];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            InputStream proxySocketInput = proxySocket.getInputStream();
            while (newlinesSeen < 2) {
                int i = proxySocketInput.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone || replyLen >= reply.length) continue;
                reply[replyLen++] = (byte)i;
            }
            try {
                replyStr = new String(reply, 0, replyLen, "ASCII7");
            }
            catch (UnsupportedEncodingException ignored) {
                replyStr = new String(reply, 0, replyLen);
            }
            if (!replyStr.startsWith("HTTP/1.1 200")) {
                throw new IOException("Unable to proxy through " + proxyHost + ":" + proxyPort + ". Proxy returned \"" + replyStr + "\"");
            }
            return proxySocket;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String buildUserAgentHeader() {
        String javaVersion = "Java/" + System.getProperty("java.version");
        String userAgentValue = System.getProperty("http.agent") == null ? javaVersion : System.getProperty("http.agent") + " " + javaVersion;
        return "User-Agent: " + userAgentValue + "\r\n";
    }

    private String buildProxyAuthorizationHeader() throws UnsupportedEncodingException {
        if (this.proxyConfig.getUsername() != null) {
            return "Proxy-Authorization: Basic " + Base64.getEncoder().encodeToString((this.proxyConfig.getUsername() + ":" + this.proxyConfig.getPassword()).getBytes("ASCII7")) + "\r\n";
        }
        return "";
    }
}

