/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.cli;

import ch.swisscom.mid.client.config.ComProtocol;
import ch.swisscom.mid.client.config.RequestTrace;
import ch.swisscom.mid.client.config.ResponseTrace;
import ch.swisscom.mid.client.config.TrafficObserver;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrettyPrintingTrafficObserver
implements TrafficObserver {
    private static final Logger logClient = LoggerFactory.getLogger((String)"ch.swisscom.mid.client");
    private final ObjectMapper jacksonMapper = new ObjectMapper();

    public void notifyOfGeneratedApTransId(String apTransId, ComProtocol protocol) {
    }

    public void notifyOfOutgoingRequest(RequestTrace trace, ComProtocol protocol) {
        System.out.println(">>> " + "--------------------------------------------------------------------------------".substring(4));
        if (protocol == ComProtocol.REST) {
            System.out.println(this.toPrettyJson(trace.getBody()));
        } else {
            System.out.println(trace.getBody());
        }
        System.out.println("--------------------------------------------------------------------------------");
    }

    public void notifyOfIncomingResponse(ResponseTrace trace, ComProtocol protocol) {
        System.out.println("<<< " + "--------------------------------------------------------------------------------".substring(4));
        if (protocol == ComProtocol.REST) {
            System.out.println(this.toPrettyJson(trace.getBody()));
        } else {
            System.out.println(trace.getBody());
        }
        System.out.println("--------------------------------------------------------------------------------");
    }

    private String toPrettyJson(String json) {
        try {
            Object jsonObject = this.jacksonMapper.readValue(json, Object.class);
            return this.jacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (Exception exception) {
            logClient.warn("Failed to convert non-pretty JSON to pretty JSON", (Throwable)exception);
            return json;
        }
    }
}

