/*
 * Decompiled with CFR 0.152.
 */
package ch.swisscom.mid.client.cli;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.swisscom.mid.client.MIDClientException;
import ch.swisscom.mid.client.cli.ClientVersionProvider;
import ch.swisscom.mid.client.cli.PrettyPrintingTrafficObserver;
import ch.swisscom.mid.client.config.ClientConfiguration;
import ch.swisscom.mid.client.config.HttpConfiguration;
import ch.swisscom.mid.client.config.ProxyConfiguration;
import ch.swisscom.mid.client.config.SignatureValidationConfiguration;
import ch.swisscom.mid.client.config.TlsConfiguration;
import ch.swisscom.mid.client.config.TrafficObserver;
import ch.swisscom.mid.client.config.UrlsConfiguration;
import ch.swisscom.mid.client.impl.MIDClientImpl;
import ch.swisscom.mid.client.impl.SignatureValidatorImpl;
import ch.swisscom.mid.client.model.AdditionalService;
import ch.swisscom.mid.client.model.GeofencingAdditionalService;
import ch.swisscom.mid.client.model.ProfileRequest;
import ch.swisscom.mid.client.model.ProfileResponse;
import ch.swisscom.mid.client.model.ReceiptRequest;
import ch.swisscom.mid.client.model.ReceiptResponse;
import ch.swisscom.mid.client.model.SignatureRequest;
import ch.swisscom.mid.client.model.SignatureResponse;
import ch.swisscom.mid.client.model.SignatureValidationResult;
import ch.swisscom.mid.client.model.StatusCode;
import ch.swisscom.mid.client.model.UserLanguage;
import ch.swisscom.mid.client.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cli {
    private static final Logger logClient = LoggerFactory.getLogger((String)"ch.swisscom.mid.client");
    public static final String SEPARATOR = "--------------------------------------------------------------------------------";
    private static final String PARAM_CONFIG = "config";
    private static final String PARAM_INIT = "init";
    private static final String PARAM_PROFILE_QUERY = "profile-query";
    private static final String PARAM_SIGN = "sign";
    private static final String PARAM_GET_MID_SN = "get-mid-sn";
    private static final String PARAM_SYNC = "sync";
    private static final String PARAM_ASYNC = "async";
    private static final String PARAM_RECEIPT = "receipt";
    private static final String PARAM_LANG = "lang";
    private static final String PARAM_MSISDN = "msisdn";
    private static final String PARAM_DTBS = "dtbs";
    private static final String PARAM_REQUEST_TIMEOUT = "req-timeout";
    private static final String PARAM_REST = "rest";
    private static final String PARAM_SOAP = "soap";
    private static final String PARAM_GEO = "geofencing";
    private static final String PARAM_VALIDATE_SIGNATURE = "validate";
    private static final String PARAM_HELP = "help";
    private static final String PARAM_VERBOSE1 = "v";
    private static final String PARAM_VERBOSE2 = "vv";
    private static final String PARAM_VERBOSE3 = "vvv";
    private static final String HEADER = "Swisscom Mobile ID Java client ";
    private static final String OPERATION_SIGN = "sign";
    private static final String OPERATION_PROFILE_QUERY = "profile-query";
    private static final String OPERATION_GET_MID_SN = "get-mid-sn";
    private static final String INTERFACE_REST = "rest";
    private static final String INTERFACE_SOAP = "soap";
    private static ClientVersionProvider versionProvider;
    private static boolean continueExecution;
    private static String startFolder;
    private static String configFile;
    private static String operation;
    private static String lang;
    private static String msisdn;
    private static String dtbs;
    private static int requestTimeout;
    private static final String receiptDtbd = "Login completed successfully";
    private static boolean syncSignature;
    private static boolean sendReceipt;
    private static boolean validateSignature;
    private static String interfaceType;
    private static int verboseLevel;
    private static boolean addGeofencingSrv;

    public static void main(String[] args) {
        UrlsConfiguration urls;
        versionProvider = new ClientVersionProvider();
        versionProvider.init();
        startFolder = new File("").getAbsolutePath();
        Cli.parseArguments(args);
        if (!continueExecution) {
            return;
        }
        Cli.configureLogback();
        Cli.printStartupParameters();
        Properties properties = Cli.loadConfigProperties();
        PrettyPrintingTrafficObserver prettyPrinterTrafficObserver = new PrettyPrintingTrafficObserver();
        ObjectMapper jacksonMapper = new ObjectMapper();
        jacksonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setApId(properties.getProperty("client.msspApId"));
        clientConfig.setApPassword(properties.getProperty("client.msspApPassword"));
        if (interfaceType.equals("rest")) {
            clientConfig.setProtocolToRest();
            urls = clientConfig.getUrls();
            urls.setAllServiceUrlsTo(properties.getProperty("server.rest.url"));
        } else {
            clientConfig.setProtocolToSoap();
            urls = clientConfig.getUrls();
            urls.setSignatureServiceUrl(properties.getProperty("server.soap.signatureUrl"));
            urls.setStatusQueryServiceUrl(properties.getProperty("server.soap.statusQueryUrl"));
            urls.setReceiptServiceUrl(properties.getProperty("server.soap.receiptUrl"));
            urls.setProfileQueryServiceUrl(properties.getProperty("server.soap.profileQueryUrl"));
        }
        TlsConfiguration tls = clientConfig.getTls();
        tls.setKeyStoreFile(properties.getProperty("client.keyStore.file"));
        tls.setKeyStorePassword(properties.getProperty("client.keyStore.password"));
        tls.setKeyStoreKeyPassword(properties.getProperty("client.keyStore.keyPassword"));
        tls.setKeyStoreCertificateAlias(properties.getProperty("client.keyStore.certAlias"));
        tls.setSslContext(properties.getProperty("client.tls.sslContext"));
        tls.setTrustStoreFile(properties.getProperty("server.trustStore.file"));
        tls.setTrustStorePassword(properties.getProperty("server.trustStore.password"));
        tls.setHostnameVerification(Boolean.parseBoolean(properties.getProperty("server.hostnameVerification")));
        HttpConfiguration http = clientConfig.getHttp();
        http.setConnectionTimeoutInMs(Integer.parseInt(properties.getProperty("client.http.connectionTimeoutInSeconds")) * 1000);
        http.setResponseTimeoutInMs(Integer.parseInt(properties.getProperty("client.http.responseTimeoutInSeconds")) * 1000);
        boolean proxyEnabled = Boolean.parseBoolean(properties.getProperty("client.proxy.enabled", "false"));
        if (proxyEnabled) {
            ProxyConfiguration proxyConfig = clientConfig.getProxy();
            proxyConfig.setEnabled(true);
            proxyConfig.setHost(properties.getProperty("client.proxy.host", "").trim());
            proxyConfig.setPort(Integer.parseInt(properties.getProperty("client.proxy.port", "0")));
            String proxyUsername = properties.getProperty("client.proxy.username", null);
            String proxyPassword = properties.getProperty("client.proxy.password", null);
            if (proxyUsername != null && proxyUsername.trim().length() > 0) {
                proxyConfig.setUsername(proxyUsername.trim());
            }
            if (proxyPassword != null && proxyPassword.trim().length() > 0) {
                proxyConfig.setPassword(proxyPassword.trim());
            }
        }
        String finalResult = null;
        try (MIDClientImpl midClient = new MIDClientImpl(clientConfig);){
            SignatureRequest request;
            if (operation.equals("profile-query")) {
                ProfileRequest profileRequest = new ProfileRequest();
                profileRequest.getMobileUser().setMsisdn(msisdn);
                profileRequest.setExtensionParamsToAllValues();
                profileRequest.setTrafficObserver((TrafficObserver)prettyPrinterTrafficObserver);
                ProfileResponse response = midClient.requestProfile(profileRequest);
                finalResult = "Profile response:\n" + jacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
            } else if (operation.equals("get-mid-sn")) {
                SignatureResponse response;
                request = new SignatureRequest();
                request.setUserLanguage(UserLanguage.getByValue((String)lang));
                request.getDataToBeSigned().setData(dtbs);
                request.getMobileUser().setMsisdn(msisdn);
                request.setSignatureProfile("http://mid.swisscom.ch/Any-LoA4");
                request.setTrafficObserver((TrafficObserver)prettyPrinterTrafficObserver);
                request.setUserResponseTimeOutInSeconds(requestTimeout);
                if (syncSignature) {
                    response = midClient.requestSyncSignature(request);
                } else {
                    response = midClient.requestAsyncSignature(request);
                    while (response.getStatus().getStatusCode() == StatusCode.REQUEST_OK || response.getStatus().getStatusCode() == StatusCode.OUTSTANDING_TRANSACTION) {
                        Thread.sleep(5000L);
                        response = midClient.pollForSignatureStatus(response.getTracking());
                    }
                }
                System.out.println(response.toString());
                if (response.getStatus().getStatusCode() == StatusCode.SIGNATURE) {
                    SignatureValidationConfiguration svConfig = new SignatureValidationConfiguration();
                    svConfig.setTrustStoreFile(properties.getProperty("client.signatureValidation.trustStore.file"));
                    svConfig.setTrustStoreType(properties.getProperty("client.signatureValidation.trustStore.type"));
                    svConfig.setTrustStorePassword(Utils.getThisOrNull((String)properties.getProperty("client.signatureValidation.trustStore.password")));
                    SignatureValidatorImpl validator = new SignatureValidatorImpl(svConfig);
                    String midSN = validator.getMIDSerialNumber(response.getBase64Signature(), null);
                    System.out.println("Received Mobile ID serial number=[" + midSN + "]");
                }
            } else {
                SignatureResponse response;
                request = new SignatureRequest();
                request.setUserLanguage(UserLanguage.getByValue((String)lang));
                request.getDataToBeSigned().setData(dtbs);
                request.getMobileUser().setMsisdn(msisdn);
                request.setSignatureProfile("http://mid.swisscom.ch/Any-LoA4");
                if (addGeofencingSrv) {
                    request.addAdditionalService((AdditionalService)new GeofencingAdditionalService());
                }
                request.setTrafficObserver((TrafficObserver)prettyPrinterTrafficObserver);
                request.setUserResponseTimeOutInSeconds(requestTimeout);
                if (syncSignature) {
                    response = midClient.requestSyncSignature(request);
                } else {
                    response = midClient.requestAsyncSignature(request);
                    while (response.getStatus().getStatusCode() == StatusCode.REQUEST_OK || response.getStatus().getStatusCode() == StatusCode.OUTSTANDING_TRANSACTION) {
                        Thread.sleep(5000L);
                        response = midClient.pollForSignatureStatus(response.getTracking());
                    }
                }
                System.out.println(response.toString());
                if (response.getStatus().getStatusCode() == StatusCode.SIGNATURE) {
                    boolean signatureIsValid = false;
                    if (validateSignature) {
                        SignatureValidationConfiguration svConfig = new SignatureValidationConfiguration();
                        svConfig.setTrustStoreFile(properties.getProperty("client.signatureValidation.trustStore.file"));
                        svConfig.setTrustStoreType(properties.getProperty("client.signatureValidation.trustStore.type"));
                        svConfig.setTrustStorePassword(Utils.getThisOrNull((String)properties.getProperty("client.signatureValidation.trustStore.password")));
                        SignatureValidatorImpl validator = new SignatureValidatorImpl(svConfig);
                        SignatureValidationResult result = validator.validateSignature(response.getBase64Signature(), request.getDataToBeSigned().getData(), null);
                        if (result.isValidationSuccessful()) {
                            signatureIsValid = true;
                            Cli.printValidationResult(true, result);
                        } else {
                            Cli.printValidationResult(false, result);
                        }
                    }
                    if (sendReceipt) {
                        if (!validateSignature || signatureIsValid) {
                            ReceiptRequest receiptRequest = new ReceiptRequest();
                            receiptRequest.setStatusCode(StatusCode.REQUEST_OK);
                            receiptRequest.getMessageToBeDisplayed().setData(receiptDtbd);
                            receiptRequest.getRequestExtension().getReceiptProfile().setLanguage(lang);
                            receiptRequest.setTrafficObserver((TrafficObserver)prettyPrinterTrafficObserver);
                            ReceiptResponse receiptResponse = midClient.requestSyncReceipt(response.getTracking(), receiptRequest);
                            finalResult = "Receipt response:\n" + jacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)receiptResponse);
                        } else {
                            System.out.println("Signature was NOT valid so sending receipt was skipped");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(SEPARATOR);
            System.out.println(ch.swisscom.mid.client.samples.Utils.prettyPrintTheException(e));
        }
        if (finalResult != null) {
            System.out.println(SEPARATOR);
            System.out.println(finalResult);
            System.out.println(SEPARATOR);
        }
    }

    private static void printValidationResult(boolean isValid, SignatureValidationResult result) {
        if (isValid) {
            System.out.println("Signature is valid!");
            System.out.println("Mobile ID serial number = " + result.getMobileIdSerialNumber());
            System.out.println("Signed DTBS = " + result.getSignedDtbs());
        } else {
            System.out.println("Validation failure reason = " + result.getValidationFailureReason());
            System.out.println("Signing certificate path validation = " + result.isSignerCertificatePathValid());
            System.out.println("Signing certificate validation = " + result.isSignerCertificateValid());
            System.out.println("Signature validation = " + result.isSignatureValid());
            System.out.println("DTBS matching = " + result.isDtbsMatching());
            if (result.getValidationException() != null) {
                result.getValidationException().printStackTrace();
            }
        }
    }

    private static void parseArguments(String[] args) {
        if (args.length == 0) {
            Cli.showHelp(null);
            return;
        }
        block44: for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            int equalSignPos;
            String argName = args[argIndex];
            String argValue = null;
            if (argName.startsWith("--")) {
                argName = argName.substring(2);
            }
            if (argName.startsWith("-")) {
                argName = argName.substring(1);
            }
            if ((equalSignPos = argName.indexOf(61)) > 0) {
                argValue = argName.substring(equalSignPos + 1);
                argName = argName.substring(0, equalSignPos);
            }
            switch (argName) {
                case "help": {
                    Cli.showHelp(null);
                    return;
                }
                case "init": {
                    Cli.runInit();
                    return;
                }
                case "v": {
                    if (verboseLevel >= 1) continue block44;
                    verboseLevel = 1;
                    continue block44;
                }
                case "vv": {
                    if (verboseLevel >= 2) continue block44;
                    verboseLevel = 2;
                    continue block44;
                }
                case "vvv": {
                    if (verboseLevel >= 3) continue block44;
                    verboseLevel = 3;
                    continue block44;
                }
                case "config": {
                    if (argValue == null) {
                        if (argIndex + 1 < args.length) {
                            configFile = args[argIndex + 1];
                            ++argIndex;
                            continue block44;
                        }
                        Cli.showHelp("Configuration file name is missing");
                        continue block44;
                    }
                    configFile = argValue;
                    continue block44;
                }
                case "req-timeout": {
                    String strValue = null;
                    if (argValue == null) {
                        if (argIndex + 1 < args.length) {
                            strValue = args[argIndex + 1];
                            ++argIndex;
                        } else {
                            Cli.showHelp("Request timeout value (in seconds) is missing");
                        }
                    } else {
                        strValue = argValue;
                    }
                    if (strValue == null) continue block44;
                    requestTimeout = Integer.parseInt(strValue);
                    continue block44;
                }
                case "sign": {
                    if (operation != null) {
                        Cli.showHelp("More than one operation selector was found in the calling arguments. Use either -sign or -profile-query or -get-mid-sn");
                        return;
                    }
                    operation = "sign";
                    continue block44;
                }
                case "profile-query": {
                    if (operation != null) {
                        Cli.showHelp("More than one operation selector was found in the calling arguments. Use either -sign or -profile-query or -get-mid-sn");
                        return;
                    }
                    operation = "profile-query";
                    continue block44;
                }
                case "get-mid-sn": {
                    if (operation != null) {
                        Cli.showHelp("More than one operation selector was found in the calling arguments. Use either -sign or -profile-query or -get-mid-sn");
                        return;
                    }
                    operation = "get-mid-sn";
                    continue block44;
                }
                case "sync": {
                    syncSignature = true;
                    continue block44;
                }
                case "async": {
                    syncSignature = false;
                    continue block44;
                }
                case "receipt": {
                    sendReceipt = true;
                    continue block44;
                }
                case "validate": {
                    validateSignature = true;
                    continue block44;
                }
                case "geofencing": {
                    addGeofencingSrv = true;
                    continue block44;
                }
                case "msisdn": {
                    if (argValue == null) {
                        if (argIndex + 1 < args.length) {
                            msisdn = args[argIndex + 1];
                            ++argIndex;
                            continue block44;
                        }
                        Cli.showHelp("MSISDN is missing");
                        continue block44;
                    }
                    msisdn = argValue;
                    continue block44;
                }
                case "lang": {
                    if (argValue == null) {
                        if (argIndex + 1 < args.length) {
                            lang = args[argIndex + 1];
                            ++argIndex;
                            continue block44;
                        }
                        Cli.showHelp("Language is missing (the lang parameter)");
                        continue block44;
                    }
                    lang = argValue;
                    continue block44;
                }
                case "dtbs": {
                    if (argValue == null) {
                        if (argIndex + 1 < args.length) {
                            dtbs = args[argIndex + 1];
                            ++argIndex;
                            continue block44;
                        }
                        Cli.showHelp("Data to be signed is missing (the dtbs parameter)");
                        continue block44;
                    }
                    dtbs = argValue;
                    continue block44;
                }
                case "rest": {
                    if (interfaceType != null) {
                        Cli.showHelp("More than one interface selector was found in the calling arguments. Use either -rest or -soap");
                        return;
                    }
                    interfaceType = "rest";
                    continue block44;
                }
                case "soap": {
                    if (interfaceType != null) {
                        Cli.showHelp("More than one interface selector was found in the calling arguments. Use either -rest or -soap");
                        return;
                    }
                    interfaceType = "soap";
                }
            }
        }
        if (operation == null) {
            Cli.showHelp("Operation selection is missing. Use either -sign or -profile-query");
            return;
        }
        if (msisdn == null) {
            Cli.showHelp("MSISDN is missing");
            return;
        }
        if (interfaceType == null) {
            interfaceType = "rest";
        }
        if (configFile == null) {
            configFile = "config.properties";
        }
        continueExecution = true;
    }

    private static void showHelp(String argsValidationError) {
        if (argsValidationError != null) {
            System.out.println(argsValidationError);
        }
        String usageText = Cli.copyFileFromClasspathToString("/cli-files/usage.txt");
        if (versionProvider.isVersionInfoAvailable()) {
            usageText = usageText.replace("${versionInfo}", "- " + versionProvider.getVersionInfo());
        }
        System.out.println(usageText);
    }

    private static void runInit() {
        String[][] configPairs;
        for (String[] configPair : configPairs = new String[][]{{"/cli-files/config-sample.properties", "config.properties"}, {"/cli-files/keystore.jks", "keystore.jks"}, {"/cli-files/truststore.jks", "truststore.jks"}, {"/cli-files/signature-validation-truststore.jks", "signature-validation-truststore.jks"}}) {
            String inputFile = configPair[0];
            String baseOutputFile = configPair[1];
            String outputFile = startFolder + "/" + baseOutputFile;
            if (new File(outputFile).exists()) {
                System.out.println("File " + baseOutputFile + " already exists! Will not be overridden!");
                return;
            }
            System.out.println("Writing " + baseOutputFile + " to " + outputFile);
            Cli.copyFileFromClasspathToDisk(inputFile, outputFile);
        }
    }

    private static void configureLogback() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        switch (verboseLevel) {
            case 0: {
                Cli.setLoggerToLevel("ROOT", "warn", loggerContext);
                Cli.setLoggerToLevel("org.apache.hc", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.config", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.protocol", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.requestResponse", "warn", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.fullRequestResponse", "warn", loggerContext);
                break;
            }
            case 1: {
                Cli.setLoggerToLevel("ROOT", "info", loggerContext);
                Cli.setLoggerToLevel("org.apache.hc", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.config", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.protocol", "info", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.requestResponse", "debug", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.fullRequestResponse", "warn", loggerContext);
                break;
            }
            case 2: 
            case 3: {
                Cli.setLoggerToLevel("ROOT", "debug", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client", "debug", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.config", "debug", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.protocol", "debug", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.requestResponse", "warn", loggerContext);
                Cli.setLoggerToLevel("ch.swisscom.mid.client.fullRequestResponse", "debug", loggerContext);
                if (verboseLevel == 2) {
                    Cli.setLoggerToLevel("org.apache.hc", "info", loggerContext);
                    break;
                }
                Cli.setLoggerToLevel("org.apache.hc", "trace", loggerContext);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid verboseLevel: " + verboseLevel);
            }
        }
    }

    private static void setLoggerToLevel(String loggerName, String level, LoggerContext loggerContext) {
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger(loggerName);
        if (logger != null) {
            logger.setLevel(Level.toLevel((String)level));
        }
    }

    private static String copyFileFromClasspathToString(String inputFile) {
        String string;
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            int bytesRead;
            baos = new ByteArrayOutputStream();
            is = Cli.class.getResourceAsStream(inputFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            Cli.closeStream(baos);
            string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            try {
                throw new MIDClientException("Failed to copy the file: [" + inputFile + "] to string");
            }
            catch (Throwable throwable) {
                Cli.closeStream(baos);
                Cli.closeStream(is);
                throw throwable;
            }
        }
        Cli.closeStream(baos);
        Cli.closeStream(is);
        return string;
    }

    private static void copyFileFromClasspathToDisk(String inputFile, String outputFile) {
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            int bytesRead;
            fos = new FileOutputStream(outputFile);
            is = Cli.class.getResourceAsStream(inputFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) > 0) {
                fos.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                throw new MIDClientException("Failed to create the file: [" + outputFile + "]");
            }
            catch (Throwable throwable) {
                Cli.closeStream(is);
                Cli.closeStream(fos);
                throw throwable;
            }
        }
        Cli.closeStream(is);
        Cli.closeStream(fos);
    }

    private static void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ignored) {
                logClient.warn("Failed to close stream of type {}", (Object)closeable.getClass().getName());
            }
        }
    }

    private static void printStartupParameters() {
        System.out.println(SEPARATOR);
        if (versionProvider.isVersionInfoAvailable()) {
            System.out.println(HEADER + versionProvider.getVersionInfo());
        } else {
            System.out.println(HEADER);
        }
        System.out.println(SEPARATOR);
        System.out.println("Starting with following parameters:");
        System.out.println("Operation             : " + operation);
        System.out.println("MSISDN                : " + msisdn);
        System.out.println("Config                : " + configFile);
        System.out.println("Interface             : " + interfaceType);
        if (operation.equals("sign")) {
            System.out.println("Async operation       : " + !syncSignature);
            System.out.println("Language              : " + lang);
            System.out.println("DTBS                  : " + dtbs);
            System.out.println("Send receipt          : " + sendReceipt);
        }
        System.out.println("Verbose level         : " + verboseLevel);
        System.out.println(SEPARATOR);
    }

    private static Properties loadConfigProperties() {
        Properties properties;
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            Properties properties2 = new Properties();
            properties2.load(is);
            properties = properties2;
        }
        catch (IOException exception) {
            try {
                throw new MIDClientException("Failed to load configuration properties from " + configFile, (Throwable)exception);
            }
            catch (Throwable throwable) {
                Cli.closeStream(is);
                throw throwable;
            }
        }
        Cli.closeStream(is);
        return properties;
    }

    static {
        lang = "en";
        dtbs = "Test: Do you want to login?";
        requestTimeout = 80;
        syncSignature = false;
        sendReceipt = false;
        validateSignature = false;
        addGeofencingSrv = false;
    }
}

