package ch.rhj.image.ico;

import static ch.rhj.image.ico.IcoConstants.VERSION;

import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Locale;

import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class IcoImageWriterSpi extends ImageWriterSpi {
	
	private static final String VENDOR = "Roger H. Jörg";
	private static final String[] NAMES = { "ico", "ICO" };
	private static final String[] SUFFIXES = { "ico", "ICO" };
	
	private static final String[] MIME_TYPES = {
		"image/x-icon", "image/vnd.microsoft.icon", "image/ico", "image/icon", "application/ico"
	};
	
	private static final String WRITER_CLASS_NAME = IcoImageWriter.class.getName();
	private static final Class<?>[] OUTPUT_TYPES = { ImageOutputStream.class };
	
	private static final String NATIVE_IMAGE_METADATA_FORMAT_NAME = "";
	private static final String NATIVE_IMAGE_METADATA_FORMAT_CLASS_NAME = "";
	
	private static final String DESCRIPTION = "ICO Image Writer";
	
	public IcoImageWriterSpi() {
		
		super(
			VENDOR,
			VERSION,
			NAMES,
			SUFFIXES,
			MIME_TYPES,
			WRITER_CLASS_NAME,
			OUTPUT_TYPES,
			null, // readerSpiNames
			true, // supportsStandardStreamMetadataFormat
			null, // nativeStreamMetadataFormatName
			null, // nativeStreamMetadataFormatClassName
			null, // extraStreamMetadataFormatNames
			null, // extraStreamMetadataFormatClassNames
			true, // supportsStandardImageMetadataFormat
			NATIVE_IMAGE_METADATA_FORMAT_NAME,
			NATIVE_IMAGE_METADATA_FORMAT_CLASS_NAME,
			null, // extraImageMetadataFormatNames
			null // extraImageMetadataFormatClassNames
		);
	}

	@Override
	public boolean canEncodeImage(ImageTypeSpecifier type) {

		SampleModel sampleModel = type.getSampleModel();
		
		return sampleModel instanceof MultiPixelPackedSampleModel;
	}

	@Override
	public ImageWriter createWriterInstance(Object extension) throws IOException {

		return new IcoImageWriter(this);
	}

	@Override
	public String getDescription(Locale locale) {

		return DESCRIPTION;
	}

}
