/*
 * Decompiled with CFR 0.152.
 */
package ch.rhj.image;

import ch.rhj.image.Image;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class Icon {
    private static final int[] DEFAULT_SIZES = new int[]{16, 32, 48, 64, 96, 128, 192, 256};
    protected final ArrayList<Image> images = new ArrayList();

    public Icon(int ... sizes) {
        for (int size : sizes) {
            this.images.add(Image.create(size, size, 2));
        }
    }

    public Icon() {
        this(DEFAULT_SIZES);
    }

    protected Icon(Image ... images) {
        Stream.of(images).forEach(image -> this.images.add((Image)image));
    }

    public Icon paint(BiConsumer<Graphics2D, Integer> painter) {
        this.images.forEach(image -> image.paint((Graphics2D g) -> painter.accept((Graphics2D)g, image.getWidth())));
        return this;
    }

    public Stream<Image> stream() {
        return this.images.stream();
    }

    public static Icon create(int ... sizes) {
        return new Icon(sizes);
    }

    public static Icon create() {
        return new Icon();
    }

    public static Image convert(java.awt.Image source) {
        int size = Math.min(source.getWidth(null), source.getHeight(null));
        return Image.of(source, 2, 0, 0, size, size);
    }

    public static Icon of(java.awt.Image ... sources) {
        return new Icon((Image[])Stream.of(sources).map(Icon::convert).toArray(Image[]::new));
    }
}

