/*
 * Decompiled with CFR 0.152.
 */
package ch.rhj.image;

import ch.rhj.image.Icon;
import ch.rhj.lang.EX;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class Icons {
    public static void write(Icon icon, File output) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(output);){
            Icons.write(icon, fos);
            fos.flush();
        }
    }

    public static void write(Icon icon, OutputStream output) throws IOException {
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(output);){
            Icons.write(icon, ios);
            ios.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Icon icon, ImageOutputStream output) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("ico");
        if (!writers.hasNext()) {
            throw new IOException("format not supported");
        }
        ImageWriter writer = writers.next();
        if (writer == null) {
            throw new IOException("format not supported");
        }
        try {
            ImageWriteParam imageWriteParam = writer.getDefaultWriteParam();
            IIOMetadata streamMetadata = writer.getDefaultStreamMetadata(imageWriteParam);
            writer.setOutput(output);
            writer.prepareWriteSequence(streamMetadata);
            icon.stream().map(image -> new IIOImage((RenderedImage)image, null, null)).forEach(EX.consumer(image -> writer.writeToSequence((IIOImage)image, null)));
            writer.endWriteSequence();
        }
        finally {
            writer.dispose();
        }
    }
}

