/*
 * Decompiled with CFR 0.152.
 */
package ch.rhj.image;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;

public class Image
extends BufferedImage {
    public Image(int width, int height, int imageType) {
        super(width, height, imageType);
    }

    public Image(int width, int height) {
        this(width, height, 2);
    }

    public Image paint(Consumer<Graphics2D> painter) {
        Graphics2D graphics = this.createGraphics();
        painter.accept(graphics);
        graphics.dispose();
        return this;
    }

    public static Image create(int width, int height, int imageType) {
        return new Image(width, height, imageType);
    }

    public static Image create(int width, int height) {
        return new Image(width, height);
    }

    public static Image of(java.awt.Image source, int imageType, int x, int y, int w, int h) {
        return Image.create(w, h, imageType).paint(g -> g.drawImage(source, x, y, w, h, null));
    }

    public static Image of(java.awt.Image source, int imageType) {
        return Image.of(source, imageType, 0, 0, source.getWidth(null), source.getHeight(null));
    }

    public static Image of(java.awt.Image source) {
        return Image.of(source, 2);
    }
}

