/*
 * Decompiled with CFR 0.152.
 */
package ch.rhj.image.ico;

import ch.rhj.image.ico.IcoMetadataFormat;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class IcoMetadata
extends IIOMetadata
implements Cloneable {
    public static final String NATIVE_METADATA_FORMAT_NAME = "ch_rhj_image_ico_0.2.0";
    public int width;
    public int height;
    public short bitsPerPixel;
    public byte[] palette = null;
    public int paletteSize;

    public IcoMetadata() {
        super(true, NATIVE_METADATA_FORMAT_NAME, IcoMetadataFormat.class.getName(), null, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (NATIVE_METADATA_FORMAT_NAME.equals(formatName)) {
            return this.getNativeTree();
        }
        if ("javax_imageio_1.0".equals(formatName)) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("metadata format '" + formatName + "' not supported");
    }

    @Override
    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new IllegalStateException("metadata is read-only");
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new IllegalStateException("metadata is read-only");
    }

    @Override
    public void reset() {
        throw new IllegalStateException("metadata is read-only");
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode result = new IIOMetadataNode("Chroma");
        IIOMetadataNode colorSpaceTypeNode = new IIOMetadataNode("ColorSpaceType");
        colorSpaceTypeNode.setAttribute("name", "RGB");
        result.appendChild(colorSpaceTypeNode);
        IIOMetadataNode numChannelsNode = new IIOMetadataNode("NumChannels");
        numChannelsNode.setAttribute("value", "4");
        result.appendChild(numChannelsNode);
        IIOMetadataNode paletteNode = new IIOMetadataNode("Palette");
        int j = 0;
        for (int i = 0; i < this.paletteSize; ++i) {
            IIOMetadataNode entryNode = new IIOMetadataNode("PaletteEntry");
            int blue = this.palette[j++] & 0xFF;
            int green = this.palette[j++] & 0xFF;
            int red = this.palette[j++] & 0xFF;
            entryNode.setAttribute("index", Integer.toString(i));
            entryNode.setAttribute("blue", Integer.toString(blue));
            entryNode.setAttribute("green", Integer.toString(green));
            entryNode.setAttribute("red", Integer.toString(red));
            paletteNode.appendChild(entryNode);
        }
        result.appendChild(paletteNode);
        return result;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        throw new RuntimeException("not yet implemented");
    }

    public IcoMetadata clone() {
        try {
            return (IcoMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(NATIVE_METADATA_FORMAT_NAME);
        IIOMetadataNode widthNode = new IIOMetadataNode("Width");
        IIOMetadataNode heightNode = new IIOMetadataNode("Height");
        IIOMetadataNode bitsPerPixelNode = new IIOMetadataNode("BitsPerPixel");
        widthNode.setUserObject(this.width);
        widthNode.setNodeValue(Integer.toString(this.width));
        heightNode.setUserObject(this.height);
        heightNode.setNodeValue(Integer.toString(this.height));
        bitsPerPixelNode.setUserObject(this.bitsPerPixel);
        bitsPerPixelNode.setNodeValue(Short.toString(this.bitsPerPixel));
        root.appendChild(widthNode);
        root.appendChild(heightNode);
        root.appendChild(bitsPerPixelNode);
        if (this.palette != null && this.paletteSize > 0) {
            IIOMetadataNode paletteNode = new IIOMetadataNode("Palette");
            root.appendChild(paletteNode);
            int j = 0;
            for (int i = 0; i < this.paletteSize; ++i) {
                IIOMetadataNode entryNode = new IIOMetadataNode("PaletteEntry");
                int blue = this.palette[j++] & 0xFF;
                int green = this.palette[j++] & 0xFF;
                int red = this.palette[j++] & 0xFF;
                IIOMetadataNode blueNode = new IIOMetadataNode("Blue");
                IIOMetadataNode greenNode = new IIOMetadataNode("Green");
                IIOMetadataNode redNode = new IIOMetadataNode("Red");
                blueNode.setUserObject(blue);
                blueNode.setNodeValue(Integer.toString(blue));
                greenNode.setUserObject(green);
                greenNode.setNodeValue(Integer.toString(green));
                redNode.setUserObject(red);
                redNode.setNodeValue(Integer.toString(red));
                entryNode.appendChild(blueNode);
                entryNode.appendChild(greenNode);
                entryNode.appendChild(redNode);
                paletteNode.appendChild(entryNode);
            }
        }
        return root;
    }
}

