package ch.rhj.image;

import static java.awt.image.BufferedImage.TYPE_INT_ARGB;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class Icon {
	
	private static final int[] DEFAULT_SIZES = {
		16, 32, 48, 64, 96, 128, 192, 256
	};

	protected final ArrayList<Image> images = new ArrayList<Image>();
	
	public Icon(int... sizes) {
		
		for (int size : sizes)
			images.add(Image.create(size, size, TYPE_INT_ARGB));
	}
	
	public Icon() {
		
		this(DEFAULT_SIZES);
	}
	
	protected Icon(Image... images) {
		
		Stream.of(images).forEach(image -> this.images.add(image));
	}
	
	public Icon paint(BiConsumer<Graphics2D, Integer> painter) {
		
		images.forEach(image -> image.paint(g -> painter.accept(g, image.getWidth())));
		
		return this;
	}
	
	public Stream<Image> stream() {
		
		return images.stream();
	}
	
	public static Icon create(int... sizes) {
		
		return new Icon(sizes);
	}
	
	public static Icon create() {
		
		return new Icon();
	}
	
	public static Image convert(java.awt.Image source) {
		
		int size = Math.min(source.getWidth(null), source.getHeight(null));
		
		return Image.of(source, TYPE_INT_ARGB, 0, 0, size, size);
	}
	
	public static Icon of(java.awt.Image... sources) {
		
		return new Icon(Stream.of(sources).map(Icon::convert).toArray(Image[]::new));
	}
}
