package ch.rhj.image;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

import ch.rhj.lang.EX;

public class Icons {

	public static void write(Icon icon, File output) throws IOException {
		
		try (FileOutputStream fos = new FileOutputStream(output)) {
			
			write(icon, fos);
			fos.flush();
		}
	}
	
	public static void write(Icon icon, OutputStream output) throws IOException {
		
		try (ImageOutputStream ios = ImageIO.createImageOutputStream(output)) {
			
			write(icon, ios);
			ios.flush();
		}
	}
	
	public static void write(Icon icon, ImageOutputStream output) throws IOException {
		
		Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("ico");
		
		if (!writers.hasNext())
			throw new IOException("format not supported");
		
		ImageWriter writer = writers.next();
		
		if (writer == null)
			throw new IOException("format not supported");
				
		try {
			
			ImageWriteParam imageWriteParam = writer.getDefaultWriteParam();
			IIOMetadata streamMetadata = writer.getDefaultStreamMetadata(imageWriteParam);
			
			writer.setOutput(output);
			writer.prepareWriteSequence(streamMetadata);
			
			icon.stream()
				.map(image -> new IIOImage(image, null, null))
				.forEach(EX.consumer(image -> writer.writeToSequence(image, null)));
			
			writer.endWriteSequence();
			
		} finally {
			
			writer.dispose();
		}
	}
}
