/*
 * Decompiled with CFR 0.152.
 */
package ch.rhj.image.ico;

import ch.rhj.image.ico.IcoMetadata;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class IcoImageWriter
extends ImageWriter {
    private static final int HEADER_SIZE = 6;
    private static final int ENTRY_SIZE = 16;
    private final ArrayList<IIOImage> images = new ArrayList();
    private final ArrayList<byte[]> buffers = new ArrayList();

    public IcoImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return new IcoMetadata();
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public boolean canWriteRasters() {
        return false;
    }

    @Override
    public boolean canWriteSequence() {
        return true;
    }

    @Override
    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        this.images.clear();
        this.buffers.clear();
    }

    @Override
    public void endWriteSequence() throws IOException {
        ImageOutputStream stream = (ImageOutputStream)this.getOutput();
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        try {
            this.createBuffers();
            this.writeHeader(stream);
            this.writeIndex(stream);
            this.writeImages(stream);
            stream.flush();
        }
        finally {
            this.buffers.clear();
        }
    }

    @Override
    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        this.images.add(image);
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        this.prepareWriteSequence(streamMetadata);
        this.writeToSequence(image, param);
        this.endWriteSequence();
    }

    private void createBuffers() throws IOException {
        for (IIOImage image : this.images) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write(image.getRenderedImage(), "png", output);
            this.buffers.add(output.toByteArray());
        }
    }

    private void writeHeader(ImageOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeShort(1);
        stream.writeShort(this.images.size());
    }

    private void writeIndex(ImageOutputStream stream) throws IOException {
        int offset = 6 + this.images.size() * 16;
        int n = this.images.size();
        for (int i = 0; i < n; ++i) {
            IIOImage image = this.images.get(i);
            RenderedImage rendered = image.getRenderedImage();
            int width = rendered.getWidth();
            int height = rendered.getHeight();
            int size = this.buffers.get(i).length;
            if (width > 255) {
                width = 0;
            }
            if (height > 255) {
                height = 0;
            }
            stream.write(width);
            stream.write(height);
            stream.write(0);
            stream.write(0);
            stream.writeShort(1);
            stream.writeShort(32);
            stream.writeInt(size);
            stream.writeInt(offset);
            offset += size;
        }
    }

    private void writeImages(ImageOutputStream stream) throws IOException {
        for (byte[] buffer : this.buffers) {
            stream.write(buffer);
        }
    }
}

