package ch.rhj.lang;

public class EX<V> {
	
	public final V value;
	public final Exception exception;
	
	private EX(V value, Exception exception) {
		
		this.value = value;
		this.exception = exception;
	}
	
	public static <T> EX<T> ofValue(T value) {
		
		return new EX<>(value, null);
	}
	
	public static <T> EX<T> ofException(Exception exception) {
		
		return new EX<>(null, exception);
	}

	public static interface Supplier<T> {
		
		T get() throws Exception;
	}
	
	public static interface Consumer<T> {
		
		void accept(T t) throws Exception;
	}
	
	public static interface BiConsumer<T, U> {
		
		void accept(T t, U u) throws Exception;
	}
	
	public static interface Function<T, R> {
		
		R apply(T t) throws Exception;
	}
	
	public static interface BiFunction<T, U, R> {
		
		R apply(T t, U u) throws Exception;
	}
	
	public static interface Predicate<T> {
		
		boolean test(T t) throws Exception;
	}
	
	public static interface BiPredicate<T, U> {
		
		boolean test(T t, U u) throws Exception;
	}
	
	public static class SupplierWrapper<T> implements java.util.function.Supplier<T> {
		
		public final EX.Supplier<T> delegate;
		
		public SupplierWrapper(EX.Supplier<T> delegate) {
			
			this.delegate = delegate;
		}

		@Override
		public T get() {
			
			try {
				
				return delegate.get();
				
			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static class ConsumerWrapper<T> implements java.util.function.Consumer<T> {
		
		public final EX.Consumer<T> delegate;

		public ConsumerWrapper(Consumer<T> delegate) {

			this.delegate = delegate;
		}

		@Override
		public void accept(T t) {
			
			try {
				
				delegate.accept(t);

			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static class BiConsumerWrapper<T, U> implements java.util.function.BiConsumer<T, U> {
		
		public final EX.BiConsumer<T, U> delegate;

		public BiConsumerWrapper(BiConsumer<T, U> delegate) {

			this.delegate = delegate;
		}

		@Override
		public void accept(T t, U u) {
			
			try {
				
				delegate.accept(t, u);
				
			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static class FunctionWrapper<T, R> implements java.util.function.Function<T, R> {
		
		public final EX.Function<T, R> delegate;

		public FunctionWrapper(Function<T, R> delegate) {
			
			this.delegate = delegate;
		}

		@Override
		public R apply(T t) {
			
			try {
				
				return delegate.apply(t);
				
			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static class BiFunctionWrapper<T, U, R> implements java.util.function.BiFunction<T, U, R> {
		
		public EX.BiFunction<T, U, R> delegate;

		public BiFunctionWrapper(BiFunction<T, U, R> delegate) {
			
			this.delegate = delegate;
		}

		@Override
		public R apply(T t, U u) {

			try {
				
				return delegate.apply(t, u);
				
			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static class PredicateWrapper<T> implements java.util.function.Predicate<T> {
		
		public final EX.Predicate<T> delegate;

		public PredicateWrapper(Predicate<T> delegate) {
			
			this.delegate = delegate;
		}

		@Override
		public boolean test(T t) {

			try {
				
				return delegate.test(t);
				
			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static class BiPredicateWrapper<T, U> implements java.util.function.BiPredicate<T, U> {
		
		public final EX.BiPredicate<T, U> delegate;

		public BiPredicateWrapper(BiPredicate<T, U> delegate) {
			
			this.delegate = delegate;
		}

		@Override
		public boolean test(T t, U u) {

			try {
				
				return delegate.test(t, u);
				
			} catch (Exception e) {
				
				throw runtimeException(e);
			}
		}
	}
	
	public static <T> java.util.function.Supplier<T> supplier(EX.Supplier<T> delegate) {
		
		return new SupplierWrapper<>(delegate);
	}
	
	public static <T> java.util.function.Consumer<T> consumer(EX.Consumer<T> delegate) {
		
		return new ConsumerWrapper<>(delegate);
	}
	
	public static <T, U> java.util.function.BiConsumer<T, U> consumer(EX.BiConsumer<T, U> delegate) {
		
		return new BiConsumerWrapper<>(delegate);
	}
	
	public static <T, R> java.util.function.Function<T, R> function(EX.Function<T, R> delegate) {
		
		return new FunctionWrapper<>(delegate);
	}
	
	public static <T, U, R> java.util.function.BiFunction<T, U, R> function(EX.BiFunction<T, U, R> delegate) {
		
		return new BiFunctionWrapper<>(delegate);
	}
	
	public static <T> java.util.function.Predicate<T> predicate(EX.Predicate<T> delegate) {
		
		return new PredicateWrapper<>(delegate);
	}
	
	public static <T, U> java.util.function.BiPredicate<T, U> predicate(EX.BiPredicate<T, U> delegate) {
		
		return new BiPredicateWrapper<>(delegate);
	}
	
	public static RuntimeException runtimeException(Exception e) {
		
		if (e instanceof RuntimeException)
			return (RuntimeException) e;
		
		return new RuntimeException(e);
	}
}
