/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.Command;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.bukkit.BukkitCommand;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.CloudCommodoreManager;
import cloud.commandframework.internal.CommandRegistrationHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.help.GenericCommandHelpTopic;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitPluginRegistrationHandler<C>
implements CommandRegistrationHandler {
    private final Map<CommandArgument<?, ?>, org.bukkit.command.Command> registeredCommands = new HashMap();
    private final Set<String> recognizedAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, org.bukkit.command.Command> bukkitCommands;
    private BukkitCommandManager<C> bukkitCommandManager;
    private CommandMap commandMap;

    BukkitPluginRegistrationHandler() {
    }

    final void initialize(@NonNull BukkitCommandManager<C> bukkitCommandManager) throws Exception {
        Map bukkitCommands;
        Method getCommandMap = Bukkit.getServer().getClass().getDeclaredMethod("getCommandMap", new Class[0]);
        getCommandMap.setAccessible(true);
        this.commandMap = (CommandMap)getCommandMap.invoke((Object)Bukkit.getServer(), new Object[0]);
        Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
        knownCommands.setAccessible(true);
        this.bukkitCommands = bukkitCommands = (Map)knownCommands.get(this.commandMap);
        this.bukkitCommandManager = bukkitCommandManager;
        Bukkit.getHelpMap().registerHelpTopicFactory(BukkitCommand.class, GenericCommandHelpTopic::new);
    }

    public final boolean registerCommand(@NonNull Command<?> command) {
        CommandArgument commandArgument = (CommandArgument)command.getArguments().get(0);
        if (!(this.bukkitCommandManager.getCommandRegistrationHandler() instanceof CloudCommodoreManager) && this.registeredCommands.containsKey(commandArgument)) {
            return false;
        }
        String label = commandArgument.getName();
        ArrayList aliases = new ArrayList(((StaticArgument)commandArgument).getAlternativeAliases());
        BukkitCommand bukkitCommand = new BukkitCommand(label, this.bukkitCommandManager.getSplitAliases() ? Collections.emptyList() : aliases, command, commandArgument, this.bukkitCommandManager);
        this.registeredCommands.put(commandArgument, bukkitCommand);
        if (!this.bukkitCommands.containsKey(label)) {
            this.recognizedAliases.add(label);
        }
        this.recognizedAliases.add(this.getNamespacedLabel(label));
        this.commandMap.register(label, this.bukkitCommandManager.getOwningPlugin().getName().toLowerCase(), bukkitCommand);
        this.registerExternal(label, command, bukkitCommand);
        if (this.bukkitCommandManager.getSplitAliases()) {
            for (String alias : aliases) {
                if (this.bukkitCommands.containsKey(alias)) continue;
                BukkitCommand aliasCommand = new BukkitCommand(alias, Collections.emptyList(), command, commandArgument, this.bukkitCommandManager);
                if (!this.bukkitCommands.containsKey(alias)) {
                    this.recognizedAliases.add(alias);
                }
                this.recognizedAliases.add(this.getNamespacedLabel(alias));
                this.commandMap.register(alias, this.bukkitCommandManager.getOwningPlugin().getName().toLowerCase(), bukkitCommand);
                this.registerExternal(alias, command, aliasCommand);
            }
        }
        return true;
    }

    private @NonNull String getNamespacedLabel(@NonNull String label) {
        return String.format("%s:%s", this.bukkitCommandManager.getOwningPlugin().getName(), label).toLowerCase();
    }

    public boolean isRecognized(@NonNull String alias) {
        return this.recognizedAliases.contains(alias);
    }

    protected void registerExternal(@NonNull String label, @NonNull Command<?> command, @NonNull BukkitCommand<C> bukkitCommand) {
    }
}

