/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.BukkitCaptionKeys;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OfflinePlayerArgument<C>
extends CommandArgument<C, OfflinePlayer> {
    private OfflinePlayerArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new OfflinePlayerParser(), defaultValue, OfflinePlayer.class, suggestionsProvider);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, OfflinePlayer> of(@NonNull String name) {
        return OfflinePlayerArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, OfflinePlayer> optional(@NonNull String name) {
        return OfflinePlayerArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, OfflinePlayer> optional(@NonNull String name, @NonNull String defaultPlayer) {
        return OfflinePlayerArgument.newBuilder(name).asOptionalWithDefault(defaultPlayer).build();
    }

    public static final class OfflinePlayerParseException
    extends ParserException {
        private final String input;

        public OfflinePlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(OfflinePlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_OFFLINEPLAYER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }

    public static final class OfflinePlayerParser<C>
    implements ArgumentParser<C, OfflinePlayer> {
        public @NonNull ArgumentParseResult<OfflinePlayer> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NullPointerException("No input was provided"));
            }
            inputQueue.remove();
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)input);
            if (player == null || !player.hasPlayedBefore() && !player.isOnline()) {
                return ArgumentParseResult.failure((Throwable)((Object)new OfflinePlayerParseException(input, commandContext)));
            }
            return ArgumentParseResult.success((Object)player);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> output = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                output.add(player.getName());
            }
            return output;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, OfflinePlayer> {
        protected Builder(@NonNull String name) {
            super(OfflinePlayer.class, name);
        }

        public @NonNull OfflinePlayerArgument<C> build() {
            return new OfflinePlayerArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

