/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers.selector;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.CloudBukkitCapabilities;
import cloud.commandframework.bukkit.arguments.selector.SingleEntitySelector;
import cloud.commandframework.bukkit.parsers.selector.SelectorParseException;
import cloud.commandframework.context.CommandContext;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SingleEntitySelectorArgument<C>
extends CommandArgument<C, SingleEntitySelector> {
    private SingleEntitySelectorArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new SingleEntitySelectorParser(), defaultValue, SingleEntitySelector.class, suggestionsProvider);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, SingleEntitySelector> of(@NonNull String name) {
        return SingleEntitySelectorArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, SingleEntitySelector> optional(@NonNull String name) {
        return SingleEntitySelectorArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, SingleEntitySelector> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return SingleEntitySelectorArgument.newBuilder(name).asOptionalWithDefault(defaultEntitySelector).build();
    }

    public static final class SingleEntitySelectorParser<C>
    implements ArgumentParser<C, SingleEntitySelector> {
        public @NonNull ArgumentParseResult<SingleEntitySelector> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            List entities;
            if (!((Set)commandContext.get("CloudBukkitCapabilities")).contains((Object)CloudBukkitCapabilities.BRIGADIER)) {
                return ArgumentParseResult.failure((Throwable)new IllegalArgumentException("Entity selector argument type not supported below Minecraft 1.13."));
            }
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NullPointerException("No input was provided"));
            }
            inputQueue.remove();
            try {
                entities = Bukkit.selectEntities((CommandSender)((CommandSender)commandContext.get("BukkitCommandSender")), (String)input);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure((Throwable)new SelectorParseException(input));
            }
            if (entities.size() > 1) {
                return ArgumentParseResult.failure((Throwable)new IllegalArgumentException("More than 1 entity selected in single entity selector."));
            }
            return ArgumentParseResult.success((Object)new SingleEntitySelector(input, entities));
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, SingleEntitySelector> {
        protected Builder(@NonNull String name) {
            super(SingleEntitySelector.class, name);
        }

        public @NonNull SingleEntitySelectorArgument<C> build() {
            return new SingleEntitySelectorArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

