/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.brigadier.CloudBrigadierManager;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.arguments.selector.MultipleEntitySelector;
import cloud.commandframework.bukkit.arguments.selector.MultiplePlayerSelector;
import cloud.commandframework.bukkit.arguments.selector.SingleEntitySelector;
import cloud.commandframework.bukkit.arguments.selector.SinglePlayerSelector;
import com.mojang.brigadier.arguments.ArgumentType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BukkitBrigadierMapper<C> {
    private static final int UUID_ARGUMENT_VERSION = 16;
    private final BukkitCommandManager<C> commandManager;
    private final CloudBrigadierManager brigadierManager;
    private final String nmsVersion;

    public BukkitBrigadierMapper(@NonNull BukkitCommandManager<C> commandManager, @NonNull CloudBrigadierManager brigadierManager) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
        String version = Bukkit.getServer().getClass().getPackage().getName();
        this.nmsVersion = version.substring(version.lastIndexOf(".") + 1);
        int majorMinecraftVersion = Integer.parseInt(this.nmsVersion.split("_")[1]);
        try {
            if (majorMinecraftVersion >= 16) {
                this.mapSimpleNMS(UUID.class, this.getNMSArgument("UUID").getConstructor(new Class[0]));
            }
            this.mapSimpleNMS(Enchantment.class, this.getNMSArgument("Enchantment").getConstructor(new Class[0]));
            this.mapComplexNMS(SingleEntitySelector.class, this.getEntitySelectorArgument(true, false));
            this.mapComplexNMS(SinglePlayerSelector.class, this.getEntitySelectorArgument(true, true));
            this.mapComplexNMS(MultipleEntitySelector.class, this.getEntitySelectorArgument(false, false));
            this.mapComplexNMS(MultiplePlayerSelector.class, this.getEntitySelectorArgument(false, true));
            this.mapComplexNMS(Location.class, this.getArgumentVec3());
        }
        catch (Exception e) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, "Failed to map Bukkit types to NMS argument types", e);
        }
    }

    private Supplier<ArgumentType<?>> getEntitySelectorArgument(boolean single, boolean playersOnly) {
        return () -> {
            try {
                Constructor<?> constructor = this.getNMSArgument("Entity").getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                return (ArgumentType)constructor.newInstance(single, playersOnly);
            }
            catch (Exception e) {
                this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Selector Argument", e);
                return null;
            }
        };
    }

    private Supplier<ArgumentType<?>> getArgumentVec3() {
        return () -> {
            try {
                return (ArgumentType)this.getNMSArgument("Vec3").getDeclaredConstructor(Boolean.TYPE).newInstance(true);
            }
            catch (Exception e) {
                this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve vector argument", e);
                return null;
            }
        };
    }

    private @NonNull Class<?> getNMSArgument(@NonNull String argument) throws Exception {
        return Class.forName(String.format("net.minecraft.server.%s.Argument%s", this.nmsVersion, argument));
    }

    public void mapSimpleNMS(@NonNull Class<?> type, @NonNull Constructor<?> constructor) {
        try {
            this.brigadierManager.registerDefaultArgumentTypeSupplier(type, () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.commandManager.getOwningPlugin().getLogger().warning(String.format("Failed to map '%s' to a Mojang serializable argument type", type.getCanonicalName()));
        }
    }

    public void mapComplexNMS(@NonNull Class<?> type, @NonNull Supplier<ArgumentType<?>> argumentTypeSupplier) {
        try {
            this.brigadierManager.registerDefaultArgumentTypeSupplier(type, argumentTypeSupplier);
        }
        catch (Exception e) {
            this.commandManager.getOwningPlugin().getLogger().warning(String.format("Failed to map '%s' to a Mojang serializable argument type", type.getCanonicalName()));
        }
    }
}

