/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.BukkitCaptionKeys;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlayerArgument<C>
extends CommandArgument<C, Player> {
    private PlayerArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider) {
        super(required, name, new PlayerParser(), defaultValue, Player.class, suggestionsProvider);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Player> of(@NonNull String name) {
        return PlayerArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Player> optional(@NonNull String name) {
        return PlayerArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, Player> optional(@NonNull String name, @NonNull String defaultPlayer) {
        return PlayerArgument.newBuilder(name).asOptionalWithDefault(defaultPlayer).build();
    }

    public static final class PlayerParseException
    extends ParserException {
        private static final long serialVersionUID = 927476591631527552L;
        private final String input;

        public PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }

    public static final class PlayerParser<C>
    implements ArgumentParser<C, Player> {
        public @NonNull ArgumentParseResult<Player> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(PlayerParser.class, commandContext));
            }
            inputQueue.remove();
            Player player = Bukkit.getPlayer((String)input);
            if (player == null) {
                return ArgumentParseResult.failure((Throwable)((Object)new PlayerParseException(input, commandContext)));
            }
            return ArgumentParseResult.success((Object)player);
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> output = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                output.add(player.getName());
            }
            return output;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Player> {
        private Builder(@NonNull String name) {
            super(Player.class, name);
        }

        public @NonNull PlayerArgument<C> build() {
            return new PlayerArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider());
        }
    }
}

