/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.brigadier.CloudBrigadierManager;
import cloud.commandframework.bukkit.BukkitBrigadierMapper;
import cloud.commandframework.bukkit.BukkitCommand;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.BukkitPluginRegistrationHandler;
import cloud.commandframework.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.permission.CommandPermission;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collections;
import me.lucko.commodore.Commodore;
import me.lucko.commodore.CommodoreProvider;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class CloudCommodoreManager<C>
extends BukkitPluginRegistrationHandler<C> {
    private final BukkitCommandManager<C> commandManager;
    private final CloudBrigadierManager<C, Object> brigadierManager;
    private final Commodore commodore;

    CloudCommodoreManager(@NonNull BukkitCommandManager<C> commandManager) throws BukkitCommandManager.BrigadierFailureException {
        if (!CommodoreProvider.isSupported()) {
            throw new BukkitCommandManager.BrigadierFailureException(BukkitCommandManager.BrigadierFailureReason.COMMODORE_NOT_PRESENT);
        }
        this.commandManager = commandManager;
        this.commodore = CommodoreProvider.getCommodore((Plugin)commandManager.getOwningPlugin());
        this.brigadierManager = new CloudBrigadierManager(commandManager, () -> new CommandContext(commandManager.getCommandSenderMapper().apply((CommandSender)Bukkit.getConsoleSender()), (CommandManager)commandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.commandManager.getCommandSenderMapper().apply(this.commodore.getBukkitSender(sender)));
        new BukkitBrigadierMapper<C>(this.commandManager, this.brigadierManager);
        this.brigadierManager.backwardsBrigadierSenderMapper(new BukkitBackwardsBrigadierSenderMapper(this.commandManager));
    }

    @Override
    protected void registerExternal(@NonNull String label, @NonNull Command<?> command, @NonNull BukkitCommand<C> bukkitCommand) {
        this.registerWithCommodore(label, command);
    }

    protected @NonNull CloudBrigadierManager brigadierManager() {
        return this.brigadierManager;
    }

    private void registerWithCommodore(@NonNull String label, @NonNull Command<C> command) {
        LiteralCommandNode literalCommandNode = this.brigadierManager.createLiteralCommandNode(label, command, (o, p) -> {
            CommandSender sender = this.commodore.getBukkitSender(o);
            return this.commandManager.hasPermission(this.commandManager.getCommandSenderMapper().apply(sender), (CommandPermission)p);
        }, false, o -> 1);
        CommandNode existingNode = this.commodore.getDispatcher().findNode(Collections.singletonList(label));
        if (existingNode != null) {
            this.mergeChildren((CommandNode<?>)existingNode, (CommandNode<?>)literalCommandNode);
        } else {
            this.commodore.register(literalCommandNode);
        }
    }

    private void mergeChildren(@Nullable CommandNode<?> existingNode, @Nullable CommandNode<?> node) {
        for (CommandNode child : node.getChildren()) {
            CommandNode existingChild = existingNode.getChild(child.getName());
            if (existingChild == null) {
                existingNode.addChild(child);
                continue;
            }
            this.mergeChildren(existingChild, child);
        }
    }
}

