/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers.location;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.BukkitCommandContextKeys;
import cloud.commandframework.bukkit.parsers.location.Location2D;
import cloud.commandframework.bukkit.parsers.location.LocationArgument;
import cloud.commandframework.bukkit.parsers.location.LocationCoordinate;
import cloud.commandframework.bukkit.parsers.location.LocationCoordinateParser;
import cloud.commandframework.bukkit.parsers.location.LocationCoordinateType;
import cloud.commandframework.context.CommandContext;
import io.leangen.geantyref.TypeToken;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Location2DArgument<C>
extends CommandArgument<C, Location2D> {
    private Location2DArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @NonNull ArgumentDescription defaultDescription, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull Collection<@NonNull BiFunction<@NonNull CommandContext<C>, @NonNull Queue<@NonNull String>, @NonNull ArgumentParseResult<Boolean>>> argumentPreprocessors) {
        super(required, name, new Location2DParser(), defaultValue, TypeToken.get(Location2D.class), suggestionsProvider, defaultDescription, argumentPreprocessors);
    }

    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, Location2D> of(@NonNull String name) {
        return Location2DArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, Location2D> optional(@NonNull String name) {
        return Location2DArgument.newBuilder(name).asOptional().build();
    }

    public static final class Location2DParser<C>
    implements ArgumentParser<C, Location2D> {
        private static final int EXPECTED_PARAMETER_COUNT = 2;
        private final LocationCoordinateParser<C> locationCoordinateParser = new LocationCoordinateParser();

        public @NonNull ArgumentParseResult<@NonNull Location2D> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            if (inputQueue.size() < 2) {
                StringBuilder input = new StringBuilder();
                for (int i = 0; i < inputQueue.size(); ++i) {
                    input.append((String)((LinkedList)inputQueue).get(i));
                }
                return ArgumentParseResult.failure((Throwable)((Object)new LocationArgument.LocationParseException(commandContext, LocationArgument.LocationParseException.FailureReason.WRONG_FORMAT, input.toString())));
            }
            LocationCoordinate[] coordinates = new LocationCoordinate[2];
            for (int i = 0; i < 2; ++i) {
                ArgumentParseResult<@NonNull LocationCoordinate> coordinate = this.locationCoordinateParser.parse(commandContext, inputQueue);
                if (coordinate.getFailure().isPresent()) {
                    return ArgumentParseResult.failure((Throwable)((Throwable)coordinate.getFailure().get()));
                }
                coordinates[i] = (LocationCoordinate)coordinate.getParsedValue().orElseThrow(NullPointerException::new);
            }
            CommandSender bukkitSender = (CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
            Location originalLocation = bukkitSender instanceof BlockCommandSender ? ((BlockCommandSender)bukkitSender).getBlock().getLocation() : (bukkitSender instanceof Entity ? ((Entity)bukkitSender).getLocation() : new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
            if (coordinates[0].getType() == LocationCoordinateType.LOCAL && coordinates[1].getType() != LocationCoordinateType.LOCAL) {
                return ArgumentParseResult.failure((Throwable)((Object)new LocationArgument.LocationParseException(commandContext, LocationArgument.LocationParseException.FailureReason.MIXED_LOCAL_ABSOLUTE, "")));
            }
            if (coordinates[0].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setX(coordinates[0].getCoordinate());
            } else if (coordinates[0].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(coordinates[0].getCoordinate(), 0.0, 0.0);
            }
            if (coordinates[1].getType() == LocationCoordinateType.ABSOLUTE) {
                originalLocation.setZ(coordinates[1].getCoordinate());
            } else if (coordinates[1].getType() == LocationCoordinateType.RELATIVE) {
                originalLocation.add(0.0, 0.0, coordinates[1].getCoordinate());
            } else {
                Vector declaredPos = new Vector(coordinates[0].getCoordinate(), 0.0, coordinates[1].getCoordinate());
                Location local = LocationArgument.LocationParser.toLocalSpace(originalLocation, declaredPos);
                return ArgumentParseResult.success((Object)((Object)Location2D.from(originalLocation.getWorld(), local.getX(), local.getZ())));
            }
            return ArgumentParseResult.success((Object)((Object)Location2D.from(originalLocation.getWorld(), originalLocation.getX(), originalLocation.getZ())));
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return LocationArgument.LocationParser.getSuggestions(commandContext, input);
        }

        public int getRequestedArgumentCount() {
            return 2;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, Location2D> {
        private Builder(@NonNull String name) {
            super(TypeToken.get(Location2D.class), name);
        }

        public @NonNull CommandArgument<@NonNull C, @NonNull Location2D> build() {
            return new Location2DArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getDefaultDescription(), this.getSuggestionsProvider(), new LinkedList());
        }
    }
}

