/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.bukkit.BukkitCaptionKeys;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WorldArgument<C>
extends CommandArgument<C, World> {
    protected WorldArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new WorldParser(), defaultValue, World.class, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> @NonNull Builder<C> newBuilder(@NonNull String name) {
        return WorldArgument.builder(name);
    }

    public static <C> @NonNull CommandArgument<C, World> of(@NonNull String name) {
        return WorldArgument.builder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, World> optional(@NonNull String name) {
        return WorldArgument.builder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, World> optional(@NonNull String name, @NonNull String defaultValue) {
        return WorldArgument.builder(name).asOptionalWithDefault(defaultValue).build();
    }

    public static final class WorldParser<C>
    implements ArgumentParser<C, World> {
        public @NonNull ArgumentParseResult<World> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(WorldParser.class, commandContext));
            }
            World world = Bukkit.getWorld((String)input);
            if (world == null) {
                return ArgumentParseResult.failure((Throwable)((Object)new WorldParseException(input, commandContext)));
            }
            inputQueue.remove();
            return ArgumentParseResult.success((Object)world);
        }

        public @NonNull List<String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            return Bukkit.getWorlds().stream().map(World::getName).collect(Collectors.toList());
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, World> {
        private Builder(@NonNull String name) {
            super(World.class, name);
        }

        public @NonNull CommandArgument<C, World> build() {
            return new WorldArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }

    public static final class WorldParseException
    extends ParserException {
        private static final long serialVersionUID = 561648144491587450L;
        private final String input;

        public WorldParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(WorldParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_WORLD, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
            this.input = input;
        }

        public @NonNull String getInput() {
            return this.input;
        }
    }
}

