/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.cloudburst;

import cloud.commandframework.Command;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.cloudburst.CloudburstCommandManager;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.NoSuchCommandException;
import java.util.List;
import java.util.concurrent.CompletionException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.server.command.CommandSender;
import org.cloudburstmc.server.command.PluginCommand;
import org.cloudburstmc.server.command.data.CommandData;
import org.cloudburstmc.server.plugin.Plugin;

final class CloudburstCommand<C>
extends PluginCommand<Plugin> {
    private static final String MESSAGE_INTERNAL_ERROR = "An internal error occurred while attempting to perform this command.";
    private static final String MESSAGE_NO_PERMS = "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is in error.";
    private static final String MESSAGE_UNKNOWN_COMMAND = "Unknown command. Type \"/help\" for help.";
    private final CommandArgument<C, ?> command;
    private final CloudburstCommandManager<C> manager;

    CloudburstCommand(@NonNull String label, @NonNull List<@NonNull String> aliases, @NonNull Command<C> cloudCommand, @NonNull CommandArgument<C, ?> command, @NonNull CloudburstCommandManager<C> manager) {
        super(manager.getOwningPlugin(), CommandData.builder((String)label).addAliases(aliases.toArray(new String[0])).addPermission(cloudCommand.getCommandPermission().toString()).setDescription(cloudCommand.getCommandMeta().getOrDefault("description", "")).build());
        this.command = command;
        this.manager = manager;
    }

    public boolean execute(CommandSender commandSender, String commandLabel, String[] strings) {
        StringBuilder builder = new StringBuilder(this.command.getName());
        for (String string : strings) {
            builder.append(" ").append(string);
        }
        C sender = this.manager.getCommandSenderMapper().apply(commandSender);
        this.manager.executeCommand(sender, builder.toString()).whenComplete((commandResult, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                Throwable finalThrowable = throwable;
                if (throwable instanceof InvalidSyntaxException) {
                    this.manager.handleException(sender, InvalidSyntaxException.class, (Exception)((InvalidSyntaxException)throwable), (c, e) -> commandSender.sendMessage("Invalid Command Syntax. Correct command syntax is: /" + ((InvalidSyntaxException)finalThrowable).getCorrectSyntax()));
                } else if (throwable instanceof InvalidCommandSenderException) {
                    this.manager.handleException(sender, InvalidCommandSenderException.class, (Exception)((InvalidCommandSenderException)throwable), (c, e) -> commandSender.sendMessage(finalThrowable.getMessage()));
                } else if (throwable instanceof NoPermissionException) {
                    this.manager.handleException(sender, NoPermissionException.class, (Exception)((NoPermissionException)throwable), (c, e) -> commandSender.sendMessage(MESSAGE_NO_PERMS));
                } else if (throwable instanceof NoSuchCommandException) {
                    this.manager.handleException(sender, NoSuchCommandException.class, (Exception)((NoSuchCommandException)throwable), (c, e) -> commandSender.sendMessage(MESSAGE_UNKNOWN_COMMAND));
                } else if (throwable instanceof ArgumentParseException) {
                    this.manager.handleException(sender, ArgumentParseException.class, (Exception)((ArgumentParseException)throwable), (c, e) -> commandSender.sendMessage("Invalid Command Argument: " + finalThrowable.getCause().getMessage()));
                } else if (throwable instanceof CommandExecutionException) {
                    this.manager.handleException(sender, CommandExecutionException.class, (Exception)((CommandExecutionException)throwable), (c, e) -> {
                        commandSender.sendMessage(MESSAGE_INTERNAL_ERROR);
                        this.manager.getOwningPlugin().getLogger().error("Exception executing command handler", finalThrowable.getCause());
                    });
                } else {
                    commandSender.sendMessage(MESSAGE_INTERNAL_ERROR);
                    this.manager.getOwningPlugin().getLogger().error("An unhandled exception was thrown during command execution", throwable);
                }
            }
        });
        return true;
    }
}

