/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.cloudburst;

import cloud.commandframework.Command;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.cloudburst.CloudburstCommand;
import cloud.commandframework.cloudburst.CloudburstCommandManager;
import cloud.commandframework.internal.CommandRegistrationHandler;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.server.Server;
import org.cloudburstmc.server.plugin.Plugin;

class CloudburstPluginRegistrationHandler<C>
implements CommandRegistrationHandler {
    private final Map<CommandArgument<?, ?>, org.cloudburstmc.server.command.Command> registeredCommands = new HashMap();
    private CloudburstCommandManager<C> cloudburstCommandManager;

    CloudburstPluginRegistrationHandler() {
    }

    void initialize(@NonNull CloudburstCommandManager<C> cloudburstCommandManager) {
        this.cloudburstCommandManager = cloudburstCommandManager;
    }

    public final boolean registerCommand(@NonNull Command<?> command) {
        CommandArgument commandArgument = (CommandArgument)command.getArguments().get(0);
        if (this.registeredCommands.containsKey(commandArgument)) {
            return false;
        }
        Plugin plugin = this.cloudburstCommandManager.getOwningPlugin();
        CloudburstCommand cloudburstCommand = new CloudburstCommand(commandArgument.getName(), ((StaticArgument)commandArgument).getAlternativeAliases(), command, commandArgument, this.cloudburstCommandManager);
        this.registeredCommands.put((CommandArgument<?, ?>)commandArgument, (org.cloudburstmc.server.command.Command)cloudburstCommand);
        Server.getInstance().getCommandRegistry().register(plugin, cloudburstCommand);
        return true;
    }
}

