/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.cloudburst;

import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.cloudburst.CloudburstPluginRegistrationHandler;
import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.execution.CommandSuggestionProcessor;
import cloud.commandframework.execution.FilteringCommandSuggestionProcessor;
import cloud.commandframework.meta.CommandMeta;
import cloud.commandframework.meta.SimpleCommandMeta;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.server.command.CommandSender;
import org.cloudburstmc.server.event.EventPriority;
import org.cloudburstmc.server.event.Listener;
import org.cloudburstmc.server.event.server.RegistriesClosedEvent;
import org.cloudburstmc.server.plugin.Plugin;

public class CloudburstCommandManager<C>
extends CommandManager<C> {
    private final Function<CommandSender, C> commandSenderMapper;
    private final Function<C, CommandSender> backwardsCommandSenderMapper;
    private final Plugin owningPlugin;

    public CloudburstCommandManager(@NonNull Plugin owningPlugin, @NonNull Function<@NonNull CommandTree<C>, @NonNull CommandExecutionCoordinator<C>> commandExecutionCoordinator, @NonNull Function<@NonNull CommandSender, @NonNull C> commandSenderMapper, @NonNull Function<@NonNull C, @NonNull CommandSender> backwardsCommandSenderMapper) {
        super(commandExecutionCoordinator, new CloudburstPluginRegistrationHandler());
        ((CloudburstPluginRegistrationHandler)this.commandRegistrationHandler()).initialize(this);
        this.commandSenderMapper = commandSenderMapper;
        this.backwardsCommandSenderMapper = backwardsCommandSenderMapper;
        this.owningPlugin = owningPlugin;
        this.commandSuggestionProcessor((CommandSuggestionProcessor)new FilteringCommandSuggestionProcessor(FilteringCommandSuggestionProcessor.Filter.startsWith((boolean)true).andTrimBeforeLastSpace()));
        this.owningPlugin.getServer().getPluginManager().registerEvent(RegistriesClosedEvent.class, (Listener)CloudListener.INSTANCE, EventPriority.NORMAL, (listener, event) -> this.lockRegistration(), this.owningPlugin);
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.backwardsCommandSenderMapper.apply(sender).hasPermission(permission);
    }

    public final @NonNull CommandMeta createDefaultCommandMeta() {
        return SimpleCommandMeta.builder().build();
    }

    public final boolean isCommandRegistrationAllowed() {
        return this.registrationState() != CommandManager.RegistrationState.AFTER_REGISTRATION;
    }

    final @NonNull Function<@NonNull CommandSender, @NonNull C> getCommandSenderMapper() {
        return this.commandSenderMapper;
    }

    public final @NonNull Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    static final class CloudListener
    implements Listener {
        static final CloudListener INSTANCE = new CloudListener();

        private CloudListener() {
        }
    }
}

