/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.services;

import cloud.commandframework.services.PipelineException;
import cloud.commandframework.services.ServiceFilterHandler;
import cloud.commandframework.services.ServicePipeline;
import cloud.commandframework.services.ServicePump;
import cloud.commandframework.services.ServiceRepository;
import cloud.commandframework.services.State;
import cloud.commandframework.services.types.ConsumerService;
import cloud.commandframework.services.types.Service;
import cloud.commandframework.services.types.SideEffectService;
import io.leangen.geantyref.TypeToken;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ServiceSpigot<Context, Result> {
    private final Context context;
    private final ServicePipeline pipeline;
    private final ServiceRepository<Context, Result> repository;

    ServiceSpigot(@NonNull ServicePipeline pipeline, @NonNull Context context, @NonNull TypeToken<? extends Service<@NonNull Context, @NonNull Result>> type) {
        this.context = context;
        this.pipeline = pipeline;
        this.repository = pipeline.getRepository(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Result getResult() throws IllegalStateException, PipelineException {
        ServiceRepository.ServiceWrapper<Service<Context, Result>> wrapper;
        LinkedList<@NonNull @NonNull ServiceRepository. @NonNull @NonNull ServiceWrapper<Service<Context, Result>>> queue = this.repository.getQueue();
        queue.sort(null);
        boolean consumerService = false;
        while ((wrapper = queue.pollLast()) != null) {
            Result result;
            consumerService = wrapper.getImplementation() instanceof ConsumerService;
            if (!ServiceFilterHandler.INSTANCE.passes(wrapper, this.context)) continue;
            try {
                result = wrapper.getImplementation().handle(this.context);
            }
            catch (Exception e) {
                throw new PipelineException(String.format("Failed to retrieve result from %s", wrapper.toString()), e);
            }
            if (wrapper.getImplementation() instanceof SideEffectService) {
                if (result == null) {
                    throw new IllegalStateException(String.format("SideEffectService '%s' returned null", wrapper.toString()));
                }
                if (result != State.ACCEPTED) continue;
                return result;
            }
            if (result == null) continue;
            return result;
        }
        if (consumerService) {
            return (Result)((Object)State.ACCEPTED);
        }
        throw new IllegalStateException("No service consumed the context. This means that the pipeline was not constructed properly.");
    }

    public void getResult(@NonNull BiConsumer<Result, Throwable> consumer) {
        try {
            consumer.accept(this.getResult(), null);
        }
        catch (PipelineException pipelineException) {
            consumer.accept(null, pipelineException.getCause());
        }
        catch (Exception e) {
            consumer.accept(null, e);
        }
    }

    public @NonNull CompletableFuture<Result> getResultAsynchronously() {
        return CompletableFuture.supplyAsync(this::getResult, this.pipeline.getExecutor());
    }

    public @NonNull ServicePump<Result> forward() {
        return this.pipeline.pump(this.getResult());
    }

    public @NonNull CompletableFuture<ServicePump<Result>> forwardAsynchronously() {
        return this.getResultAsynchronously().thenApply(this.pipeline::pump);
    }
}

