/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.flags.types;

import cloud.commandframework.flags.AbstractFlag;
import cloud.commandframework.flags.FlagParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcloud/commandframework/flags/types/IntegerFlag;", "F", "Lcloud/commandframework/flags/AbstractFlag;", "", "number", "(I)V", "example", "", "merge", "input", "(I)Lcloud/commandframework/flags/types/IntegerFlag;", "parse", "(Ljava/lang/String;)Lcloud/commandframework/flags/types/IntegerFlag;", "serialize", "toString", "flags"})
public abstract class IntegerFlag<F extends IntegerFlag<? extends F>>
extends AbstractFlag<Integer, F> {
    @Override
    @NotNull
    public F parse(@NotNull String input) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            object = input;
            boolean bl = false;
            object = (IntegerFlag)this.flagOf(Integer.parseInt((String)object));
        }
        catch (NumberFormatException exception) {
            throw (Throwable)new FlagParseException(this, input, "Value has to be an integer");
        }
        return (F)object;
    }

    @Override
    @NotNull
    public F merge(int input) {
        return (F)((IntegerFlag)this.flagOf(((Number)this.getValue()).intValue() + input));
    }

    @Override
    @NotNull
    public String example() {
        return "10";
    }

    @Override
    @NotNull
    public String toString() {
        return String.valueOf(((Number)this.getValue()).intValue());
    }

    @Override
    @NotNull
    public String serialize() {
        return this.toString();
    }

    public IntegerFlag(int number) {
        super(number);
    }
}

