/*
 * LocalStack REST API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: latest
 * Contact: info@localstack.cloud
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package cloud.localstack.generated.api;

import cloud.localstack.generated.invoker.ApiCallback;
import cloud.localstack.generated.invoker.ApiClient;
import cloud.localstack.generated.invoker.ApiException;
import cloud.localstack.generated.invoker.ApiResponse;
import cloud.localstack.generated.invoker.Configuration;
import cloud.localstack.generated.invoker.Pair;
import cloud.localstack.generated.invoker.ProgressRequestBody;
import cloud.localstack.generated.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import cloud.localstack.generated.model.FaultRule;
import cloud.localstack.generated.model.NetworkEffectsConfig;
import java.util.Set;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChaosApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ChaosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChaosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for addFaultRules_0
     * @param faultRule  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addFaultRules_0Call(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = faultRule;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addFaultRules_0ValidateBeforeCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'faultRule' is set
        if (faultRule == null) {
            throw new ApiException("Missing the required parameter 'faultRule' when calling addFaultRules_0(Async)");
        }

        return addFaultRules_0Call(faultRule, _callback);

    }

    /**
     * Add a new set of rules to the current configuration
     * Add new rules to the existing fault configuration.
     * @param faultRule  (required)
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> addFaultRules_0(Set<FaultRule> faultRule) throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = addFaultRules_0WithHttpInfo(faultRule);
        return localVarResp.getData();
    }

    /**
     * Add a new set of rules to the current configuration
     * Add new rules to the existing fault configuration.
     * @param faultRule  (required)
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> addFaultRules_0WithHttpInfo(Set<FaultRule> faultRule) throws ApiException {
        okhttp3.Call localVarCall = addFaultRules_0ValidateBeforeCall(faultRule, null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add a new set of rules to the current configuration (asynchronously)
     * Add new rules to the existing fault configuration.
     * @param faultRule  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addFaultRules_0Async(Set<FaultRule> faultRule, final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = addFaultRules_0ValidateBeforeCall(faultRule, _callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteFaultRules_0
     * @param faultRule  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteFaultRules_0Call(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = faultRule;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteFaultRules_0ValidateBeforeCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'faultRule' is set
        if (faultRule == null) {
            throw new ApiException("Missing the required parameter 'faultRule' when calling deleteFaultRules_0(Async)");
        }

        return deleteFaultRules_0Call(faultRule, _callback);

    }

    /**
     * Delete a set of rules from the configuration
     * Remove rules from the fault configuration.
     * @param faultRule  (required)
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> deleteFaultRules_0(Set<FaultRule> faultRule) throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = deleteFaultRules_0WithHttpInfo(faultRule);
        return localVarResp.getData();
    }

    /**
     * Delete a set of rules from the configuration
     * Remove rules from the fault configuration.
     * @param faultRule  (required)
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> deleteFaultRules_0WithHttpInfo(Set<FaultRule> faultRule) throws ApiException {
        okhttp3.Call localVarCall = deleteFaultRules_0ValidateBeforeCall(faultRule, null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete a set of rules from the configuration (asynchronously)
     * Remove rules from the fault configuration.
     * @param faultRule  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteFaultRules_0Async(Set<FaultRule> faultRule, final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteFaultRules_0ValidateBeforeCall(faultRule, _callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFaultRules_0
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFaultRules_0Call(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFaultRules_0ValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getFaultRules_0Call(_callback);

    }

    /**
     * Get the current fault configuration
     * Retrieve the list of currently configured fault rules.
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> getFaultRules_0() throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = getFaultRules_0WithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get the current fault configuration
     * Retrieve the list of currently configured fault rules.
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> getFaultRules_0WithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getFaultRules_0ValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the current fault configuration (asynchronously)
     * Retrieve the list of currently configured fault rules.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFaultRules_0Async(final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFaultRules_0ValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNetworkEffects_0
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNetworkEffects_0Call(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/effects";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNetworkEffects_0ValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getNetworkEffects_0Call(_callback);

    }

    /**
     * Get current network effects configuration
     * Retrieve the current configuration for network latency effects in Localstack Chaos.
     * @return NetworkEffectsConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public NetworkEffectsConfig getNetworkEffects_0() throws ApiException {
        ApiResponse<NetworkEffectsConfig> localVarResp = getNetworkEffects_0WithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get current network effects configuration
     * Retrieve the current configuration for network latency effects in Localstack Chaos.
     * @return ApiResponse&lt;NetworkEffectsConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NetworkEffectsConfig> getNetworkEffects_0WithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getNetworkEffects_0ValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get current network effects configuration (asynchronously)
     * Retrieve the current configuration for network latency effects in Localstack Chaos.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNetworkEffects_0Async(final ApiCallback<NetworkEffectsConfig> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNetworkEffects_0ValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setFaultRules_0
     * @param faultRule  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setFaultRules_0Call(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = faultRule;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setFaultRules_0ValidateBeforeCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'faultRule' is set
        if (faultRule == null) {
            throw new ApiException("Missing the required parameter 'faultRule' when calling setFaultRules_0(Async)");
        }

        return setFaultRules_0Call(faultRule, _callback);

    }

    /**
     * Set a new fault configuration
     * Set a new set of fault rules. Overwrite the previous ones.
     * @param faultRule  (required)
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> setFaultRules_0(Set<FaultRule> faultRule) throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = setFaultRules_0WithHttpInfo(faultRule);
        return localVarResp.getData();
    }

    /**
     * Set a new fault configuration
     * Set a new set of fault rules. Overwrite the previous ones.
     * @param faultRule  (required)
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> setFaultRules_0WithHttpInfo(Set<FaultRule> faultRule) throws ApiException {
        okhttp3.Call localVarCall = setFaultRules_0ValidateBeforeCall(faultRule, null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set a new fault configuration (asynchronously)
     * Set a new set of fault rules. Overwrite the previous ones.
     * @param faultRule  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setFaultRules_0Async(Set<FaultRule> faultRule, final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = setFaultRules_0ValidateBeforeCall(faultRule, _callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setNetworkEffects_0
     * @param networkEffectsConfig  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setNetworkEffects_0Call(NetworkEffectsConfig networkEffectsConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = networkEffectsConfig;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/effects";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setNetworkEffects_0ValidateBeforeCall(NetworkEffectsConfig networkEffectsConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'networkEffectsConfig' is set
        if (networkEffectsConfig == null) {
            throw new ApiException("Missing the required parameter 'networkEffectsConfig' when calling setNetworkEffects_0(Async)");
        }

        return setNetworkEffects_0Call(networkEffectsConfig, _callback);

    }

    /**
     * Configure network effects
     * Network effects include things like latency, jitter, bandwidth throttling etc. which do not lead to an application-level fault/exception.
     * @param networkEffectsConfig  (required)
     * @return NetworkEffectsConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public NetworkEffectsConfig setNetworkEffects_0(NetworkEffectsConfig networkEffectsConfig) throws ApiException {
        ApiResponse<NetworkEffectsConfig> localVarResp = setNetworkEffects_0WithHttpInfo(networkEffectsConfig);
        return localVarResp.getData();
    }

    /**
     * Configure network effects
     * Network effects include things like latency, jitter, bandwidth throttling etc. which do not lead to an application-level fault/exception.
     * @param networkEffectsConfig  (required)
     * @return ApiResponse&lt;NetworkEffectsConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NetworkEffectsConfig> setNetworkEffects_0WithHttpInfo(NetworkEffectsConfig networkEffectsConfig) throws ApiException {
        okhttp3.Call localVarCall = setNetworkEffects_0ValidateBeforeCall(networkEffectsConfig, null);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Configure network effects (asynchronously)
     * Network effects include things like latency, jitter, bandwidth throttling etc. which do not lead to an application-level fault/exception.
     * @param networkEffectsConfig  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setNetworkEffects_0Async(NetworkEffectsConfig networkEffectsConfig, final ApiCallback<NetworkEffectsConfig> _callback) throws ApiException {

        okhttp3.Call localVarCall = setNetworkEffects_0ValidateBeforeCall(networkEffectsConfig, _callback);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
