/*
 * LocalStack REST API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: latest
 * Contact: info@localstack.cloud
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package cloud.localstack.generated.api;

import cloud.localstack.generated.invoker.ApiCallback;
import cloud.localstack.generated.invoker.ApiClient;
import cloud.localstack.generated.invoker.ApiException;
import cloud.localstack.generated.invoker.ApiResponse;
import cloud.localstack.generated.invoker.Configuration;
import cloud.localstack.generated.invoker.Pair;
import cloud.localstack.generated.invoker.ProgressRequestBody;
import cloud.localstack.generated.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import cloud.localstack.generated.model.ReceiveMessageResult;
import java.net.URI;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DefaultApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for localstackCloudformationDeployGet
     * @param templateURL URL to a CloudFormation template (JSON or YAML). (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> HTML page for CloudFormation deployment. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackCloudformationDeployGetCall(URI templateURL, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/cloudformation/deploy";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (templateURL != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("templateURL", templateURL));
        }

        final String[] localVarAccepts = {
            "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackCloudformationDeployGetValidateBeforeCall(URI templateURL, final ApiCallback _callback) throws ApiException {
        return localstackCloudformationDeployGetCall(templateURL, _callback);

    }

    /**
     * 
     * UI to deploy and manage your CloudFormation stacks using public templates
     * @param templateURL URL to a CloudFormation template (JSON or YAML). (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> HTML page for CloudFormation deployment. </td><td>  -  </td></tr>
     </table>
     */
    public String localstackCloudformationDeployGet(URI templateURL) throws ApiException {
        ApiResponse<String> localVarResp = localstackCloudformationDeployGetWithHttpInfo(templateURL);
        return localVarResp.getData();
    }

    /**
     * 
     * UI to deploy and manage your CloudFormation stacks using public templates
     * @param templateURL URL to a CloudFormation template (JSON or YAML). (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> HTML page for CloudFormation deployment. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> localstackCloudformationDeployGetWithHttpInfo(URI templateURL) throws ApiException {
        okhttp3.Call localVarCall = localstackCloudformationDeployGetValidateBeforeCall(templateURL, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * UI to deploy and manage your CloudFormation stacks using public templates
     * @param templateURL URL to a CloudFormation template (JSON or YAML). (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> HTML page for CloudFormation deployment. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackCloudformationDeployGetAsync(URI templateURL, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackCloudformationDeployGetValidateBeforeCall(templateURL, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for receiveMessage
     * @param queueUrl  (required)
     * @param attributeNames  (optional)
     * @param messageSystemAttributeNames  (optional)
     * @param messageAttributeNames  (optional)
     * @param maxNumberOfMessages  (optional)
     * @param visibilityTimeout  (optional)
     * @param waitTimeSeconds  (optional)
     * @param receiveRequestAttemptId  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> SQS queue messages </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call receiveMessageCall(URI queueUrl, List<String> attributeNames, List<String> messageSystemAttributeNames, List<String> messageAttributeNames, Integer maxNumberOfMessages, Integer visibilityTimeout, Integer waitTimeSeconds, String receiveRequestAttemptId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/sqs/messages";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (queueUrl != null) {
            localVarFormParams.put("QueueUrl", queueUrl);
        }

        if (attributeNames != null) {
            localVarFormParams.put("AttributeNames", attributeNames);
        }

        if (messageSystemAttributeNames != null) {
            localVarFormParams.put("MessageSystemAttributeNames", messageSystemAttributeNames);
        }

        if (messageAttributeNames != null) {
            localVarFormParams.put("MessageAttributeNames", messageAttributeNames);
        }

        if (maxNumberOfMessages != null) {
            localVarFormParams.put("MaxNumberOfMessages", maxNumberOfMessages);
        }

        if (visibilityTimeout != null) {
            localVarFormParams.put("VisibilityTimeout", visibilityTimeout);
        }

        if (waitTimeSeconds != null) {
            localVarFormParams.put("WaitTimeSeconds", waitTimeSeconds);
        }

        if (receiveRequestAttemptId != null) {
            localVarFormParams.put("ReceiveRequestAttemptId", receiveRequestAttemptId);
        }

        final String[] localVarAccepts = {
            "text/xml",
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/x-www-form-urlencoded",
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call receiveMessageValidateBeforeCall(URI queueUrl, List<String> attributeNames, List<String> messageSystemAttributeNames, List<String> messageAttributeNames, Integer maxNumberOfMessages, Integer visibilityTimeout, Integer waitTimeSeconds, String receiveRequestAttemptId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'queueUrl' is set
        if (queueUrl == null) {
            throw new ApiException("Missing the required parameter 'queueUrl' when calling receiveMessage(Async)");
        }

        return receiveMessageCall(queueUrl, attributeNames, messageSystemAttributeNames, messageAttributeNames, maxNumberOfMessages, visibilityTimeout, waitTimeSeconds, receiveRequestAttemptId, _callback);

    }

    /**
     * Retrieves one or more messages from the specified queue.
     * This API receives messages from an SQS queue. https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ReceiveMessage.html#API_ReceiveMessage_ResponseSyntax 
     * @param queueUrl  (required)
     * @param attributeNames  (optional)
     * @param messageSystemAttributeNames  (optional)
     * @param messageAttributeNames  (optional)
     * @param maxNumberOfMessages  (optional)
     * @param visibilityTimeout  (optional)
     * @param waitTimeSeconds  (optional)
     * @param receiveRequestAttemptId  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> SQS queue messages </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    public void receiveMessage(URI queueUrl, List<String> attributeNames, List<String> messageSystemAttributeNames, List<String> messageAttributeNames, Integer maxNumberOfMessages, Integer visibilityTimeout, Integer waitTimeSeconds, String receiveRequestAttemptId) throws ApiException {
        receiveMessageWithHttpInfo(queueUrl, attributeNames, messageSystemAttributeNames, messageAttributeNames, maxNumberOfMessages, visibilityTimeout, waitTimeSeconds, receiveRequestAttemptId);
    }

    /**
     * Retrieves one or more messages from the specified queue.
     * This API receives messages from an SQS queue. https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ReceiveMessage.html#API_ReceiveMessage_ResponseSyntax 
     * @param queueUrl  (required)
     * @param attributeNames  (optional)
     * @param messageSystemAttributeNames  (optional)
     * @param messageAttributeNames  (optional)
     * @param maxNumberOfMessages  (optional)
     * @param visibilityTimeout  (optional)
     * @param waitTimeSeconds  (optional)
     * @param receiveRequestAttemptId  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> SQS queue messages </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> receiveMessageWithHttpInfo(URI queueUrl, List<String> attributeNames, List<String> messageSystemAttributeNames, List<String> messageAttributeNames, Integer maxNumberOfMessages, Integer visibilityTimeout, Integer waitTimeSeconds, String receiveRequestAttemptId) throws ApiException {
        okhttp3.Call localVarCall = receiveMessageValidateBeforeCall(queueUrl, attributeNames, messageSystemAttributeNames, messageAttributeNames, maxNumberOfMessages, visibilityTimeout, waitTimeSeconds, receiveRequestAttemptId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Retrieves one or more messages from the specified queue. (asynchronously)
     * This API receives messages from an SQS queue. https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_ReceiveMessage.html#API_ReceiveMessage_ResponseSyntax 
     * @param queueUrl  (required)
     * @param attributeNames  (optional)
     * @param messageSystemAttributeNames  (optional)
     * @param messageAttributeNames  (optional)
     * @param maxNumberOfMessages  (optional)
     * @param visibilityTimeout  (optional)
     * @param waitTimeSeconds  (optional)
     * @param receiveRequestAttemptId  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> SQS queue messages </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call receiveMessageAsync(URI queueUrl, List<String> attributeNames, List<String> messageSystemAttributeNames, List<String> messageAttributeNames, Integer maxNumberOfMessages, Integer visibilityTimeout, Integer waitTimeSeconds, String receiveRequestAttemptId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = receiveMessageValidateBeforeCall(queueUrl, attributeNames, messageSystemAttributeNames, messageAttributeNames, maxNumberOfMessages, visibilityTimeout, waitTimeSeconds, receiveRequestAttemptId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
