/*
 * LocalStack REST API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: latest
 * Contact: info@localstack.cloud
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package cloud.localstack.generated.api;

import cloud.localstack.generated.invoker.ApiCallback;
import cloud.localstack.generated.invoker.ApiClient;
import cloud.localstack.generated.invoker.ApiException;
import cloud.localstack.generated.invoker.ApiResponse;
import cloud.localstack.generated.invoker.Configuration;
import cloud.localstack.generated.invoker.Pair;
import cloud.localstack.generated.invoker.ProgressRequestBody;
import cloud.localstack.generated.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import cloud.localstack.generated.model.CreateRemoteRequest;
import java.io.File;
import cloud.localstack.generated.model.ListRemotes200Response;
import cloud.localstack.generated.model.LocalstackPodsEnvironmentGet200Response;
import cloud.localstack.generated.model.PodList;
import cloud.localstack.generated.model.PodRemote;
import cloud.localstack.generated.model.PodSaveRequest;
import cloud.localstack.generated.model.PodVersions;
import cloud.localstack.generated.model.RemoteConfig;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PodsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PodsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createRemote_0
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createRemote_0Call(String name, CreateRemoteRequest createRemoteRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createRemoteRequest;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createRemote_0ValidateBeforeCall(String name, CreateRemoteRequest createRemoteRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createRemote_0(Async)");
        }

        // verify the required parameter 'createRemoteRequest' is set
        if (createRemoteRequest == null) {
            throw new ApiException("Missing the required parameter 'createRemoteRequest' when calling createRemote_0(Async)");
        }

        return createRemote_0Call(name, createRemoteRequest, _callback);

    }

    /**
     * Create a new remote
     * Creates a new remote with the specified name and configuration.
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public void createRemote_0(String name, CreateRemoteRequest createRemoteRequest) throws ApiException {
        createRemote_0WithHttpInfo(name, createRemoteRequest);
    }

    /**
     * Create a new remote
     * Creates a new remote with the specified name and configuration.
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createRemote_0WithHttpInfo(String name, CreateRemoteRequest createRemoteRequest) throws ApiException {
        okhttp3.Call localVarCall = createRemote_0ValidateBeforeCall(name, createRemoteRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create a new remote (asynchronously)
     * Creates a new remote with the specified name and configuration.
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createRemote_0Async(String name, CreateRemoteRequest createRemoteRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createRemote_0ValidateBeforeCall(name, createRemoteRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deletePod_0
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deletePod_0Call(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (local != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("local", local));
        }

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deletePod_0ValidateBeforeCall(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePod_0(Async)");
        }

        return deletePod_0Call(name, local, xLocalstackStateSecret, remoteConfig, _callback);

    }

    /**
     * 
     * 
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public void deletePod_0(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        deletePod_0WithHttpInfo(name, local, xLocalstackStateSecret, remoteConfig);
    }

    /**
     * 
     * 
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deletePod_0WithHttpInfo(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = deletePod_0ValidateBeforeCall(name, local, xLocalstackStateSecret, remoteConfig, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * 
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deletePod_0Async(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deletePod_0ValidateBeforeCall(name, local, xLocalstackStateSecret, remoteConfig, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteRemote_0
     * @param name The name of the remote to delete. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteRemote_0Call(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteRemote_0ValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteRemote_0(Async)");
        }

        return deleteRemote_0Call(name, _callback);

    }

    /**
     * Delete a remote
     * Deletes a remote with the specified name.
     * @param name The name of the remote to delete. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteRemote_0(String name) throws ApiException {
        deleteRemote_0WithHttpInfo(name);
    }

    /**
     * Delete a remote
     * Deletes a remote with the specified name.
     * @param name The name of the remote to delete. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteRemote_0WithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = deleteRemote_0ValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete a remote (asynchronously)
     * Deletes a remote with the specified name.
     * @param name The name of the remote to delete. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteRemote_0Async(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteRemote_0ValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPodVersions_0
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPodVersions_0Call(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}/versions"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPodVersions_0ValidateBeforeCall(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPodVersions_0(Async)");
        }

        return getPodVersions_0Call(name, xLocalstackStateSecret, remoteConfig, _callback);

    }

    /**
     * 
     * List versions for a cloud pod
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return PodVersions
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public PodVersions getPodVersions_0(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        ApiResponse<PodVersions> localVarResp = getPodVersions_0WithHttpInfo(name, xLocalstackStateSecret, remoteConfig);
        return localVarResp.getData();
    }

    /**
     * 
     * List versions for a cloud pod
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;PodVersions&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PodVersions> getPodVersions_0WithHttpInfo(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = getPodVersions_0ValidateBeforeCall(name, xLocalstackStateSecret, remoteConfig, null);
        Type localVarReturnType = new TypeToken<PodVersions>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * List versions for a cloud pod
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPodVersions_0Async(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback<PodVersions> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPodVersions_0ValidateBeforeCall(name, xLocalstackStateSecret, remoteConfig, _callback);
        Type localVarReturnType = new TypeToken<PodVersions>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRemote_0
     * @param name The name of the remote. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRemote_0Call(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRemote_0ValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getRemote_0(Async)");
        }

        return getRemote_0Call(name, _callback);

    }

    /**
     * Get a specific remote
     * Retrieves information about a specific remote by name.
     * @param name The name of the remote. (required)
     * @return PodRemote
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public PodRemote getRemote_0(String name) throws ApiException {
        ApiResponse<PodRemote> localVarResp = getRemote_0WithHttpInfo(name);
        return localVarResp.getData();
    }

    /**
     * Get a specific remote
     * Retrieves information about a specific remote by name.
     * @param name The name of the remote. (required)
     * @return ApiResponse&lt;PodRemote&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PodRemote> getRemote_0WithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = getRemote_0ValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodRemote>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a specific remote (asynchronously)
     * Retrieves information about a specific remote by name.
     * @param name The name of the remote. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRemote_0Async(String name, final ApiCallback<PodRemote> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRemote_0ValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodRemote>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listPods_0
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPods_0Call(String creator, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (creator != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creator", creator));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPods_0ValidateBeforeCall(String creator, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        return listPods_0Call(creator, remoteConfig, _callback);

    }

    /**
     * 
     * List cloud pods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @return PodList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public PodList listPods_0(String creator, RemoteConfig remoteConfig) throws ApiException {
        ApiResponse<PodList> localVarResp = listPods_0WithHttpInfo(creator, remoteConfig);
        return localVarResp.getData();
    }

    /**
     * 
     * List cloud pods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;PodList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PodList> listPods_0WithHttpInfo(String creator, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = listPods_0ValidateBeforeCall(creator, remoteConfig, null);
        Type localVarReturnType = new TypeToken<PodList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * List cloud pods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPods_0Async(String creator, RemoteConfig remoteConfig, final ApiCallback<PodList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listPods_0ValidateBeforeCall(creator, remoteConfig, _callback);
        Type localVarReturnType = new TypeToken<PodList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listRemotes_0
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRemotes_0Call(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listRemotes_0ValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return listRemotes_0Call(_callback);

    }

    /**
     * 
     * Retrieves a list of all configured remotes.
     * @return ListRemotes200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public ListRemotes200Response listRemotes_0() throws ApiException {
        ApiResponse<ListRemotes200Response> localVarResp = listRemotes_0WithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Retrieves a list of all configured remotes.
     * @return ApiResponse&lt;ListRemotes200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListRemotes200Response> listRemotes_0WithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listRemotes_0ValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListRemotes200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Retrieves a list of all configured remotes.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRemotes_0Async(final ApiCallback<ListRemotes200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = listRemotes_0ValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListRemotes200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for loadPod_0
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call loadPod_0Call(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (merge != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("merge", merge));
        }

        if (ignoreVersionMismatches != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignore_version_mismatches", ignoreVersionMismatches));
        }

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
            "application/x-ndjson"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call loadPod_0ValidateBeforeCall(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling loadPod_0(Async)");
        }

        return loadPod_0Call(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig, _callback);

    }

    /**
     * 
     * Load a cloud pod version
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public void loadPod_0(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        loadPod_0WithHttpInfo(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig);
    }

    /**
     * 
     * Load a cloud pod version
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> loadPod_0WithHttpInfo(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = loadPod_0ValidateBeforeCall(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Load a cloud pod version
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call loadPod_0Async(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = loadPod_0ValidateBeforeCall(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsEnvironmentGet_0
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsEnvironmentGet_0Call(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/environment";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsEnvironmentGet_0ValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackPodsEnvironmentGet_0Call(_callback);

    }

    /**
     * 
     * Retrieves some information about the current environment, like LocalStack and Moto versions. 
     * @return LocalstackPodsEnvironmentGet200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public LocalstackPodsEnvironmentGet200Response localstackPodsEnvironmentGet_0() throws ApiException {
        ApiResponse<LocalstackPodsEnvironmentGet200Response> localVarResp = localstackPodsEnvironmentGet_0WithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Retrieves some information about the current environment, like LocalStack and Moto versions. 
     * @return ApiResponse&lt;LocalstackPodsEnvironmentGet200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LocalstackPodsEnvironmentGet200Response> localstackPodsEnvironmentGet_0WithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackPodsEnvironmentGet_0ValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<LocalstackPodsEnvironmentGet200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Retrieves some information about the current environment, like LocalStack and Moto versions. 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsEnvironmentGet_0Async(final ApiCallback<LocalstackPodsEnvironmentGet200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsEnvironmentGet_0ValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<LocalstackPodsEnvironmentGet200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsStateGet_0
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateGet_0Call(String podName, String services, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/state";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (podName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pod_name", podName));
        }

        if (services != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("services", services));
        }

        final String[] localVarAccepts = {
            "application/zip"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsStateGet_0ValidateBeforeCall(String podName, String services, final ApiCallback _callback) throws ApiException {
        return localstackPodsStateGet_0Call(podName, services, _callback);

    }

    /**
     * 
     * Exports the current state of the LocalStack container into a zip file.
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public File localstackPodsStateGet_0(String podName, String services) throws ApiException {
        ApiResponse<File> localVarResp = localstackPodsStateGet_0WithHttpInfo(podName, services);
        return localVarResp.getData();
    }

    /**
     * 
     * Exports the current state of the LocalStack container into a zip file.
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public ApiResponse<File> localstackPodsStateGet_0WithHttpInfo(String podName, String services) throws ApiException {
        okhttp3.Call localVarCall = localstackPodsStateGet_0ValidateBeforeCall(podName, services, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Exports the current state of the LocalStack container into a zip file.
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateGet_0Async(String podName, String services, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsStateGet_0ValidateBeforeCall(podName, services, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsStateMetamodelGet_0
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateMetamodelGet_0Call(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/state/metamodel";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsStateMetamodelGet_0ValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackPodsStateMetamodelGet_0Call(_callback);

    }

    /**
     * 
     * Extract a metamodel representing the state of the current LocalStack session
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public void localstackPodsStateMetamodelGet_0() throws ApiException {
        localstackPodsStateMetamodelGet_0WithHttpInfo();
    }

    /**
     * 
     * Extract a metamodel representing the state of the current LocalStack session
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackPodsStateMetamodelGet_0WithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackPodsStateMetamodelGet_0ValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Extract a metamodel representing the state of the current LocalStack session
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateMetamodelGet_0Async(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsStateMetamodelGet_0ValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsStatePost_0
     * @param pod  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStatePost_0Call(File pod, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/state";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (pod != null) {
            localVarFormParams.put("pod", pod);
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data",
            "application/octet-stream"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsStatePost_0ValidateBeforeCall(File pod, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'pod' is set
        if (pod == null) {
            throw new ApiException("Missing the required parameter 'pod' when calling localstackPodsStatePost_0(Async)");
        }

        return localstackPodsStatePost_0Call(pod, _callback);

    }

    /**
     * 
     * Loads a pod state from a zip file and restores its services.
     * @param pod  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public void localstackPodsStatePost_0(File pod) throws ApiException {
        localstackPodsStatePost_0WithHttpInfo(pod);
    }

    /**
     * 
     * Loads a pod state from a zip file and restores its services.
     * @param pod  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackPodsStatePost_0WithHttpInfo(File pod) throws ApiException {
        okhttp3.Call localVarCall = localstackPodsStatePost_0ValidateBeforeCall(pod, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Loads a pod state from a zip file and restores its services.
     * @param pod  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStatePost_0Async(File pod, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsStatePost_0ValidateBeforeCall(pod, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for savePod_0
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call savePod_0Call(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = podSaveRequest;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (local != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("local", local));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
            "application/x-ndjson"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call savePod_0ValidateBeforeCall(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling savePod_0(Async)");
        }

        return savePod_0Call(name, local, version, xLocalstackStateSecret, podSaveRequest, _callback);

    }

    /**
     * 
     * Create and register a cloud pod version
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public void savePod_0(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest) throws ApiException {
        savePod_0WithHttpInfo(name, local, version, xLocalstackStateSecret, podSaveRequest);
    }

    /**
     * 
     * Create and register a cloud pod version
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> savePod_0WithHttpInfo(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest) throws ApiException {
        okhttp3.Call localVarCall = savePod_0ValidateBeforeCall(name, local, version, xLocalstackStateSecret, podSaveRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Create and register a cloud pod version
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call savePod_0Async(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = savePod_0ValidateBeforeCall(name, local, version, xLocalstackStateSecret, podSaveRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
