/*
 * LocalStack REST API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: latest
 * Contact: info@localstack.cloud
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package cloud.localstack.generated.api;

import cloud.localstack.generated.invoker.ApiCallback;
import cloud.localstack.generated.invoker.ApiClient;
import cloud.localstack.generated.invoker.ApiException;
import cloud.localstack.generated.invoker.ApiResponse;
import cloud.localstack.generated.invoker.Configuration;
import cloud.localstack.generated.invoker.Pair;
import cloud.localstack.generated.invoker.ProgressRequestBody;
import cloud.localstack.generated.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import cloud.localstack.generated.model.AwsPinpointApplicationIdReferenceIdGet200Response;
import cloud.localstack.generated.model.CreateRemoteRequest;
import cloud.localstack.generated.model.FaultRule;
import java.io.File;
import cloud.localstack.generated.model.ListRemotes200Response;
import cloud.localstack.generated.model.LocalstackPodsEnvironmentGet200Response;
import cloud.localstack.generated.model.LocalstackStackinfoGet200Response;
import cloud.localstack.generated.model.NetworkEffectsConfig;
import cloud.localstack.generated.model.PodList;
import cloud.localstack.generated.model.PodRemote;
import cloud.localstack.generated.model.PodSaveRequest;
import cloud.localstack.generated.model.PodVersions;
import cloud.localstack.generated.model.RemoteConfig;
import java.util.Set;
import cloud.localstack.generated.model.StateResult;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for addFaultRules
     * @param faultRule  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addFaultRulesCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = faultRule;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call addFaultRulesValidateBeforeCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'faultRule' is set
        if (faultRule == null) {
            throw new ApiException("Missing the required parameter 'faultRule' when calling addFaultRules(Async)");
        }

        return addFaultRulesCall(faultRule, _callback);

    }

    /**
     * Add a new set of rules to the current configuration
     * Add new rules to the existing fault configuration.
     * @param faultRule  (required)
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> addFaultRules(Set<FaultRule> faultRule) throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = addFaultRulesWithHttpInfo(faultRule);
        return localVarResp.getData();
    }

    /**
     * Add a new set of rules to the current configuration
     * Add new rules to the existing fault configuration.
     * @param faultRule  (required)
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> addFaultRulesWithHttpInfo(Set<FaultRule> faultRule) throws ApiException {
        okhttp3.Call localVarCall = addFaultRulesValidateBeforeCall(faultRule, null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add a new set of rules to the current configuration (asynchronously)
     * Add new rules to the existing fault configuration.
     * @param faultRule  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call addFaultRulesAsync(Set<FaultRule> faultRule, final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = addFaultRulesValidateBeforeCall(faultRule, _callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpForgotPasswordGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpForgotPasswordGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/forgotPassword";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpForgotPasswordGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpForgotPasswordGetCall(_callback);

    }

    /**
     * 
     * Cognito forgot password endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpForgotPasswordGet() throws ApiException {
        awsCognitoIdpForgotPasswordGetWithHttpInfo();
    }

    /**
     * 
     * Cognito forgot password endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpForgotPasswordGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpForgotPasswordGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito forgot password endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpForgotPasswordGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpForgotPasswordGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpForgotPasswordPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpForgotPasswordPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/forgotPassword";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpForgotPasswordPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpForgotPasswordPostCall(_callback);

    }

    /**
     * 
     * Cognito forgot password endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpForgotPasswordPost() throws ApiException {
        awsCognitoIdpForgotPasswordPostWithHttpInfo();
    }

    /**
     * 
     * Cognito forgot password endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpForgotPasswordPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpForgotPasswordPostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito forgot password endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpForgotPasswordPostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpForgotPasswordPostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpLoginGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLoginGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/login";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpLoginGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpLoginGetCall(_callback);

    }

    /**
     * 
     * Cognito login endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpLoginGet() throws ApiException {
        awsCognitoIdpLoginGetWithHttpInfo();
    }

    /**
     * 
     * Cognito login endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpLoginGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpLoginGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito login endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLoginGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpLoginGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpLoginPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLoginPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/login";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpLoginPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpLoginPostCall(_callback);

    }

    /**
     * 
     * Cognito login endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpLoginPost() throws ApiException {
        awsCognitoIdpLoginPostWithHttpInfo();
    }

    /**
     * 
     * Cognito login endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpLoginPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpLoginPostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito login endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLoginPostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpLoginPostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpLogoutGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLogoutGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/logout";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpLogoutGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpLogoutGetCall(_callback);

    }

    /**
     * 
     * Cognito logout endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpLogoutGet() throws ApiException {
        awsCognitoIdpLogoutGetWithHttpInfo();
    }

    /**
     * 
     * Cognito logout endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpLogoutGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpLogoutGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito logout endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLogoutGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpLogoutGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpLogoutPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLogoutPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/logout";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpLogoutPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpLogoutPostCall(_callback);

    }

    /**
     * 
     * Cognito logout endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpLogoutPost() throws ApiException {
        awsCognitoIdpLogoutPostWithHttpInfo();
    }

    /**
     * 
     * Cognito logout endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpLogoutPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpLogoutPostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito logout endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpLogoutPostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpLogoutPostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpOauth2AuthorizeGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authorization-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2AuthorizeGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/oauth2/authorize";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpOauth2AuthorizeGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpOauth2AuthorizeGetCall(_callback);

    }

    /**
     * 
     * Cognito OAuth 2.0 authorization endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authorization-endpoint.html"> Documentation</a>
     */
    public void awsCognitoIdpOauth2AuthorizeGet() throws ApiException {
        awsCognitoIdpOauth2AuthorizeGetWithHttpInfo();
    }

    /**
     * 
     * Cognito OAuth 2.0 authorization endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authorization-endpoint.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpOauth2AuthorizeGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpOauth2AuthorizeGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito OAuth 2.0 authorization endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/authorization-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2AuthorizeGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpOauth2AuthorizeGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpOauth2RevokePost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/revocation-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2RevokePostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/oauth2/revoke";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpOauth2RevokePostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpOauth2RevokePostCall(_callback);

    }

    /**
     * 
     * Cognito OAuth 2.0 token revocation endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/revocation-endpoint.html"> Documentation</a>
     */
    public void awsCognitoIdpOauth2RevokePost() throws ApiException {
        awsCognitoIdpOauth2RevokePostWithHttpInfo();
    }

    /**
     * 
     * Cognito OAuth 2.0 token revocation endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/revocation-endpoint.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpOauth2RevokePostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpOauth2RevokePostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito OAuth 2.0 token revocation endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/revocation-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2RevokePostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpOauth2RevokePostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpOauth2TokenPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2TokenPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/oauth2/token";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpOauth2TokenPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpOauth2TokenPostCall(_callback);

    }

    /**
     * 
     * Cognito OAuth 2.0 token endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-endpoint.html"> Documentation</a>
     */
    public void awsCognitoIdpOauth2TokenPost() throws ApiException {
        awsCognitoIdpOauth2TokenPostWithHttpInfo();
    }

    /**
     * 
     * Cognito OAuth 2.0 token endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-endpoint.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpOauth2TokenPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpOauth2TokenPostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito OAuth 2.0 token endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/token-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2TokenPostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpOauth2TokenPostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpOauth2UserInfoGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/userinfo-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2UserInfoGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/oauth2/userInfo";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpOauth2UserInfoGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpOauth2UserInfoGetCall(_callback);

    }

    /**
     * 
     * Cognito OpenID Connect userInfo endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/userinfo-endpoint.html"> Documentation</a>
     */
    public void awsCognitoIdpOauth2UserInfoGet() throws ApiException {
        awsCognitoIdpOauth2UserInfoGetWithHttpInfo();
    }

    /**
     * 
     * Cognito OpenID Connect userInfo endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/userinfo-endpoint.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpOauth2UserInfoGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpOauth2UserInfoGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito OpenID Connect userInfo endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/userinfo-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpOauth2UserInfoGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpOauth2UserInfoGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpSaml2IdpresponseGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSaml2IdpresponseGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/saml2/idpresponse";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpSaml2IdpresponseGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpSaml2IdpresponseGetCall(_callback);

    }

    /**
     * 
     * Cognito SAML 2.0 idpresponse endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public void awsCognitoIdpSaml2IdpresponseGet() throws ApiException {
        awsCognitoIdpSaml2IdpresponseGetWithHttpInfo();
    }

    /**
     * 
     * Cognito SAML 2.0 idpresponse endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpSaml2IdpresponseGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpSaml2IdpresponseGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito SAML 2.0 idpresponse endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSaml2IdpresponseGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpSaml2IdpresponseGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpSaml2IdpresponsePost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSaml2IdpresponsePostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/saml2/idpresponse";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpSaml2IdpresponsePostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpSaml2IdpresponsePostCall(_callback);

    }

    /**
     * 
     * Cognito SAML 2.0 idpresponse endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public void awsCognitoIdpSaml2IdpresponsePost() throws ApiException {
        awsCognitoIdpSaml2IdpresponsePostWithHttpInfo();
    }

    /**
     * 
     * Cognito SAML 2.0 idpresponse endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpSaml2IdpresponsePostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpSaml2IdpresponsePostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito SAML 2.0 idpresponse endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/saml2-idpresponse-endpoint.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSaml2IdpresponsePostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpSaml2IdpresponsePostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpSignupGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSignupGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/signup";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpSignupGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpSignupGetCall(_callback);

    }

    /**
     * 
     * Cognito signup endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpSignupGet() throws ApiException {
        awsCognitoIdpSignupGetWithHttpInfo();
    }

    /**
     * 
     * Cognito signup endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpSignupGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpSignupGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito signup endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSignupGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpSignupGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsCognitoIdpSignupPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSignupPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/cognito-idp/signup";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsCognitoIdpSignupPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsCognitoIdpSignupPostCall(_callback);

    }

    /**
     * 
     * Cognito signup endpoint
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public void awsCognitoIdpSignupPost() throws ApiException {
        awsCognitoIdpSignupPostWithHttpInfo();
    }

    /**
     * 
     * Cognito signup endpoint
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public ApiResponse<Void> awsCognitoIdpSignupPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsCognitoIdpSignupPostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cognito signup endpoint
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * 
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/hosted-UI-endpoints.html"> Documentation</a>
     */
    public okhttp3.Call awsCognitoIdpSignupPostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsCognitoIdpSignupPostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsIotLocalStackIoTRootCAPemGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call awsIotLocalStackIoTRootCAPemGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/iot/LocalStackIoTRootCA.pem";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsIotLocalStackIoTRootCAPemGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return awsIotLocalStackIoTRootCAPemGetCall(_callback);

    }

    /**
     * 
     * Retrieve certificate for LocalStack IoT root certificate authority
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void awsIotLocalStackIoTRootCAPemGet() throws ApiException {
        awsIotLocalStackIoTRootCAPemGetWithHttpInfo();
    }

    /**
     * 
     * Retrieve certificate for LocalStack IoT root certificate authority
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> awsIotLocalStackIoTRootCAPemGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = awsIotLocalStackIoTRootCAPemGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Retrieve certificate for LocalStack IoT root certificate authority
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call awsIotLocalStackIoTRootCAPemGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsIotLocalStackIoTRootCAPemGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for awsPinpointApplicationIdReferenceIdGet
     * @param applicationId Pinpoint application ID (required)
     * @param referenceId Reference ID that was used in SentOTPMessage (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OTP message details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call awsPinpointApplicationIdReferenceIdGetCall(String applicationId, String referenceId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_aws/pinpoint/{application_id}/{reference_id}"
            .replace("{" + "application_id" + "}", localVarApiClient.escapeString(applicationId.toString()))
            .replace("{" + "reference_id" + "}", localVarApiClient.escapeString(referenceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call awsPinpointApplicationIdReferenceIdGetValidateBeforeCall(String applicationId, String referenceId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'applicationId' is set
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling awsPinpointApplicationIdReferenceIdGet(Async)");
        }

        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling awsPinpointApplicationIdReferenceIdGet(Async)");
        }

        return awsPinpointApplicationIdReferenceIdGetCall(applicationId, referenceId, _callback);

    }

    /**
     * 
     * Retrieve Pinpoint OTP code
     * @param applicationId Pinpoint application ID (required)
     * @param referenceId Reference ID that was used in SentOTPMessage (required)
     * @return AwsPinpointApplicationIdReferenceIdGet200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OTP message details </td><td>  -  </td></tr>
     </table>
     */
    public AwsPinpointApplicationIdReferenceIdGet200Response awsPinpointApplicationIdReferenceIdGet(String applicationId, String referenceId) throws ApiException {
        ApiResponse<AwsPinpointApplicationIdReferenceIdGet200Response> localVarResp = awsPinpointApplicationIdReferenceIdGetWithHttpInfo(applicationId, referenceId);
        return localVarResp.getData();
    }

    /**
     * 
     * Retrieve Pinpoint OTP code
     * @param applicationId Pinpoint application ID (required)
     * @param referenceId Reference ID that was used in SentOTPMessage (required)
     * @return ApiResponse&lt;AwsPinpointApplicationIdReferenceIdGet200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OTP message details </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AwsPinpointApplicationIdReferenceIdGet200Response> awsPinpointApplicationIdReferenceIdGetWithHttpInfo(String applicationId, String referenceId) throws ApiException {
        okhttp3.Call localVarCall = awsPinpointApplicationIdReferenceIdGetValidateBeforeCall(applicationId, referenceId, null);
        Type localVarReturnType = new TypeToken<AwsPinpointApplicationIdReferenceIdGet200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Retrieve Pinpoint OTP code
     * @param applicationId Pinpoint application ID (required)
     * @param referenceId Reference ID that was used in SentOTPMessage (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OTP message details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call awsPinpointApplicationIdReferenceIdGetAsync(String applicationId, String referenceId, final ApiCallback<AwsPinpointApplicationIdReferenceIdGet200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = awsPinpointApplicationIdReferenceIdGetValidateBeforeCall(applicationId, referenceId, _callback);
        Type localVarReturnType = new TypeToken<AwsPinpointApplicationIdReferenceIdGet200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createRemote
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createRemoteCall(String name, CreateRemoteRequest createRemoteRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createRemoteRequest;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createRemoteValidateBeforeCall(String name, CreateRemoteRequest createRemoteRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createRemote(Async)");
        }

        // verify the required parameter 'createRemoteRequest' is set
        if (createRemoteRequest == null) {
            throw new ApiException("Missing the required parameter 'createRemoteRequest' when calling createRemote(Async)");
        }

        return createRemoteCall(name, createRemoteRequest, _callback);

    }

    /**
     * Create a new remote
     * Creates a new remote with the specified name and configuration.
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public void createRemote(String name, CreateRemoteRequest createRemoteRequest) throws ApiException {
        createRemoteWithHttpInfo(name, createRemoteRequest);
    }

    /**
     * Create a new remote
     * Creates a new remote with the specified name and configuration.
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createRemoteWithHttpInfo(String name, CreateRemoteRequest createRemoteRequest) throws ApiException {
        okhttp3.Call localVarCall = createRemoteValidateBeforeCall(name, createRemoteRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Create a new remote (asynchronously)
     * Creates a new remote with the specified name and configuration.
     * @param name The name of the new remote. (required)
     * @param createRemoteRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote created successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createRemoteAsync(String name, CreateRemoteRequest createRemoteRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createRemoteValidateBeforeCall(name, createRemoteRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteFaultRules
     * @param faultRule  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteFaultRulesCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = faultRule;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteFaultRulesValidateBeforeCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'faultRule' is set
        if (faultRule == null) {
            throw new ApiException("Missing the required parameter 'faultRule' when calling deleteFaultRules(Async)");
        }

        return deleteFaultRulesCall(faultRule, _callback);

    }

    /**
     * Delete a set of rules from the configuration
     * Remove rules from the fault configuration.
     * @param faultRule  (required)
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> deleteFaultRules(Set<FaultRule> faultRule) throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = deleteFaultRulesWithHttpInfo(faultRule);
        return localVarResp.getData();
    }

    /**
     * Delete a set of rules from the configuration
     * Remove rules from the fault configuration.
     * @param faultRule  (required)
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> deleteFaultRulesWithHttpInfo(Set<FaultRule> faultRule) throws ApiException {
        okhttp3.Call localVarCall = deleteFaultRulesValidateBeforeCall(faultRule, null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete a set of rules from the configuration (asynchronously)
     * Remove rules from the fault configuration.
     * @param faultRule  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteFaultRulesAsync(Set<FaultRule> faultRule, final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteFaultRulesValidateBeforeCall(faultRule, _callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deletePod
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deletePodCall(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (local != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("local", local));
        }

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deletePodValidateBeforeCall(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deletePod(Async)");
        }

        return deletePodCall(name, local, xLocalstackStateSecret, remoteConfig, _callback);

    }

    /**
     * 
     * 
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public void deletePod(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        deletePodWithHttpInfo(name, local, xLocalstackStateSecret, remoteConfig);
    }

    /**
     * 
     * 
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deletePodWithHttpInfo(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = deletePodValidateBeforeCall(name, local, xLocalstackStateSecret, remoteConfig, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * 
     * @param name  (required)
     * @param local If true, the pod will be deleted only from the local storage (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Deletion failed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deletePodAsync(String name, String local, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deletePodValidateBeforeCall(name, local, xLocalstackStateSecret, remoteConfig, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteRemote
     * @param name The name of the remote to delete. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteRemoteCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteRemoteValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteRemote(Async)");
        }

        return deleteRemoteCall(name, _callback);

    }

    /**
     * Delete a remote
     * Deletes a remote with the specified name.
     * @param name The name of the remote to delete. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteRemote(String name) throws ApiException {
        deleteRemoteWithHttpInfo(name);
    }

    /**
     * Delete a remote
     * Deletes a remote with the specified name.
     * @param name The name of the remote to delete. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteRemoteWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = deleteRemoteValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete a remote (asynchronously)
     * Deletes a remote with the specified name.
     * @param name The name of the remote to delete. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Remote deleted successfully. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteRemoteAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteRemoteValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFaultRules
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFaultRulesCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFaultRulesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getFaultRulesCall(_callback);

    }

    /**
     * Get the current fault configuration
     * Retrieve the list of currently configured fault rules.
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> getFaultRules() throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = getFaultRulesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get the current fault configuration
     * Retrieve the list of currently configured fault rules.
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> getFaultRulesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getFaultRulesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the current fault configuration (asynchronously)
     * Retrieve the list of currently configured fault rules.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFaultRulesAsync(final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFaultRulesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getNetworkEffects
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNetworkEffectsCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/effects";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNetworkEffectsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return getNetworkEffectsCall(_callback);

    }

    /**
     * Get current network effects configuration
     * Retrieve the current configuration for network latency effects in Localstack Chaos.
     * @return NetworkEffectsConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public NetworkEffectsConfig getNetworkEffects() throws ApiException {
        ApiResponse<NetworkEffectsConfig> localVarResp = getNetworkEffectsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get current network effects configuration
     * Retrieve the current configuration for network latency effects in Localstack Chaos.
     * @return ApiResponse&lt;NetworkEffectsConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NetworkEffectsConfig> getNetworkEffectsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getNetworkEffectsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get current network effects configuration (asynchronously)
     * Retrieve the current configuration for network latency effects in Localstack Chaos.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of configuration </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNetworkEffectsAsync(final ApiCallback<NetworkEffectsConfig> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNetworkEffectsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getPodVersions
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPodVersionsCall(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}/versions"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPodVersionsValidateBeforeCall(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getPodVersions(Async)");
        }

        return getPodVersionsCall(name, xLocalstackStateSecret, remoteConfig, _callback);

    }

    /**
     * 
     * List versions for a cloud pod
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return PodVersions
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public PodVersions getPodVersions(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        ApiResponse<PodVersions> localVarResp = getPodVersionsWithHttpInfo(name, xLocalstackStateSecret, remoteConfig);
        return localVarResp.getData();
    }

    /**
     * 
     * List versions for a cloud pod
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;PodVersions&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PodVersions> getPodVersionsWithHttpInfo(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = getPodVersionsValidateBeforeCall(name, xLocalstackStateSecret, remoteConfig, null);
        Type localVarReturnType = new TypeToken<PodVersions>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * List versions for a cloud pod
     * @param name Cloud pod name (required)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of version details. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPodVersionsAsync(String name, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback<PodVersions> _callback) throws ApiException {

        okhttp3.Call localVarCall = getPodVersionsValidateBeforeCall(name, xLocalstackStateSecret, remoteConfig, _callback);
        Type localVarReturnType = new TypeToken<PodVersions>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRemote
     * @param name The name of the remote. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRemoteCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRemoteValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getRemote(Async)");
        }

        return getRemoteCall(name, _callback);

    }

    /**
     * Get a specific remote
     * Retrieves information about a specific remote by name.
     * @param name The name of the remote. (required)
     * @return PodRemote
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public PodRemote getRemote(String name) throws ApiException {
        ApiResponse<PodRemote> localVarResp = getRemoteWithHttpInfo(name);
        return localVarResp.getData();
    }

    /**
     * Get a specific remote
     * Retrieves information about a specific remote by name.
     * @param name The name of the remote. (required)
     * @return ApiResponse&lt;PodRemote&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PodRemote> getRemoteWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = getRemoteValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodRemote>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a specific remote (asynchronously)
     * Retrieves information about a specific remote by name.
     * @param name The name of the remote. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Details of the remote. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRemoteAsync(String name, final ApiCallback<PodRemote> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRemoteValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodRemote>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listPods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPodsCall(String creator, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (creator != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creator", creator));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPodsValidateBeforeCall(String creator, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        return listPodsCall(creator, remoteConfig, _callback);

    }

    /**
     * 
     * List cloud pods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @return PodList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public PodList listPods(String creator, RemoteConfig remoteConfig) throws ApiException {
        ApiResponse<PodList> localVarResp = listPodsWithHttpInfo(creator, remoteConfig);
        return localVarResp.getData();
    }

    /**
     * 
     * List cloud pods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;PodList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PodList> listPodsWithHttpInfo(String creator, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = listPodsValidateBeforeCall(creator, remoteConfig, null);
        Type localVarReturnType = new TypeToken<PodList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * List cloud pods
     * @param creator User ID of the pod creator. Special values like &#x60;me&#x60; are accepted. (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The list of Cloud Pods associated with a given identity </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPodsAsync(String creator, RemoteConfig remoteConfig, final ApiCallback<PodList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listPodsValidateBeforeCall(creator, remoteConfig, _callback);
        Type localVarReturnType = new TypeToken<PodList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listRemotes
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRemotesCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/remotes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listRemotesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return listRemotesCall(_callback);

    }

    /**
     * 
     * Retrieves a list of all configured remotes.
     * @return ListRemotes200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public ListRemotes200Response listRemotes() throws ApiException {
        ApiResponse<ListRemotes200Response> localVarResp = listRemotesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Retrieves a list of all configured remotes.
     * @return ApiResponse&lt;ListRemotes200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListRemotes200Response> listRemotesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listRemotesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ListRemotes200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Retrieves a list of all configured remotes.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A list of remotes. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listRemotesAsync(final ApiCallback<ListRemotes200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = listRemotesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ListRemotes200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for loadPod
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call loadPodCall(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = remoteConfig;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (merge != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("merge", merge));
        }

        if (ignoreVersionMismatches != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignore_version_mismatches", ignoreVersionMismatches));
        }

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
            "application/x-ndjson"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call loadPodValidateBeforeCall(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling loadPod(Async)");
        }

        return loadPodCall(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig, _callback);

    }

    /**
     * 
     * Load a cloud pod version
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public void loadPod(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        loadPodWithHttpInfo(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig);
    }

    /**
     * 
     * Load a cloud pod version
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> loadPodWithHttpInfo(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig) throws ApiException {
        okhttp3.Call localVarCall = loadPodValidateBeforeCall(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Load a cloud pod version
     * @param name The name of the Cloud Pod to be loaded into the runtime (required)
     * @param version The version of the Cloud Pod to be loaded into the runtime (optional)
     * @param merge Merge strategy to use when loading the pod (optional)
     * @param ignoreVersionMismatches Ignores version mismatches between the pod and the current LocalStack version. (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param remoteConfig  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call loadPodAsync(String name, String version, String merge, String ignoreVersionMismatches, String xLocalstackStateSecret, RemoteConfig remoteConfig, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = loadPodValidateBeforeCall(name, version, merge, ignoreVersionMismatches, xLocalstackStateSecret, remoteConfig, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsEnvironmentGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsEnvironmentGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/environment";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsEnvironmentGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackPodsEnvironmentGetCall(_callback);

    }

    /**
     * 
     * Retrieves some information about the current environment, like LocalStack and Moto versions. 
     * @return LocalstackPodsEnvironmentGet200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public LocalstackPodsEnvironmentGet200Response localstackPodsEnvironmentGet() throws ApiException {
        ApiResponse<LocalstackPodsEnvironmentGet200Response> localVarResp = localstackPodsEnvironmentGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Retrieves some information about the current environment, like LocalStack and Moto versions. 
     * @return ApiResponse&lt;LocalstackPodsEnvironmentGet200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LocalstackPodsEnvironmentGet200Response> localstackPodsEnvironmentGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackPodsEnvironmentGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<LocalstackPodsEnvironmentGet200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Retrieves some information about the current environment, like LocalStack and Moto versions. 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A JSON object containing environment version information. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsEnvironmentGetAsync(final ApiCallback<LocalstackPodsEnvironmentGet200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsEnvironmentGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<LocalstackPodsEnvironmentGet200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsStateGet
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateGetCall(String podName, String services, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/state";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (podName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pod_name", podName));
        }

        if (services != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("services", services));
        }

        final String[] localVarAccepts = {
            "application/zip"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsStateGetValidateBeforeCall(String podName, String services, final ApiCallback _callback) throws ApiException {
        return localstackPodsStateGetCall(podName, services, _callback);

    }

    /**
     * 
     * Exports the current state of the LocalStack container into a zip file.
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public File localstackPodsStateGet(String podName, String services) throws ApiException {
        ApiResponse<File> localVarResp = localstackPodsStateGetWithHttpInfo(podName, services);
        return localVarResp.getData();
    }

    /**
     * 
     * Exports the current state of the LocalStack container into a zip file.
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public ApiResponse<File> localstackPodsStateGetWithHttpInfo(String podName, String services) throws ApiException {
        okhttp3.Call localVarCall = localstackPodsStateGetValidateBeforeCall(podName, services, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Exports the current state of the LocalStack container into a zip file.
     * @param podName The name of the pod to save. Defaults to a unique name based on the current timestamp. (optional)
     * @param services Comma-separated list of service names to include in the exported state. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A zip file containing the exported pod state. </td><td>  * Content-Disposition - Specifies that the response is an attachment. <br>  * Content-Length - Length of the pod in bytes. <br>  * x-localstack-pod-services - Comma-separated list of services included in the pod state. <br>  * x-localstack-pod-size - The size of the pod file in bytes. <br>  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateGetAsync(String podName, String services, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsStateGetValidateBeforeCall(podName, services, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsStateMetamodelGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateMetamodelGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/state/metamodel";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsStateMetamodelGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackPodsStateMetamodelGetCall(_callback);

    }

    /**
     * 
     * Extract a metamodel representing the state of the current LocalStack session
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public void localstackPodsStateMetamodelGet() throws ApiException {
        localstackPodsStateMetamodelGetWithHttpInfo();
    }

    /**
     * 
     * Extract a metamodel representing the state of the current LocalStack session
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackPodsStateMetamodelGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackPodsStateMetamodelGetValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Extract a metamodel representing the state of the current LocalStack session
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Metamodel representing the state of the current LocalStack session </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStateMetamodelGetAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsStateMetamodelGetValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackPodsStatePost
     * @param pod  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStatePostCall(File pod, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/pods/state";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (pod != null) {
            localVarFormParams.put("pod", pod);
        }

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data",
            "application/octet-stream"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackPodsStatePostValidateBeforeCall(File pod, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'pod' is set
        if (pod == null) {
            throw new ApiException("Missing the required parameter 'pod' when calling localstackPodsStatePost(Async)");
        }

        return localstackPodsStatePostCall(pod, _callback);

    }

    /**
     * 
     * Loads a pod state from a zip file and restores its services.
     * @param pod  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public void localstackPodsStatePost(File pod) throws ApiException {
        localstackPodsStatePostWithHttpInfo(pod);
    }

    /**
     * 
     * Loads a pod state from a zip file and restores its services.
     * @param pod  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackPodsStatePostWithHttpInfo(File pod) throws ApiException {
        okhttp3.Call localVarCall = localstackPodsStatePostValidateBeforeCall(pod, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Loads a pod state from a zip file and restores its services.
     * @param pod  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Pod state loaded successfully. </td><td>  * Content-Length - Length of the pod in bytes. <br>  </td></tr>
        <tr><td> 400 </td><td> Bad request. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackPodsStatePostAsync(File pod, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackPodsStatePostValidateBeforeCall(pod, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStackinfoGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStackinfoGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/stackinfo";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStackinfoGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackStackinfoGetCall(_callback);

    }

    /**
     * 
     * Collect information used to populate the dashboard info.
     * @return LocalstackStackinfoGet200Response
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public LocalstackStackinfoGet200Response localstackStackinfoGet() throws ApiException {
        ApiResponse<LocalstackStackinfoGet200Response> localVarResp = localstackStackinfoGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Collect information used to populate the dashboard info.
     * @return ApiResponse&lt;LocalstackStackinfoGet200Response&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LocalstackStackinfoGet200Response> localstackStackinfoGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackStackinfoGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<LocalstackStackinfoGet200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Collect information used to populate the dashboard info.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStackinfoGetAsync(final ApiCallback<LocalstackStackinfoGet200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStackinfoGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<LocalstackStackinfoGet200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStateLoadPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateLoadPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/state/load";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/x-ndjson"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStateLoadPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackStateLoadPostCall(_callback);

    }

    /**
     * 
     * Load all service states
     * @return StateResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public StateResult localstackStateLoadPost() throws ApiException {
        ApiResponse<StateResult> localVarResp = localstackStateLoadPostWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Load all service states
     * @return ApiResponse&lt;StateResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StateResult> localstackStateLoadPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackStateLoadPostValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<StateResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Load all service states
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateLoadPostAsync(final ApiCallback<StateResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStateLoadPostValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<StateResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStateResetPost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateResetPostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/state/reset";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStateResetPostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackStateResetPostCall(_callback);

    }

    /**
     * 
     * Reset all service states
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public void localstackStateResetPost() throws ApiException {
        localstackStateResetPostWithHttpInfo();
    }

    /**
     * 
     * Reset all service states
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackStateResetPostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackStateResetPostValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Reset all service states
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateResetPostAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStateResetPostValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStateSavePost
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateSavePostCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/state/save";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/x-ndjson"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStateSavePostValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return localstackStateSavePostCall(_callback);

    }

    /**
     * 
     * Save all service states
     * @return StateResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public StateResult localstackStateSavePost() throws ApiException {
        ApiResponse<StateResult> localVarResp = localstackStateSavePostWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Save all service states
     * @return ApiResponse&lt;StateResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<StateResult> localstackStateSavePostWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = localstackStateSavePostValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<StateResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Save all service states
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful or error is one of the status is &#39;error&#39; </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateSavePostAsync(final ApiCallback<StateResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStateSavePostValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<StateResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStateServiceLoadPost
     * @param service Service name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateServiceLoadPostCall(String service, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/state/{service}/load"
            .replace("{" + "service" + "}", localVarApiClient.escapeString(service.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStateServiceLoadPostValidateBeforeCall(String service, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new ApiException("Missing the required parameter 'service' when calling localstackStateServiceLoadPost(Async)");
        }

        return localstackStateServiceLoadPostCall(service, _callback);

    }

    /**
     * 
     * Load a service state
     * @param service Service name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public void localstackStateServiceLoadPost(String service) throws ApiException {
        localstackStateServiceLoadPostWithHttpInfo(service);
    }

    /**
     * 
     * Load a service state
     * @param service Service name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackStateServiceLoadPostWithHttpInfo(String service) throws ApiException {
        okhttp3.Call localVarCall = localstackStateServiceLoadPostValidateBeforeCall(service, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Load a service state
     * @param service Service name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateServiceLoadPostAsync(String service, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStateServiceLoadPostValidateBeforeCall(service, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStateServiceResetPost
     * @param service Service name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateServiceResetPostCall(String service, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/state/{service}/reset"
            .replace("{" + "service" + "}", localVarApiClient.escapeString(service.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStateServiceResetPostValidateBeforeCall(String service, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new ApiException("Missing the required parameter 'service' when calling localstackStateServiceResetPost(Async)");
        }

        return localstackStateServiceResetPostCall(service, _callback);

    }

    /**
     * 
     * Reset a service state
     * @param service Service name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public void localstackStateServiceResetPost(String service) throws ApiException {
        localstackStateServiceResetPostWithHttpInfo(service);
    }

    /**
     * 
     * Reset a service state
     * @param service Service name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackStateServiceResetPostWithHttpInfo(String service) throws ApiException {
        okhttp3.Call localVarCall = localstackStateServiceResetPostValidateBeforeCall(service, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Reset a service state
     * @param service Service name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateServiceResetPostAsync(String service, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStateServiceResetPostValidateBeforeCall(service, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for localstackStateServiceSavePost
     * @param service Service name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateServiceSavePostCall(String service, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/_localstack/state/{service}/save"
            .replace("{" + "service" + "}", localVarApiClient.escapeString(service.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call localstackStateServiceSavePostValidateBeforeCall(String service, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'service' is set
        if (service == null) {
            throw new ApiException("Missing the required parameter 'service' when calling localstackStateServiceSavePost(Async)");
        }

        return localstackStateServiceSavePostCall(service, _callback);

    }

    /**
     * 
     * Save a service state
     * @param service Service name (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public void localstackStateServiceSavePost(String service) throws ApiException {
        localstackStateServiceSavePostWithHttpInfo(service);
    }

    /**
     * 
     * Save a service state
     * @param service Service name (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> localstackStateServiceSavePostWithHttpInfo(String service) throws ApiException {
        okhttp3.Call localVarCall = localstackStateServiceSavePostValidateBeforeCall(service, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Save a service state
     * @param service Service name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Failure </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call localstackStateServiceSavePostAsync(String service, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = localstackStateServiceSavePostValidateBeforeCall(service, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for savePod
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call savePodCall(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = podSaveRequest;

        // create path and map variables
        String localVarPath = "/_localstack/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (local != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("local", local));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        if (xLocalstackStateSecret != null) {
            localVarHeaderParams.put("x-localstack-state-secret", localVarApiClient.parameterToString(xLocalstackStateSecret));
        }

        final String[] localVarAccepts = {
            "application/x-ndjson"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call savePodValidateBeforeCall(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling savePod(Async)");
        }

        return savePodCall(name, local, version, xLocalstackStateSecret, podSaveRequest, _callback);

    }

    /**
     * 
     * Create and register a cloud pod version
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public void savePod(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest) throws ApiException {
        savePodWithHttpInfo(name, local, version, xLocalstackStateSecret, podSaveRequest);
    }

    /**
     * 
     * Create and register a cloud pod version
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> savePodWithHttpInfo(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest) throws ApiException {
        okhttp3.Call localVarCall = savePodValidateBeforeCall(name, local, version, xLocalstackStateSecret, podSaveRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Create and register a cloud pod version
     * @param name Cloud pod name (required)
     * @param local  (optional)
     * @param version Cloud pod version (optional)
     * @param xLocalstackStateSecret A secret token for authenticating the request against the platform (optional)
     * @param podSaveRequest  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The response is a sequence of JSON events, according to the schema, separated by a newline </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call savePodAsync(String name, Boolean local, String version, String xLocalstackStateSecret, PodSaveRequest podSaveRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = savePodValidateBeforeCall(name, local, version, xLocalstackStateSecret, podSaveRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setFaultRules
     * @param faultRule  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setFaultRulesCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = faultRule;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/faults";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setFaultRulesValidateBeforeCall(Set<FaultRule> faultRule, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'faultRule' is set
        if (faultRule == null) {
            throw new ApiException("Missing the required parameter 'faultRule' when calling setFaultRules(Async)");
        }

        return setFaultRulesCall(faultRule, _callback);

    }

    /**
     * Set a new fault configuration
     * Set a new set of fault rules. Overwrite the previous ones.
     * @param faultRule  (required)
     * @return Set&lt;FaultRule&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public Set<FaultRule> setFaultRules(Set<FaultRule> faultRule) throws ApiException {
        ApiResponse<Set<FaultRule>> localVarResp = setFaultRulesWithHttpInfo(faultRule);
        return localVarResp.getData();
    }

    /**
     * Set a new fault configuration
     * Set a new set of fault rules. Overwrite the previous ones.
     * @param faultRule  (required)
     * @return ApiResponse&lt;Set&lt;FaultRule&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Set<FaultRule>> setFaultRulesWithHttpInfo(Set<FaultRule> faultRule) throws ApiException {
        okhttp3.Call localVarCall = setFaultRulesValidateBeforeCall(faultRule, null);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set a new fault configuration (asynchronously)
     * Set a new set of fault rules. Overwrite the previous ones.
     * @param faultRule  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successful retrieval of current configuration. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setFaultRulesAsync(Set<FaultRule> faultRule, final ApiCallback<Set<FaultRule>> _callback) throws ApiException {

        okhttp3.Call localVarCall = setFaultRulesValidateBeforeCall(faultRule, _callback);
        Type localVarReturnType = new TypeToken<Set<FaultRule>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setNetworkEffects
     * @param networkEffectsConfig  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setNetworkEffectsCall(NetworkEffectsConfig networkEffectsConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = networkEffectsConfig;

        // create path and map variables
        String localVarPath = "/_localstack/chaos/effects";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setNetworkEffectsValidateBeforeCall(NetworkEffectsConfig networkEffectsConfig, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'networkEffectsConfig' is set
        if (networkEffectsConfig == null) {
            throw new ApiException("Missing the required parameter 'networkEffectsConfig' when calling setNetworkEffects(Async)");
        }

        return setNetworkEffectsCall(networkEffectsConfig, _callback);

    }

    /**
     * Configure network effects
     * Network effects include things like latency, jitter, bandwidth throttling etc. which do not lead to an application-level fault/exception.
     * @param networkEffectsConfig  (required)
     * @return NetworkEffectsConfig
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public NetworkEffectsConfig setNetworkEffects(NetworkEffectsConfig networkEffectsConfig) throws ApiException {
        ApiResponse<NetworkEffectsConfig> localVarResp = setNetworkEffectsWithHttpInfo(networkEffectsConfig);
        return localVarResp.getData();
    }

    /**
     * Configure network effects
     * Network effects include things like latency, jitter, bandwidth throttling etc. which do not lead to an application-level fault/exception.
     * @param networkEffectsConfig  (required)
     * @return ApiResponse&lt;NetworkEffectsConfig&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NetworkEffectsConfig> setNetworkEffectsWithHttpInfo(NetworkEffectsConfig networkEffectsConfig) throws ApiException {
        okhttp3.Call localVarCall = setNetworkEffectsValidateBeforeCall(networkEffectsConfig, null);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Configure network effects (asynchronously)
     * Network effects include things like latency, jitter, bandwidth throttling etc. which do not lead to an application-level fault/exception.
     * @param networkEffectsConfig  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully configured network effects </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setNetworkEffectsAsync(NetworkEffectsConfig networkEffectsConfig, final ApiCallback<NetworkEffectsConfig> _callback) throws ApiException {

        okhttp3.Call localVarCall = setNetworkEffectsValidateBeforeCall(networkEffectsConfig, _callback);
        Type localVarReturnType = new TypeToken<NetworkEffectsConfig>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
