/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricDataResult;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import com.amazonaws.services.cloudwatch.model.MetricDataResult;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.MetricStat;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
@LocalstackDockerProperties(ignoreDockerRunErrors=true)
public class CWMetricsTest {
    @Test
    public void testCWMetricsAPIs() throws ParseException {
        AmazonCloudWatch cw = TestUtils.getClientCloudWatch();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Dimension dimension = new Dimension().withName("UNIQUE_PAGES").withValue("URLS");
        MetricDatum datum = new MetricDatum().withMetricName("PAGES_VISITED").withUnit(StandardUnit.None).withTimestamp(dateFormat.parse("2019-01-02")).withDimensions(new Dimension[]{dimension});
        PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest().withNamespace("SITE/TRAFFIC").withMetricData(new MetricDatum[]{datum});
        cw.putMetricData(putMetricDataRequest);
        GetMetricStatisticsRequest getMetricStatisticsRequest = new GetMetricStatisticsRequest().withMetricName("PAGES_VISITED").withNamespace("SITE/TRAFFIC").withStatistics(new String[]{"Statistics"}).withStartTime(dateFormat.parse("2019-01-01")).withEndTime(dateFormat.parse("2019-01-03")).withPeriod(Integer.valueOf(360));
        GetMetricStatisticsResult metricStatistics = cw.getMetricStatistics(getMetricStatisticsRequest);
        Assert.assertEquals((long)metricStatistics.getDatapoints().size(), (long)1L);
        ListMetricsResult metrics = cw.listMetrics(new ListMetricsRequest());
        Assert.assertEquals((long)metrics.getMetrics().size(), (long)1L);
    }

    @Test
    public void testCWGetMetricData() {
        AmazonCloudWatch cw = TestUtils.getClientCloudWatch();
        Metric metric = new Metric().withNamespace("customNamespace").withMetricName("MaxMemoryUsage").withDimensions(new Dimension[]{new Dimension().withName("id").withValue("specificId"), new Dimension().withName("class").withValue("customNamespace"), new Dimension().withName("level").withValue("INFO"), new Dimension().withName("type").withValue("GAUGE")});
        cw.listMetrics();
        String metricQueryId = "someName";
        MetricDataQuery metricDataQuery = new MetricDataQuery().withId(metricQueryId).withLabel("someLabel").withReturnData(Boolean.valueOf(true)).withMetricStat(new MetricStat().withMetric(metric).withStat("Average").withUnit("None").withPeriod(Integer.valueOf(5)));
        GetMetricDataRequest getMetricDataRequest = new GetMetricDataRequest().withMetricDataQueries(new MetricDataQuery[]{metricDataQuery}).withStartTime(new Date(System.currentTimeMillis() - 3600000L)).withEndTime(new Date(System.currentTimeMillis())).withMaxDatapoints(Integer.valueOf(100));
        GetMetricDataResult getMetricDataResult = cw.getMetricData(getMetricDataRequest);
        Assert.assertEquals((long)getMetricDataResult.getMetricDataResults().size(), (long)1L);
        Assert.assertEquals((Object)((MetricDataResult)getMetricDataResult.getMetricDataResults().get(0)).getId(), (Object)metricQueryId);
    }
}

