/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.docker.LocalstackDockerExtension;
import cloud.localstack.docker.annotation.LocalstackDockerProperties;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.services.logs.model.GetLogEventsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.OutputLogEvent;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackTestRunner.class)
@ExtendWith(value={LocalstackDockerExtension.class})
@LocalstackDockerProperties(services={"logs"}, ignoreDockerRunErrors=true)
public class CloudWatchLogsTest {
    @Test
    @org.junit.jupiter.api.Test
    public void testLogGroupSetupAndPublish() {
        AWSLogs cloudWatchLogs = TestUtils.getClientCloudWatchLogs();
        DescribeLogGroupsResult groups = cloudWatchLogs.describeLogGroups();
        Assertions.assertTrue((boolean)groups.getLogGroups().isEmpty());
        String logGroupName = this.createLogGroup();
        DescribeLogGroupsResult groupsAfterCreation = cloudWatchLogs.describeLogGroups();
        Assertions.assertFalse((boolean)groupsAfterCreation.getLogGroups().isEmpty());
        Assertions.assertEquals((int)1, (int)groupsAfterCreation.getLogGroups().size());
        LogGroup newGroup = (LogGroup)groupsAfterCreation.getLogGroups().get(0);
        Assertions.assertEquals((Object)logGroupName, (Object)newGroup.getLogGroupName());
        Assertions.assertNotNull((Object)newGroup.getArn());
        Assertions.assertEquals((long)0L, (Long)newGroup.getStoredBytes());
        String logStream = this.createLogStream(logGroupName);
        List<InputLogEvent> events = this.publishLogEvents(logGroupName, logStream);
        GetLogEventsResult publishedEvents = this.fetchEvents(logGroupName, logStream);
        Assertions.assertEquals((int)events.size(), (int)publishedEvents.getEvents().size());
        List messagesSent = events.stream().map(InputLogEvent::getMessage).collect(Collectors.toList());
        for (OutputLogEvent publishedOutputEvent : publishedEvents.getEvents()) {
            Assertions.assertTrue((boolean)messagesSent.contains(publishedOutputEvent.getMessage()));
        }
    }

    public String createLogGroup() {
        CreateLogGroupRequest createLogGroupRequest = new CreateLogGroupRequest();
        createLogGroupRequest.setLogGroupName("testLogGroupName-" + UUID.randomUUID().toString());
        TestUtils.getClientCloudWatchLogs().createLogGroup(createLogGroupRequest);
        return createLogGroupRequest.getLogGroupName();
    }

    public String createLogStream(String newGroup) {
        CreateLogStreamRequest newStreamRequest = new CreateLogStreamRequest();
        newStreamRequest.setLogGroupName(newGroup);
        newStreamRequest.setLogStreamName("stream-" + UUID.randomUUID().toString());
        TestUtils.getClientCloudWatchLogs().createLogStream(newStreamRequest);
        return newStreamRequest.getLogStreamName();
    }

    public List<InputLogEvent> publishLogEvents(String groupName, String logStream) {
        InputLogEvent event1 = new InputLogEvent();
        event1.setMessage("Event1-" + UUID.randomUUID().toString());
        event1.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        InputLogEvent event2 = new InputLogEvent();
        event2.setMessage("Event2-" + UUID.randomUUID().toString());
        event2.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        ArrayList<InputLogEvent> events = new ArrayList<InputLogEvent>();
        events.add(event1);
        events.add(event2);
        PutLogEventsRequest putLogEventsRequest = new PutLogEventsRequest();
        putLogEventsRequest.setLogGroupName(groupName);
        putLogEventsRequest.setLogStreamName(logStream);
        putLogEventsRequest.setLogEvents(events);
        TestUtils.getClientCloudWatchLogs().putLogEvents(putLogEventsRequest);
        return events;
    }

    public GetLogEventsResult fetchEvents(String groupName, String logStream) {
        GetLogEventsRequest getLogEventsRequest = new GetLogEventsRequest();
        getLogEventsRequest.setLogStreamName(logStream);
        getLogEventsRequest.setLogGroupName(groupName);
        return TestUtils.getClientCloudWatchLogs().getLogEvents(getLogEventsRequest);
    }
}

