/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.awssdkv2;

import cloud.localstack.LocalstackTestRunner;
import cloud.localstack.awssdkv2.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;

@RunWith(value=LocalstackTestRunner.class)
public class BasicFeaturesSDKV2Test {
    @Test
    public void testCreateSqsQueueV2() throws Exception {
        String queueName = "test-q-2159";
        CreateQueueRequest request = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        SqsAsyncClient sqsClient = TestUtils.getClientSQSAsyncV2();
        CreateQueueResponse queue = (CreateQueueResponse)sqsClient.createQueue(request).get();
        Assert.assertTrue((boolean)queue.queueUrl().contains("000000000000/" + queueName));
    }

    @Test
    public void testCreateKinesisStreamV2() throws Exception {
        String streamName = "test-s-3198";
        KinesisAsyncClient kinesisClient = TestUtils.getClientKinesisAsyncV2();
        CreateStreamRequest request = (CreateStreamRequest)CreateStreamRequest.builder().streamName(streamName).shardCount(Integer.valueOf(1)).build();
        CreateStreamResponse response = (CreateStreamResponse)kinesisClient.createStream(request).get();
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testS3CreateListBuckets() throws Exception {
        String bucketName = "test-b-9716";
        S3AsyncClient s3Client = TestUtils.getClientS3AsyncV2();
        CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
        CreateBucketResponse response = (CreateBucketResponse)s3Client.createBucket(request).get();
        Assert.assertNotNull((Object)response);
        ListBucketsRequest listRequest = (ListBucketsRequest)ListBucketsRequest.builder().build();
        ListBucketsResponse buckets = (ListBucketsResponse)s3Client.listBuckets(listRequest).get();
        Bucket bucket = buckets.buckets().stream().filter(b -> b.name().equals(bucketName)).findFirst().get();
        Assert.assertNotNull((Object)bucket);
    }

    @Test
    public void testSendSNSMessage() throws Exception {
        String topicName = "test-t-6210";
        SnsAsyncClient clientSNS = TestUtils.getClientSNSAsyncV2();
        CreateTopicResponse createTopicResponse = (CreateTopicResponse)clientSNS.createTopic((CreateTopicRequest)CreateTopicRequest.builder().name("test-t-6210").build()).get();
        String topicArn = createTopicResponse.topicArn();
        Assert.assertNotNull((Object)topicArn);
        PublishRequest publishRequest = (PublishRequest)PublishRequest.builder().topicArn(topicArn).subject("test subject").message("message test.").build();
        PublishResponse publishResponse = (PublishResponse)clientSNS.publish(publishRequest).get();
        Assert.assertNotNull((Object)publishResponse.messageId());
    }

    static {
        System.setProperty(SdkSystemSetting.CBOR_ENABLED.property(), "false");
    }
}

