/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack.deprecated;

import cloud.localstack.CommonUtils;
import cloud.localstack.awssdkv1.LocalTestUtilSDKV1;
import cloud.localstack.awssdkv1.TestUtils;
import cloud.localstack.awssdkv1.sample.KinesisLambdaHandler;
import cloud.localstack.awssdkv1.sample.S3Sample;
import cloud.localstack.awssdkv1.sample.SQSLambdaHandler;
import cloud.localstack.deprecated.Localstack;
import cloud.localstack.deprecated.LocalstackExtension;
import cloud.localstack.deprecated.LocalstackOutsideDockerTestRunner;
import cloud.localstack.utils.LocalTestUtil;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.ListFunctionsResult;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import io.thundra.jexter.junit4.core.envvar.EnvironmentVariableSandboxRule;
import io.thundra.jexter.junit5.core.envvar.EnvironmentVariableSandbox;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;

@RunWith(value=LocalstackOutsideDockerTestRunner.class)
@ExtendWith(value={LocalstackExtension.class})
@Ignore
@Disabled
@EnvironmentVariableSandbox
public class BasicFunctionalityTest {
    @ClassRule
    public static EnvironmentVariableSandboxRule environmentVariableSandboxRule;

    @BeforeClass
    @BeforeAll
    public static void beforeAll() {
        CommonUtils.setEnv((String)"AWS_CBOR_DISABLE", (String)"1");
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testDevEnvironmentSetup() {
        Assertions.assertThat((boolean)Localstack.isDevEnvironment()).isTrue();
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalKinesisAPI() throws InterruptedException {
        AmazonKinesis kinesis = TestUtils.getClientKinesis();
        ListStreamsResult streams = kinesis.listStreams();
        Assertions.assertThat((List)streams.getStreamNames()).isNotNull();
        String streamName = UUID.randomUUID().toString();
        kinesis.createStream(streamName, Integer.valueOf(1));
        Thread.sleep(500L);
        PutRecordRequest req = new PutRecordRequest();
        req.setPartitionKey("foobar-key");
        req.setData(ByteBuffer.wrap("{}".getBytes()));
        req.setStreamName(streamName);
        kinesis.putRecord(req);
        ByteBuffer data = ByteBuffer.wrap("{\"test\":\"test\"}".getBytes());
        kinesis.putRecord(streamName, data, "partition-key");
        kinesis.deleteStream(streamName);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testKinesisLambdaIntegration() throws Exception {
        AmazonKinesis kinesis = TestUtils.getClientKinesis();
        AWSLambda lambda = TestUtils.getClientLambda();
        String functionName = UUID.randomUUID().toString();
        String streamName = UUID.randomUUID().toString();
        CreateFunctionRequest request = new CreateFunctionRequest();
        request.setFunctionName(functionName);
        request.setRuntime(Runtime.Java8);
        request.setCode(LocalTestUtilSDKV1.createFunctionCode(KinesisLambdaHandler.class));
        request.setHandler(KinesisLambdaHandler.class.getName());
        request.setRole("r1");
        lambda.createFunction(request);
        kinesis.createStream(streamName, Integer.valueOf(1));
        Thread.sleep(500L);
        String streamArn = kinesis.describeStream(streamName).getStreamDescription().getStreamARN();
        CreateEventSourceMappingRequest mapping = new CreateEventSourceMappingRequest();
        mapping.setFunctionName(functionName);
        mapping.setEventSourceArn(streamArn);
        mapping.setStartingPosition("LATEST");
        lambda.createEventSourceMapping(mapping);
        kinesis.putRecord(streamName, ByteBuffer.wrap("{\"foo\": \"bar\"}".getBytes()), "partitionKey1");
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testSQSLambdaIntegration() throws Exception {
        AmazonSQS clientSQS = TestUtils.getClientSQS();
        AWSLambda lambda = TestUtils.getClientLambda();
        final AmazonS3 s3 = TestUtils.getClientS3();
        String functionName = UUID.randomUUID().toString();
        String sqsQueueName = UUID.randomUUID().toString();
        CreateFunctionRequest request = new CreateFunctionRequest();
        request.setFunctionName(functionName);
        request.setRuntime(Runtime.Java8);
        request.setRole("r1");
        request.setCode(LocalTestUtilSDKV1.createFunctionCode(SQSLambdaHandler.class));
        request.setHandler(SQSLambdaHandler.class.getName());
        lambda.createFunction(request);
        CreateQueueResult queue = clientSQS.createQueue(sqsQueueName);
        Thread.sleep(500L);
        GetQueueAttributesResult queueAttributes = clientSQS.getQueueAttributes(new GetQueueAttributesRequest().withQueueUrl(queue.getQueueUrl()).withAttributeNames(new QueueAttributeName[]{QueueAttributeName.QueueArn}));
        String queueArn = (String)queueAttributes.getAttributes().get(QueueAttributeName.QueueArn.name());
        CreateEventSourceMappingRequest mapping = new CreateEventSourceMappingRequest();
        mapping.setFunctionName(functionName);
        mapping.setEventSourceArn(queueArn);
        lambda.createEventSourceMapping(mapping);
        final String testBucket = UUID.randomUUID().toString();
        s3.createBucket(testBucket);
        clientSQS.sendMessage(queue.getQueueUrl(), testBucket);
        Runnable check = new Runnable(){

            @Override
            public void run() {
                ObjectListing objectListing = s3.listObjects(testBucket);
                Assertions.assertThat((List)objectListing.getObjectSummaries()).hasSize(1);
                String key = ((S3ObjectSummary)objectListing.getObjectSummaries().get(0)).getKey();
                Assertions.assertThat((String)key).startsWith((CharSequence)SQSLambdaHandler.fileName[0]);
                Assertions.assertThat((String)key).endsWith((CharSequence)SQSLambdaHandler.fileName[1]);
                String message = s3.getObjectAsString(testBucket, key);
                Assertions.assertThat((String)message).isEqualTo((Object)"Did you get the message?");
            }
        };
        LocalTestUtil.retry(check, 5, 1.0);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testSQSQueueAttributes() {
        AmazonSQSAsync sqsAsync = TestUtils.getClientSQSAsync();
        CreateQueueResult result1 = sqsAsync.createQueue("1551-test");
        CreateQueueResult result2 = sqsAsync.createQueue("1551-test-dlq");
        String queueArn = "QueueArn";
        GetQueueAttributesResult dlqQueueAttributes = sqsAsync.getQueueAttributes(result2.getQueueUrl(), Collections.singletonList("QueueArn"));
        dlqQueueAttributes.getAttributes().get("QueueArn");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("VisibilityTimeout", "60");
        attributes.put("MessageRetentionPeriod", "345600");
        attributes.put("RedrivePolicy", "{\"foo\":1}");
        String queueUrl = result1.getQueueUrl();
        sqsAsync.setQueueAttributes(queueUrl, attributes);
        Map result = sqsAsync.getQueueAttributes(queueUrl, Arrays.asList("All")).getAttributes();
        Assert.assertEquals(result.get("MessageRetentionPeriod"), (Object)"345600");
        Assert.assertEquals(result.get("VisibilityTimeout"), (Object)"60");
        Assert.assertEquals(result.get("RedrivePolicy"), (Object)"{\"foo\":1}");
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalS3API() throws Exception {
        AmazonS3 s3 = TestUtils.getClientS3();
        List buckets = s3.listBuckets();
        Assertions.assertThat((List)buckets).isNotNull();
        String s3Endpoint = Localstack.INSTANCE.getEndpointS3();
        S3Sample.runTest(TestUtils.TEST_CREDENTIALS, s3Endpoint);
        String testBucket = UUID.randomUUID().toString();
        s3.createBucket(testBucket);
        File file = Files.createTempFile("localstack", "s3", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.putNextEntry(new ZipEntry("Some content"));
        zipOutputStream.write("Some text content".getBytes());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        s3.putObject(testBucket, file.getName(), file);
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalLambdaAPI() {
        AWSLambda lambda = TestUtils.getClientLambda();
        ListFunctionsResult functions = lambda.listFunctions();
        Assertions.assertThat((List)functions.getFunctions()).isNotNull();
    }

    @Test
    @org.junit.jupiter.api.Test
    public void testLocalSQSAPI() {
        AmazonSQS sqs = TestUtils.getClientSQS();
        ListQueuesResult queues = sqs.listQueues();
        Assertions.assertThat((List)queues.getQueueUrls()).isNotNull();
        for (String queueName : Arrays.asList("java_test_queue", "java_test_queue.fifo")) {
            CreateQueueRequest createQueueRequest = new CreateQueueRequest();
            createQueueRequest.setQueueName(queueName);
            CreateQueueResult newQueue = sqs.createQueue(createQueueRequest);
            String queueUrl = newQueue.getQueueUrl();
            SendMessageRequest send = new SendMessageRequest(queueUrl, "body");
            SendMessageResult sendResult = sqs.sendMessage(send);
            Assertions.assertThat((String)sendResult.getMD5OfMessageBody()).isNotNull();
            ReceiveMessageRequest request = new ReceiveMessageRequest(queueUrl);
            request.setWaitTimeSeconds(Integer.valueOf(1));
            request.setMaxNumberOfMessages(Integer.valueOf(1));
            request.setMessageAttributeNames(Arrays.asList("All"));
            request.setAttributeNames(Arrays.asList("All"));
            ReceiveMessageResult result = sqs.receiveMessage(request);
            ((ListAssert)Assertions.assertThat((List)result.getMessages()).isNotNull()).hasSize(1);
            DeleteQueueRequest deleteQueue = new DeleteQueueRequest();
            deleteQueue.setQueueUrl(queueUrl);
            sqs.deleteQueue(deleteQueue);
        }
    }

    static {
        if (Localstack.useSSL()) {
            CommonUtils.disableSslCertChecking();
        }
        environmentVariableSandboxRule = new EnvironmentVariableSandboxRule();
    }
}

