/*
 * Decompiled with CFR 0.152.
 */
package cn.beecloud;

import cn.beecloud.BCCache;
import cn.beecloud.BCEumeration;
import cn.beecloud.StrUtil;
import cn.beecloud.bean.BCException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;

public class RequestUtil {
    private static final String NOT_REGISTER = "\u672a\u6ce8\u518c";
    private static final String NOT_CORRECT_RESPONSE = "\u54cd\u5e94\u4e0d\u6b63\u786e";
    private static final String NETWORK_ERROR = "\u7f51\u7edc\u9519\u8bef";
    private static final String TEST_MODE_SUPPORT_ERROR = "\u6d4b\u8bd5\u6a21\u5f0f\u4ec5\u652f\u6301\u56fd\u5185\u652f\u4ed8(WX_JSAPI\u6682\u4e0d\u652f\u6301)\u3001\u8ba2\u5355\u67e5\u8be2\u3001\u8ba2\u5355\u603b\u6570\u67e5\u8be2\u3001\u5355\u7b14\u8ba2\u5355\u67e5\u8be2";

    public static Map<String, Object> doPost(String requestUrl, Map<String, Object> param) throws BCException {
        RequestUtil.addBcAnalysis(param);
        return RequestUtil.request(requestUrl, param, REQUEST_TYPE.POST);
    }

    public static Map<String, Object> doPut(String requestUrl, Map<String, Object> param) throws BCException {
        return RequestUtil.request(requestUrl, param, REQUEST_TYPE.PUT);
    }

    public static Map<String, Object> doGet(String requestUrl, Map<String, Object> param) throws BCException {
        return RequestUtil.request(requestUrl, param, REQUEST_TYPE.GET);
    }

    public static Map<String, Object> doGet(String requestUrl, String param) throws BCException {
        return RequestUtil.request(requestUrl, param, REQUEST_TYPE.GET);
    }

    public static Map<String, Object> doDelete(String requestUrl, String param) throws BCException {
        return RequestUtil.request(requestUrl, param, REQUEST_TYPE.DELETE);
    }

    private static void addBcAnalysis(Map<String, Object> param) {
        HashMap<String, String> bcAnalysis = new HashMap<String, String>();
        bcAnalysis.put("sdk_version", "JAVA_3.4.27");
        param.put("bc_analysis", bcAnalysis);
    }

    public static Map<String, Object> request(String requestUrl, Object param, REQUEST_TYPE request_type) throws BCException {
        Object appId;
        HttpURLConnection connection = null;
        Boolean paramIsMap = true;
        if (param instanceof Map) {
            appId = ((Map)param).get("app_id");
        } else {
            appId = StrUtil.toStr(param).contains("app_id") ? new Object() : null;
            paramIsMap = false;
        }
        if (StrUtil.empty(appId)) {
            throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), NOT_REGISTER);
        }
        Object out = null;
        BufferedReader in = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            if (request_type == REQUEST_TYPE.GET || request_type == REQUEST_TYPE.DELETE) {
                requestUrl = paramIsMap != false ? requestUrl + URLEncoder.encode(JSONObject.fromObject((Object)param).toString(), "UTF-8") : requestUrl + param;
            }
            URL url = new URL(requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(request_type.name());
            connection.setRequestProperty("Content-Type", "application/json");
            if (BCCache.getNetworkTimeout() > 0) {
                connection.setReadTimeout(BCCache.getNetworkTimeout());
                connection.setConnectTimeout(BCCache.getNetworkTimeout());
            } else {
                connection.setReadTimeout(30000);
                connection.setConnectTimeout(30000);
            }
            connection.setDoInput(true);
            if (request_type == REQUEST_TYPE.PUT || request_type == REQUEST_TYPE.POST) {
                connection.setDoOutput(true);
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(StrUtil.toStr(JSONObject.fromObject((Object)param)).getBytes("UTF-8"));
                outputStream.close();
            }
            Integer reponseStatus = connection.getResponseCode();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)StrUtil.toStr(result));
            Integer resultCode = jsonObject.getInt("result_code");
            String resultMessage = jsonObject.getString("result_msg");
            String errorDetail = jsonObject.getString("err_detail");
            if (resultCode == 0) {
                Map<String, Object> map = RequestUtil.jsonToMap(jsonObject);
                return map;
            }
            try {
                throw new BCException(resultCode, resultMessage, errorDetail, reponseStatus);
            }
            catch (BCException e) {
                throw e;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "\u7f16\u7801\u9519\u8bef," + e.getMessage());
            }
            catch (ProtocolException e) {
                e.printStackTrace();
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "\u7f51\u7edc\u5f02\u5e38," + e.getMessage());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "url\u4e0d\u5408\u6cd5," + e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "\u7f51\u7edc\u5f02\u5e38," + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BCException(-2, BCEumeration.RESULT_TYPE.OTHER_ERROR.name(), "\u672a\u77e5\u9519\u8bef," + e.getMessage());
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static Map<String, Object> jsonToMap(JSONObject json) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Object key : json.keySet()) {
            resultMap.put(StrUtil.toStr(key), json.get(key));
        }
        return resultMap;
    }

    public static enum REQUEST_TYPE {
        POST,
        PUT,
        GET,
        DELETE;

    }
}

