/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.executor.aigc;

import cn.bugstack.chatglm.executor.Executor;
import cn.bugstack.chatglm.model.ChatCompletionRequest;
import cn.bugstack.chatglm.model.ChatCompletionResponse;
import cn.bugstack.chatglm.model.ChatCompletionSyncResponse;
import cn.bugstack.chatglm.model.EventType;
import cn.bugstack.chatglm.model.ImageCompletionRequest;
import cn.bugstack.chatglm.model.ImageCompletionResponse;
import cn.bugstack.chatglm.session.Configuration;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.Nullable;

public class GLMOldExecutor
implements Executor {
    private final Configuration configuration;
    private final EventSource.Factory factory;

    public GLMOldExecutor(Configuration configuration) {
        this.configuration = configuration;
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(ChatCompletionRequest chatCompletionRequest, EventSourceListener eventSourceListener) throws Exception {
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v3/model-api/{model}/sse-invoke").replace("{model}", chatCompletionRequest.getModel().getCode())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatCompletionRequest.toString())).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public CompletableFuture<String> completions(ChatCompletionRequest chatCompletionRequest) throws InterruptedException {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        final StringBuffer dataBuffer = new StringBuffer();
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v3/model-api/{model}/sse-invoke").replace("{model}", chatCompletionRequest.getModel().getCode())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatCompletionRequest.toString())).build();
        this.factory.newEventSource(request, new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                ChatCompletionResponse response = (ChatCompletionResponse)JSON.parseObject((String)data, ChatCompletionResponse.class);
                if (EventType.add.getCode().equals(type)) {
                    dataBuffer.append(response.getData());
                } else if (EventType.finish.getCode().equals(type)) {
                    future.complete(dataBuffer.toString());
                }
            }

            public void onClosed(EventSource eventSource) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                future.completeExceptionally(new RuntimeException("Request closed before completion"));
            }
        });
        return future;
    }

    @Override
    public ChatCompletionSyncResponse completionsSync(ChatCompletionRequest chatCompletionRequest) throws IOException {
        Request request = new Request.Builder().url(this.configuration.getApiHost().concat("api/paas/v3/model-api/{model}/invoke").replace("{model}", chatCompletionRequest.getModel().getCode())).header("Accept", "application/json").post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)chatCompletionRequest.toString())).build();
        OkHttpClient okHttpClient = this.configuration.getOkHttpClient();
        Response response = okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            new RuntimeException("Request failed");
        }
        return (ChatCompletionSyncResponse)JSON.parseObject((String)response.body().string(), ChatCompletionSyncResponse.class);
    }

    @Override
    public ImageCompletionResponse genImages(ImageCompletionRequest request) {
        throw new RuntimeException("\u65e7\u7248\u65e0\u56fe\u7247\u751f\u6210\u63a5\u53e3");
    }
}

