/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.chatglm.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenUtils {
    private static final Logger log = LoggerFactory.getLogger(BearerTokenUtils.class);
    private static final long expireMillis = 1800000L;
    public static Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(1740000L, TimeUnit.MILLISECONDS).build();

    public static String getToken(String apiKey, String apiSecret) {
        String token = (String)cache.getIfPresent((Object)apiKey);
        if (null != token) {
            return token;
        }
        Algorithm algorithm = Algorithm.HMAC256((byte[])apiSecret.getBytes(StandardCharsets.UTF_8));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("api_key", apiKey);
        payload.put("exp", System.currentTimeMillis() + 1800000L);
        payload.put("timestamp", Calendar.getInstance().getTimeInMillis());
        HashMap<String, String> headerClaims = new HashMap<String, String>();
        headerClaims.put("alg", "HS256");
        headerClaims.put("sign_type", "SIGN");
        token = JWT.create().withPayload(payload).withHeader(headerClaims).sign(algorithm);
        cache.put((Object)apiKey, (Object)token);
        return token;
    }
}

