/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.aliyun;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.aliyun.config.AliModelConfig;
import cn.bugstack.openai.executor.model.aliyun.valobj.AliModelCompletionRequest;
import cn.bugstack.openai.executor.model.aliyun.valobj.AliModelCompletionResponse;
import cn.bugstack.openai.executor.model.aliyun.valobj.FinishReason;
import cn.bugstack.openai.executor.model.aliyun.valobj.Message;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.parameter.Usage;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliModelExecutor
implements Executor,
ResultHandler,
ParameterHandler<AliModelCompletionRequest> {
    private static final Logger log = LoggerFactory.getLogger(AliModelExecutor.class);
    private final EventSource.Factory factory;
    private final AliModelConfig aliModelConfig;

    public AliModelExecutor(Configuration configuration) {
        this.aliModelConfig = configuration.getAliModelConfig();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        AliModelCompletionRequest aliModelCompletionRequest = this.getParameterObject(completionRequest);
        Request request = new Request.Builder().header("Authorization", "Bearer " + this.aliModelConfig.getApiKey()).header("Accept", "text/event-stream").url(this.aliModelConfig.getApiHost().concat(this.aliModelConfig.getV1_completions())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JSON.toJSONString((Object)aliModelCompletionRequest))).build();
        return this.factory.newEventSource(request, this.eventSourceListener(eventSourceListener));
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return null;
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    @Override
    public AliModelCompletionRequest getParameterObject(CompletionRequest completionRequest) {
        AliModelCompletionRequest aliModelCompletionRequest = new AliModelCompletionRequest();
        aliModelCompletionRequest.setModel(completionRequest.getModel());
        AliModelCompletionRequest.Input input = new AliModelCompletionRequest.Input();
        List<cn.bugstack.openai.executor.parameter.Message> messages = completionRequest.getMessages();
        ArrayList<Message> aliMessages = new ArrayList<Message>();
        for (cn.bugstack.openai.executor.parameter.Message message : messages) {
            aliMessages.add(Message.builder().role(message.getRole()).content(message.getContent()).build());
        }
        input.setMessages(aliMessages);
        aliModelCompletionRequest.setInput(input);
        aliModelCompletionRequest.setParameters(AliModelCompletionRequest.Parameters.builder().incrementalOutput(true).build());
        System.out.println(JSON.toJSONString((Object)aliModelCompletionRequest));
        return aliModelCompletionRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(final EventSourceListener eventSourceListener) {
        return new EventSourceListener(){

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                AliModelCompletionResponse response = (AliModelCompletionResponse)JSON.parseObject((String)data, AliModelCompletionResponse.class);
                if (FinishReason.CONTINUE.getCode().equals(response.getOutput().getFinish_reason())) {
                    CompletionResponse completionResponse = new CompletionResponse();
                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setDelta(cn.bugstack.openai.executor.parameter.Message.builder().role(CompletionRequest.Role.SYSTEM).name("").content(response.getOutput().getText()).build());
                    choices.add(chatChoice);
                    completionResponse.setChoices(choices);
                    eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)completionResponse));
                } else if (FinishReason.STOP.getCode().equals(response.getOutput().getFinish_reason())) {
                    AliModelCompletionResponse.Usage aliUsage = response.getUsage();
                    Usage usage = new Usage();
                    usage.setPromptTokens(aliUsage.getInput_tokens().intValue());
                    usage.setCompletionTokens(aliUsage.getOutput_tokens().intValue());
                    usage.setTotalTokens(aliUsage.getTotal_tokens().intValue());
                    ArrayList<ChatChoice> choices = new ArrayList<ChatChoice>();
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setFinishReason("stop");
                    chatChoice.setDelta(cn.bugstack.openai.executor.parameter.Message.builder().name("").role(CompletionRequest.Role.SYSTEM).content(response.getOutput().getText()).build());
                    choices.add(chatChoice);
                    CompletionResponse completionResponse = new CompletionResponse();
                    completionResponse.setChoices(choices);
                    completionResponse.setUsage(usage);
                    completionResponse.setCreated(System.currentTimeMillis());
                    eventSourceListener.onEvent(eventSource, id, type, JSON.toJSONString((Object)completionResponse));
                } else {
                    this.onClosed(eventSource);
                }
            }

            public void onClosed(EventSource eventSource) {
                eventSourceListener.onClosed(eventSource);
            }

            public void onOpen(EventSource eventSource, Response response) {
                eventSourceListener.onOpen(eventSource, response);
            }

            public void onFailure(EventSource eventSource, @javax.annotation.Nullable Throwable t, @javax.annotation.Nullable Response response) {
                eventSourceListener.onFailure(eventSource, t, response);
            }
        };
    }
}

