/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.brain360;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.model.brain360.config.Brain360Config;
import cn.bugstack.openai.executor.model.brain360.valobj.Brain360CompletionRequest;
import cn.bugstack.openai.executor.model.brain360.valobj.Message;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.ParameterHandler;
import cn.bugstack.openai.executor.result.ResultHandler;
import cn.bugstack.openai.session.Configuration;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

public class Brain360ModelExecutor
implements Executor,
ParameterHandler<Brain360CompletionRequest>,
ResultHandler {
    private final Brain360Config brain360Config;
    private final EventSource.Factory factory;

    public Brain360ModelExecutor(Configuration configuration) {
        this.brain360Config = configuration.getBrain360Config();
        this.factory = configuration.createRequestFactory();
    }

    @Override
    public EventSource completions(CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        return this.completions(null, null, completionRequest, eventSourceListener);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        if (!completionRequest.isStream()) {
            throw new RuntimeException("illegal parameter stream is false!");
        }
        String apiHost = null == apiHostByUser ? this.brain360Config.getApiHost() : apiHostByUser;
        String apiKey = null == apiKeyByUser ? this.brain360Config.getApiKey() : apiKeyByUser;
        Brain360CompletionRequest brain360CompletionRequest = this.getParameterObject(completionRequest);
        Request request = new Request.Builder().header("Authorization", "Bearer " + apiKey).url(apiHost.concat(this.brain360Config.getV1_chat_completions())).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)brain360CompletionRequest))).build();
        return this.factory.newEventSource(request, eventSourceListener);
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    @Override
    public Brain360CompletionRequest getParameterObject(CompletionRequest completionRequest) {
        ArrayList<Message> brainMessage = new ArrayList<Message>();
        for (cn.bugstack.openai.executor.parameter.Message message : completionRequest.getMessages()) {
            Message messageVo = new Message();
            messageVo.setContent(messageVo.getContent());
            messageVo.setRole(message.getRole());
            brainMessage.add(messageVo);
        }
        Brain360CompletionRequest brain360CompletionRequest = new Brain360CompletionRequest();
        brain360CompletionRequest.setModel(completionRequest.getModel());
        brain360CompletionRequest.setTemperature(completionRequest.getTemperature());
        brain360CompletionRequest.setTopP(completionRequest.getTopP());
        brain360CompletionRequest.setStream(completionRequest.isStream());
        brain360CompletionRequest.setMessages(brainMessage);
        return brain360CompletionRequest;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }
}

