/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.chatglm.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGLMConfig {
    private static final Logger log = LoggerFactory.getLogger(ChatGLMConfig.class);
    private String apiHost = "https://open.bigmodel.cn/api/paas/";
    private String v3_completions = "api/paas/v3/model-api/{model}/sse-invoke";
    private String apiSecretKey;
    private String apiKey;
    private String apiSecret;

    public void setApiSecretKey(String apiSecretKey) {
        this.apiSecretKey = apiSecretKey;
        if (StringUtils.isBlank((CharSequence)apiSecretKey)) {
            log.warn("not apiSecretKey set");
        } else {
            String[] arrStr = apiSecretKey.split("\\.");
            if (arrStr.length != 2) {
                throw new RuntimeException("invalid apiSecretKey");
            }
            this.apiKey = arrStr[0];
            this.apiSecret = arrStr[1];
        }
    }

    public ChatGLMConfig() {
    }

    public ChatGLMConfig(String apiHost, String v3_completions, String apiSecretKey, String apiKey, String apiSecret) {
        this.apiHost = apiHost;
        this.v3_completions = v3_completions;
        this.apiSecretKey = apiSecretKey;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getV3_completions() {
        return this.v3_completions;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }
}

