/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.google;

import cn.bugstack.openai.executor.model.google.PalmModelExecutor;
import cn.bugstack.openai.executor.model.google.config.Const;
import cn.bugstack.openai.executor.model.google.valobj.model.Model;
import cn.bugstack.openai.executor.model.google.valobj.model.PalmModel;
import cn.bugstack.openai.executor.model.google.valobj.request.PalmTextRequest;
import cn.bugstack.openai.executor.model.google.valobj.request.TextPrompt;
import cn.bugstack.openai.executor.model.google.valobj.response.Candidate;
import cn.bugstack.openai.executor.model.google.valobj.response.PalmCompletionResponse;
import cn.bugstack.openai.executor.parameter.ChatChoice;
import cn.bugstack.openai.executor.parameter.CompletionRequest;
import cn.bugstack.openai.executor.parameter.CompletionResponse;
import cn.bugstack.openai.executor.parameter.ImageRequest;
import cn.bugstack.openai.executor.parameter.ImageResponse;
import cn.bugstack.openai.executor.parameter.Message;
import cn.bugstack.openai.session.Configuration;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

public class PalmTextModelExecutor
extends PalmModelExecutor<PalmTextRequest> {
    public PalmTextModelExecutor(Configuration configuration) {
        super(configuration);
    }

    @Override
    public EventSource completions(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest, EventSourceListener eventSourceListener) throws Exception {
        final Request request = this.getRequest(apiHostByUser, apiKeyByUser, completionRequest);
        final Call call = this.getOkHttpClient().newCall(request);
        call.enqueue((Callback)new ResponseCallBack(eventSourceListener));
        return new EventSource(){

            public Request request() {
                return request;
            }

            public void cancel() {
                call.cancel();
            }
        };
    }

    @Override
    public ImageResponse genImages(ImageRequest imageRequest) {
        return null;
    }

    @Override
    public ImageResponse genImages(String apiHostByUser, String apiKeyByUser, ImageRequest imageRequest) {
        return null;
    }

    private Request getRequest(String apiHostByUser, String apiKeyByUser, CompletionRequest completionRequest) throws JsonProcessingException {
        String apiHost = apiHostByUser == null || apiHostByUser.length() == 0 ? this.getPalmConfig().getApiHost() : apiHostByUser;
        String apiKey = apiKeyByUser == null || apiKeyByUser.length() == 0 ? this.getPalmConfig().getApiKey() : apiKeyByUser;
        Model model = PalmModel.getModel(completionRequest.getModel());
        if (model == null) {
            throw new RuntimeException("model must not be null!");
        }
        PalmTextRequest palmTextRequest = this.getParameterObject(completionRequest);
        return new Request.Builder().addHeader("Content-Type", "application/json").url(String.format("%s%s%s:%s?key=%s", apiHost, Const.v2_completions, model.getName(), model.getSupportMethod().getGenerateMethod(), apiKey)).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new ObjectMapper().writeValueAsString((Object)palmTextRequest))).build();
    }

    @Override
    public PalmTextRequest getParameterObject(CompletionRequest completionRequest) {
        List<Message> messages = completionRequest.getMessages();
        PalmTextRequest request = new PalmTextRequest();
        if (messages == null || messages.size() == 0) {
            return request;
        }
        TextPrompt textPrompt = new TextPrompt();
        textPrompt.setText(messages.get(0).getContent());
        request.setTemperature(completionRequest.getTemperature());
        request.setTopP(completionRequest.getTopP());
        request.setPrompt(textPrompt);
        return request;
    }

    @Override
    public EventSourceListener eventSourceListener(EventSourceListener eventSourceListener) {
        return eventSourceListener;
    }

    private static class ResponseCallBack
    implements Callback {
        private final EventSourceListener eventSourceListener;

        public ResponseCallBack(EventSourceListener eventSourceListener) {
            this.eventSourceListener = eventSourceListener;
        }

        public void onFailure(Call call, IOException e) {
            call.cancel();
        }

        public void onResponse(Call call, Response response) throws IOException {
            CompletionResponse completionResponse = new CompletionResponse();
            ResponseBody body = response.body();
            ArrayList<ChatChoice> chatChoices = new ArrayList<ChatChoice>();
            completionResponse.setChoices(chatChoices);
            if (response.isSuccessful() && body != null) {
                PalmCompletionResponse palmCompletionResponse = (PalmCompletionResponse)JSON.parseObject((String)body.string(), PalmCompletionResponse.class);
                List<Candidate> candidates = palmCompletionResponse.getCandidates();
                for (Candidate candidate : candidates) {
                    ChatChoice chatChoice = new ChatChoice();
                    chatChoice.setDelta(Message.builder().role(CompletionRequest.Role.SYSTEM).name(completionResponse.getModel()).content(candidate.getOutput()).build());
                    chatChoices.add(chatChoice);
                }
            }
            ChatChoice chatChoice = new ChatChoice();
            chatChoice.setFinishReason("stop");
            chatChoice.setDelta(new Message());
            chatChoices.add(chatChoice);
            this.eventSourceListener.onEvent(new EventSource(){

                public Request request() {
                    return null;
                }

                public void cancel() {
                }
            }, null, null, JSON.toJSONString((Object)completionResponse));
        }
    }
}

