/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.executor.model.tencent.utils;

import cn.bugstack.openai.executor.model.tencent.config.TencentConfig;
import cn.bugstack.openai.executor.model.tencent.valobj.CanonicalRequest;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtils {
    public static final String DEFAULT_ALGORITHM = "TC3-HMAC-SHA256";
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();

    public static String printHexBinary(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(hexCode[b >> 4 & 0xF]);
            sb.append(hexCode[b & 0xF]);
        }
        return sb.toString();
    }

    public static String sha256Hex(String str) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] hash = md.digest(str.getBytes(StandardCharsets.UTF_8));
        return SecurityUtils.printHexBinary(hash).toLowerCase();
    }

    public static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
    }

    public static String hmac256Hex(byte[] key, String msg) throws Exception {
        byte[] bytes = SecurityUtils.hmac256(key, msg);
        return SecurityUtils.printHexBinary(bytes).toLowerCase();
    }

    public static String getAuthorization(String requestPayload, String timestamp, TencentConfig config) {
        try {
            URL url = new URL(config.getApiHost());
            String secretId = config.getSecretId();
            String secretKey = config.getSecretKey();
            HashMap<String, String> canonicalHeaders = new HashMap<String, String>();
            canonicalHeaders.put("Content-Type", "application/json; charset=utf-8");
            canonicalHeaders.put("Host", url.getHost());
            String hashedRequestPayload = SecurityUtils.sha256Hex(requestPayload);
            String service = url.getHost().split("\\.")[0];
            String canonicalRequest = CanonicalRequest.builder().httpRequestMethod("POST").canonicalURI("/").canonicalQueryString("").canonicalHeaders(canonicalHeaders).signedHeaders(canonicalHeaders.keySet()).hashedRequestPayload(hashedRequestPayload).build().toString();
            DEFAULT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = DEFAULT_DATE_FORMAT.format(new Date(Long.parseLong(timestamp + "000")));
            String credentialScope = date + "/" + service + "/tc3_request";
            String hashedCanonicalRequest = SecurityUtils.sha256Hex(canonicalRequest);
            String stringToSign = "TC3-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
            byte[] secretDate = SecurityUtils.hmac256(("TC3" + secretKey).getBytes(StandardCharsets.UTF_8), date);
            byte[] secretService = SecurityUtils.hmac256(secretDate, service);
            byte[] secretSigning = SecurityUtils.hmac256(secretService, "tc3_request");
            String signature = SecurityUtils.hmac256Hex(secretSigning, stringToSign);
            String signedHeaders = CanonicalRequest.formatSignedHeaders(canonicalHeaders.keySet());
            return "TC3-HMAC-SHA256 Credential=" + secretId + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to get authentication headers", e);
        }
    }
}

