/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.openai.session.defaults;

import cn.bugstack.openai.executor.Executor;
import cn.bugstack.openai.executor.interceptor.HTTPInterceptor;
import cn.bugstack.openai.session.Configuration;
import cn.bugstack.openai.session.OpenAiSession;
import cn.bugstack.openai.session.OpenAiSessionFactory;
import cn.bugstack.openai.session.defaults.DefaultOpenAiSession;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class DefaultOpenAiSessionFactory
implements OpenAiSessionFactory {
    private final Configuration configuration;

    public DefaultOpenAiSessionFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public OpenAiSession openSession() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(this.configuration.getLevel());
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)new HTTPInterceptor(this.configuration)).connectTimeout(this.configuration.getConnectTimeout(), TimeUnit.SECONDS).writeTimeout(this.configuration.getWriteTimeout(), TimeUnit.SECONDS).readTimeout(this.configuration.getReadTimeout(), TimeUnit.SECONDS).build();
        this.configuration.setOkHttpClient(okHttpClient);
        HashMap<String, Executor> executorGroup = this.configuration.newExecutorGroup();
        return new DefaultOpenAiSession(this.configuration, executorGroup);
    }
}

